/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains the latest status details for an edge agent's recorder and uploader jobs. Use this
 * information to determine the current health of an edge agent.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EdgeAgentStatus implements SdkPojo, Serializable, ToCopyableBuilder<EdgeAgentStatus.Builder, EdgeAgentStatus> {
    private static final SdkField<LastRecorderStatus> LAST_RECORDER_STATUS_FIELD = SdkField
            .<LastRecorderStatus> builder(MarshallingType.SDK_POJO).memberName("LastRecorderStatus")
            .getter(getter(EdgeAgentStatus::lastRecorderStatus)).setter(setter(Builder::lastRecorderStatus))
            .constructor(LastRecorderStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRecorderStatus").build())
            .build();

    private static final SdkField<LastUploaderStatus> LAST_UPLOADER_STATUS_FIELD = SdkField
            .<LastUploaderStatus> builder(MarshallingType.SDK_POJO).memberName("LastUploaderStatus")
            .getter(getter(EdgeAgentStatus::lastUploaderStatus)).setter(setter(Builder::lastUploaderStatus))
            .constructor(LastUploaderStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUploaderStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_RECORDER_STATUS_FIELD,
            LAST_UPLOADER_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final LastRecorderStatus lastRecorderStatus;

    private final LastUploaderStatus lastUploaderStatus;

    private EdgeAgentStatus(BuilderImpl builder) {
        this.lastRecorderStatus = builder.lastRecorderStatus;
        this.lastUploaderStatus = builder.lastUploaderStatus;
    }

    /**
     * <p>
     * The latest status of a stream’s edge recording job.
     * </p>
     * 
     * @return The latest status of a stream’s edge recording job.
     */
    public final LastRecorderStatus lastRecorderStatus() {
        return lastRecorderStatus;
    }

    /**
     * <p>
     * The latest status of a stream’s edge to cloud uploader job.
     * </p>
     * 
     * @return The latest status of a stream’s edge to cloud uploader job.
     */
    public final LastUploaderStatus lastUploaderStatus() {
        return lastUploaderStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lastRecorderStatus());
        hashCode = 31 * hashCode + Objects.hashCode(lastUploaderStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EdgeAgentStatus)) {
            return false;
        }
        EdgeAgentStatus other = (EdgeAgentStatus) obj;
        return Objects.equals(lastRecorderStatus(), other.lastRecorderStatus())
                && Objects.equals(lastUploaderStatus(), other.lastUploaderStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EdgeAgentStatus").add("LastRecorderStatus", lastRecorderStatus())
                .add("LastUploaderStatus", lastUploaderStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LastRecorderStatus":
            return Optional.ofNullable(clazz.cast(lastRecorderStatus()));
        case "LastUploaderStatus":
            return Optional.ofNullable(clazz.cast(lastUploaderStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EdgeAgentStatus, T> g) {
        return obj -> g.apply((EdgeAgentStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EdgeAgentStatus> {
        /**
         * <p>
         * The latest status of a stream’s edge recording job.
         * </p>
         * 
         * @param lastRecorderStatus
         *        The latest status of a stream’s edge recording job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastRecorderStatus(LastRecorderStatus lastRecorderStatus);

        /**
         * <p>
         * The latest status of a stream’s edge recording job.
         * </p>
         * This is a convenience method that creates an instance of the {@link LastRecorderStatus.Builder} avoiding the
         * need to create one manually via {@link LastRecorderStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LastRecorderStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #lastRecorderStatus(LastRecorderStatus)}.
         * 
         * @param lastRecorderStatus
         *        a consumer that will call methods on {@link LastRecorderStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastRecorderStatus(LastRecorderStatus)
         */
        default Builder lastRecorderStatus(Consumer<LastRecorderStatus.Builder> lastRecorderStatus) {
            return lastRecorderStatus(LastRecorderStatus.builder().applyMutation(lastRecorderStatus).build());
        }

        /**
         * <p>
         * The latest status of a stream’s edge to cloud uploader job.
         * </p>
         * 
         * @param lastUploaderStatus
         *        The latest status of a stream’s edge to cloud uploader job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUploaderStatus(LastUploaderStatus lastUploaderStatus);

        /**
         * <p>
         * The latest status of a stream’s edge to cloud uploader job.
         * </p>
         * This is a convenience method that creates an instance of the {@link LastUploaderStatus.Builder} avoiding the
         * need to create one manually via {@link LastUploaderStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LastUploaderStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #lastUploaderStatus(LastUploaderStatus)}.
         * 
         * @param lastUploaderStatus
         *        a consumer that will call methods on {@link LastUploaderStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastUploaderStatus(LastUploaderStatus)
         */
        default Builder lastUploaderStatus(Consumer<LastUploaderStatus.Builder> lastUploaderStatus) {
            return lastUploaderStatus(LastUploaderStatus.builder().applyMutation(lastUploaderStatus).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LastRecorderStatus lastRecorderStatus;

        private LastUploaderStatus lastUploaderStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(EdgeAgentStatus model) {
            lastRecorderStatus(model.lastRecorderStatus);
            lastUploaderStatus(model.lastUploaderStatus);
        }

        public final LastRecorderStatus.Builder getLastRecorderStatus() {
            return lastRecorderStatus != null ? lastRecorderStatus.toBuilder() : null;
        }

        public final void setLastRecorderStatus(LastRecorderStatus.BuilderImpl lastRecorderStatus) {
            this.lastRecorderStatus = lastRecorderStatus != null ? lastRecorderStatus.build() : null;
        }

        @Override
        public final Builder lastRecorderStatus(LastRecorderStatus lastRecorderStatus) {
            this.lastRecorderStatus = lastRecorderStatus;
            return this;
        }

        public final LastUploaderStatus.Builder getLastUploaderStatus() {
            return lastUploaderStatus != null ? lastUploaderStatus.toBuilder() : null;
        }

        public final void setLastUploaderStatus(LastUploaderStatus.BuilderImpl lastUploaderStatus) {
            this.lastUploaderStatus = lastUploaderStatus != null ? lastUploaderStatus.build() : null;
        }

        @Override
        public final Builder lastUploaderStatus(LastUploaderStatus lastUploaderStatus) {
            this.lastUploaderStatus = lastUploaderStatus;
            return this;
        }

        @Override
        public EdgeAgentStatus build() {
            return new EdgeAgentStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
