/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The S3 bucket that holds the application information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3ContentBaseLocation implements SdkPojo, Serializable,
        ToCopyableBuilder<S3ContentBaseLocation.Builder, S3ContentBaseLocation> {
    private static final SdkField<String> BUCKET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BucketARN").getter(getter(S3ContentBaseLocation::bucketARN)).setter(setter(Builder::bucketARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketARN").build()).build();

    private static final SdkField<String> BASE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BasePath").getter(getter(S3ContentBaseLocation::basePath)).setter(setter(Builder::basePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BasePath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_ARN_FIELD,
            BASE_PATH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bucketARN;

    private final String basePath;

    private S3ContentBaseLocation(BuilderImpl builder) {
        this.bucketARN = builder.bucketARN;
        this.basePath = builder.basePath;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the S3 bucket.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the S3 bucket.
     */
    public final String bucketARN() {
        return bucketARN;
    }

    /**
     * <p>
     * The base path for the S3 bucket.
     * </p>
     * 
     * @return The base path for the S3 bucket.
     */
    public final String basePath() {
        return basePath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucketARN());
        hashCode = 31 * hashCode + Objects.hashCode(basePath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ContentBaseLocation)) {
            return false;
        }
        S3ContentBaseLocation other = (S3ContentBaseLocation) obj;
        return Objects.equals(bucketARN(), other.bucketARN()) && Objects.equals(basePath(), other.basePath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3ContentBaseLocation").add("BucketARN", bucketARN()).add("BasePath", basePath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BucketARN":
            return Optional.ofNullable(clazz.cast(bucketARN()));
        case "BasePath":
            return Optional.ofNullable(clazz.cast(basePath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3ContentBaseLocation, T> g) {
        return obj -> g.apply((S3ContentBaseLocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3ContentBaseLocation> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the S3 bucket.
         * </p>
         * 
         * @param bucketARN
         *        The Amazon Resource Name (ARN) of the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketARN(String bucketARN);

        /**
         * <p>
         * The base path for the S3 bucket.
         * </p>
         * 
         * @param basePath
         *        The base path for the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder basePath(String basePath);
    }

    static final class BuilderImpl implements Builder {
        private String bucketARN;

        private String basePath;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ContentBaseLocation model) {
            bucketARN(model.bucketARN);
            basePath(model.basePath);
        }

        public final String getBucketARN() {
            return bucketARN;
        }

        public final void setBucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
        }

        @Override
        public final Builder bucketARN(String bucketARN) {
            this.bucketARN = bucketARN;
            return this;
        }

        public final String getBasePath() {
            return basePath;
        }

        public final void setBasePath(String basePath) {
            this.basePath = basePath;
        }

        @Override
        public final Builder basePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        @Override
        public S3ContentBaseLocation build() {
            return new S3ContentBaseLocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
