/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * For a SQL-based Kinesis Data Analytics application, describes updates to an <a>InputProcessingConfiguration</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputProcessingConfigurationUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<InputProcessingConfigurationUpdate.Builder, InputProcessingConfigurationUpdate> {
    private static final SdkField<InputLambdaProcessorUpdate> INPUT_LAMBDA_PROCESSOR_UPDATE_FIELD = SdkField
            .<InputLambdaProcessorUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("InputLambdaProcessorUpdate")
            .getter(getter(InputProcessingConfigurationUpdate::inputLambdaProcessorUpdate))
            .setter(setter(Builder::inputLambdaProcessorUpdate))
            .constructor(InputLambdaProcessorUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputLambdaProcessorUpdate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(INPUT_LAMBDA_PROCESSOR_UPDATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final InputLambdaProcessorUpdate inputLambdaProcessorUpdate;

    private InputProcessingConfigurationUpdate(BuilderImpl builder) {
        this.inputLambdaProcessorUpdate = builder.inputLambdaProcessorUpdate;
    }

    /**
     * <p>
     * Provides update information for an <a>InputLambdaProcessor</a>.
     * </p>
     * 
     * @return Provides update information for an <a>InputLambdaProcessor</a>.
     */
    public final InputLambdaProcessorUpdate inputLambdaProcessorUpdate() {
        return inputLambdaProcessorUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputLambdaProcessorUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputProcessingConfigurationUpdate)) {
            return false;
        }
        InputProcessingConfigurationUpdate other = (InputProcessingConfigurationUpdate) obj;
        return Objects.equals(inputLambdaProcessorUpdate(), other.inputLambdaProcessorUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputProcessingConfigurationUpdate")
                .add("InputLambdaProcessorUpdate", inputLambdaProcessorUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputLambdaProcessorUpdate":
            return Optional.ofNullable(clazz.cast(inputLambdaProcessorUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputProcessingConfigurationUpdate, T> g) {
        return obj -> g.apply((InputProcessingConfigurationUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputProcessingConfigurationUpdate> {
        /**
         * <p>
         * Provides update information for an <a>InputLambdaProcessor</a>.
         * </p>
         * 
         * @param inputLambdaProcessorUpdate
         *        Provides update information for an <a>InputLambdaProcessor</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputLambdaProcessorUpdate(InputLambdaProcessorUpdate inputLambdaProcessorUpdate);

        /**
         * <p>
         * Provides update information for an <a>InputLambdaProcessor</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link InputLambdaProcessorUpdate.Builder}
         * avoiding the need to create one manually via {@link InputLambdaProcessorUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InputLambdaProcessorUpdate.Builder#build()} is called immediately
         * and its result is passed to {@link #inputLambdaProcessorUpdate(InputLambdaProcessorUpdate)}.
         * 
         * @param inputLambdaProcessorUpdate
         *        a consumer that will call methods on {@link InputLambdaProcessorUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputLambdaProcessorUpdate(InputLambdaProcessorUpdate)
         */
        default Builder inputLambdaProcessorUpdate(Consumer<InputLambdaProcessorUpdate.Builder> inputLambdaProcessorUpdate) {
            return inputLambdaProcessorUpdate(InputLambdaProcessorUpdate.builder().applyMutation(inputLambdaProcessorUpdate)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private InputLambdaProcessorUpdate inputLambdaProcessorUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(InputProcessingConfigurationUpdate model) {
            inputLambdaProcessorUpdate(model.inputLambdaProcessorUpdate);
        }

        public final InputLambdaProcessorUpdate.Builder getInputLambdaProcessorUpdate() {
            return inputLambdaProcessorUpdate != null ? inputLambdaProcessorUpdate.toBuilder() : null;
        }

        public final void setInputLambdaProcessorUpdate(InputLambdaProcessorUpdate.BuilderImpl inputLambdaProcessorUpdate) {
            this.inputLambdaProcessorUpdate = inputLambdaProcessorUpdate != null ? inputLambdaProcessorUpdate.build() : null;
        }

        @Override
        public final Builder inputLambdaProcessorUpdate(InputLambdaProcessorUpdate inputLambdaProcessorUpdate) {
            this.inputLambdaProcessorUpdate = inputLambdaProcessorUpdate;
            return this;
        }

        @Override
        public InputProcessingConfigurationUpdate build() {
            return new InputProcessingConfigurationUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
