/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes updates for the application's input schema.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputSchemaUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<InputSchemaUpdate.Builder, InputSchemaUpdate> {
    private static final SdkField<RecordFormat> RECORD_FORMAT_UPDATE_FIELD = SdkField
            .<RecordFormat> builder(MarshallingType.SDK_POJO).memberName("RecordFormatUpdate")
            .getter(getter(InputSchemaUpdate::recordFormatUpdate)).setter(setter(Builder::recordFormatUpdate))
            .constructor(RecordFormat::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordFormatUpdate").build())
            .build();

    private static final SdkField<String> RECORD_ENCODING_UPDATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecordEncodingUpdate").getter(getter(InputSchemaUpdate::recordEncodingUpdate))
            .setter(setter(Builder::recordEncodingUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordEncodingUpdate").build())
            .build();

    private static final SdkField<List<RecordColumn>> RECORD_COLUMN_UPDATES_FIELD = SdkField
            .<List<RecordColumn>> builder(MarshallingType.LIST)
            .memberName("RecordColumnUpdates")
            .getter(getter(InputSchemaUpdate::recordColumnUpdates))
            .setter(setter(Builder::recordColumnUpdates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordColumnUpdates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecordColumn> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecordColumn::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORD_FORMAT_UPDATE_FIELD,
            RECORD_ENCODING_UPDATE_FIELD, RECORD_COLUMN_UPDATES_FIELD));

    private static final long serialVersionUID = 1L;

    private final RecordFormat recordFormatUpdate;

    private final String recordEncodingUpdate;

    private final List<RecordColumn> recordColumnUpdates;

    private InputSchemaUpdate(BuilderImpl builder) {
        this.recordFormatUpdate = builder.recordFormatUpdate;
        this.recordEncodingUpdate = builder.recordEncodingUpdate;
        this.recordColumnUpdates = builder.recordColumnUpdates;
    }

    /**
     * <p>
     * Specifies the format of the records on the streaming source.
     * </p>
     * 
     * @return Specifies the format of the records on the streaming source.
     */
    public final RecordFormat recordFormatUpdate() {
        return recordFormatUpdate;
    }

    /**
     * <p>
     * Specifies the encoding of the records in the streaming source. For example, UTF-8.
     * </p>
     * 
     * @return Specifies the encoding of the records in the streaming source. For example, UTF-8.
     */
    public final String recordEncodingUpdate() {
        return recordEncodingUpdate;
    }

    /**
     * For responses, this returns true if the service returned a value for the RecordColumnUpdates property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRecordColumnUpdates() {
        return recordColumnUpdates != null && !(recordColumnUpdates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>RecordColumn</code> objects. Each object describes the mapping of the streaming source element to
     * the corresponding column in the in-application stream.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecordColumnUpdates} method.
     * </p>
     * 
     * @return A list of <code>RecordColumn</code> objects. Each object describes the mapping of the streaming source
     *         element to the corresponding column in the in-application stream.
     */
    public final List<RecordColumn> recordColumnUpdates() {
        return recordColumnUpdates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recordFormatUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(recordEncodingUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(hasRecordColumnUpdates() ? recordColumnUpdates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputSchemaUpdate)) {
            return false;
        }
        InputSchemaUpdate other = (InputSchemaUpdate) obj;
        return Objects.equals(recordFormatUpdate(), other.recordFormatUpdate())
                && Objects.equals(recordEncodingUpdate(), other.recordEncodingUpdate())
                && hasRecordColumnUpdates() == other.hasRecordColumnUpdates()
                && Objects.equals(recordColumnUpdates(), other.recordColumnUpdates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputSchemaUpdate").add("RecordFormatUpdate", recordFormatUpdate())
                .add("RecordEncodingUpdate", recordEncodingUpdate())
                .add("RecordColumnUpdates", hasRecordColumnUpdates() ? recordColumnUpdates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecordFormatUpdate":
            return Optional.ofNullable(clazz.cast(recordFormatUpdate()));
        case "RecordEncodingUpdate":
            return Optional.ofNullable(clazz.cast(recordEncodingUpdate()));
        case "RecordColumnUpdates":
            return Optional.ofNullable(clazz.cast(recordColumnUpdates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputSchemaUpdate, T> g) {
        return obj -> g.apply((InputSchemaUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputSchemaUpdate> {
        /**
         * <p>
         * Specifies the format of the records on the streaming source.
         * </p>
         * 
         * @param recordFormatUpdate
         *        Specifies the format of the records on the streaming source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordFormatUpdate(RecordFormat recordFormatUpdate);

        /**
         * <p>
         * Specifies the format of the records on the streaming source.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecordFormat.Builder} avoiding the need
         * to create one manually via {@link RecordFormat#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecordFormat.Builder#build()} is called immediately and its
         * result is passed to {@link #recordFormatUpdate(RecordFormat)}.
         * 
         * @param recordFormatUpdate
         *        a consumer that will call methods on {@link RecordFormat.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recordFormatUpdate(RecordFormat)
         */
        default Builder recordFormatUpdate(Consumer<RecordFormat.Builder> recordFormatUpdate) {
            return recordFormatUpdate(RecordFormat.builder().applyMutation(recordFormatUpdate).build());
        }

        /**
         * <p>
         * Specifies the encoding of the records in the streaming source. For example, UTF-8.
         * </p>
         * 
         * @param recordEncodingUpdate
         *        Specifies the encoding of the records in the streaming source. For example, UTF-8.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordEncodingUpdate(String recordEncodingUpdate);

        /**
         * <p>
         * A list of <code>RecordColumn</code> objects. Each object describes the mapping of the streaming source
         * element to the corresponding column in the in-application stream.
         * </p>
         * 
         * @param recordColumnUpdates
         *        A list of <code>RecordColumn</code> objects. Each object describes the mapping of the streaming source
         *        element to the corresponding column in the in-application stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordColumnUpdates(Collection<RecordColumn> recordColumnUpdates);

        /**
         * <p>
         * A list of <code>RecordColumn</code> objects. Each object describes the mapping of the streaming source
         * element to the corresponding column in the in-application stream.
         * </p>
         * 
         * @param recordColumnUpdates
         *        A list of <code>RecordColumn</code> objects. Each object describes the mapping of the streaming source
         *        element to the corresponding column in the in-application stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordColumnUpdates(RecordColumn... recordColumnUpdates);

        /**
         * <p>
         * A list of <code>RecordColumn</code> objects. Each object describes the mapping of the streaming source
         * element to the corresponding column in the in-application stream.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kinesisanalytics.model.RecordColumn.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.kinesisanalytics.model.RecordColumn#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kinesisanalytics.model.RecordColumn.Builder#build()} is called
         * immediately and its result is passed to {@link #recordColumnUpdates(List<RecordColumn>)}.
         * 
         * @param recordColumnUpdates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kinesisanalytics.model.RecordColumn.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recordColumnUpdates(java.util.Collection<RecordColumn>)
         */
        Builder recordColumnUpdates(Consumer<RecordColumn.Builder>... recordColumnUpdates);
    }

    static final class BuilderImpl implements Builder {
        private RecordFormat recordFormatUpdate;

        private String recordEncodingUpdate;

        private List<RecordColumn> recordColumnUpdates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InputSchemaUpdate model) {
            recordFormatUpdate(model.recordFormatUpdate);
            recordEncodingUpdate(model.recordEncodingUpdate);
            recordColumnUpdates(model.recordColumnUpdates);
        }

        public final RecordFormat.Builder getRecordFormatUpdate() {
            return recordFormatUpdate != null ? recordFormatUpdate.toBuilder() : null;
        }

        public final void setRecordFormatUpdate(RecordFormat.BuilderImpl recordFormatUpdate) {
            this.recordFormatUpdate = recordFormatUpdate != null ? recordFormatUpdate.build() : null;
        }

        @Override
        public final Builder recordFormatUpdate(RecordFormat recordFormatUpdate) {
            this.recordFormatUpdate = recordFormatUpdate;
            return this;
        }

        public final String getRecordEncodingUpdate() {
            return recordEncodingUpdate;
        }

        public final void setRecordEncodingUpdate(String recordEncodingUpdate) {
            this.recordEncodingUpdate = recordEncodingUpdate;
        }

        @Override
        public final Builder recordEncodingUpdate(String recordEncodingUpdate) {
            this.recordEncodingUpdate = recordEncodingUpdate;
            return this;
        }

        public final List<RecordColumn.Builder> getRecordColumnUpdates() {
            List<RecordColumn.Builder> result = RecordColumnsCopier.copyToBuilder(this.recordColumnUpdates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecordColumnUpdates(Collection<RecordColumn.BuilderImpl> recordColumnUpdates) {
            this.recordColumnUpdates = RecordColumnsCopier.copyFromBuilder(recordColumnUpdates);
        }

        @Override
        public final Builder recordColumnUpdates(Collection<RecordColumn> recordColumnUpdates) {
            this.recordColumnUpdates = RecordColumnsCopier.copy(recordColumnUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordColumnUpdates(RecordColumn... recordColumnUpdates) {
            recordColumnUpdates(Arrays.asList(recordColumnUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordColumnUpdates(Consumer<RecordColumn.Builder>... recordColumnUpdates) {
            recordColumnUpdates(Stream.of(recordColumnUpdates).map(c -> RecordColumn.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public InputSchemaUpdate build() {
            return new InputSchemaUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
