/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot1clickdevices.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDeviceMethodsResponse extends Iot1ClickDevicesResponse implements
        ToCopyableBuilder<GetDeviceMethodsResponse.Builder, GetDeviceMethodsResponse> {
    private static final SdkField<List<DeviceMethod>> DEVICE_METHODS_FIELD = SdkField
            .<List<DeviceMethod>> builder(MarshallingType.LIST)
            .memberName("DeviceMethods")
            .getter(getter(GetDeviceMethodsResponse::deviceMethods))
            .setter(setter(Builder::deviceMethods))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceMethods").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeviceMethod> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeviceMethod::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_METHODS_FIELD));

    private final List<DeviceMethod> deviceMethods;

    private GetDeviceMethodsResponse(BuilderImpl builder) {
        super(builder);
        this.deviceMethods = builder.deviceMethods;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeviceMethods property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDeviceMethods() {
        return deviceMethods != null && !(deviceMethods instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of available device APIs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeviceMethods} method.
     * </p>
     * 
     * @return List of available device APIs.
     */
    public final List<DeviceMethod> deviceMethods() {
        return deviceMethods;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDeviceMethods() ? deviceMethods() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeviceMethodsResponse)) {
            return false;
        }
        GetDeviceMethodsResponse other = (GetDeviceMethodsResponse) obj;
        return hasDeviceMethods() == other.hasDeviceMethods() && Objects.equals(deviceMethods(), other.deviceMethods());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDeviceMethodsResponse").add("DeviceMethods", hasDeviceMethods() ? deviceMethods() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceMethods":
            return Optional.ofNullable(clazz.cast(deviceMethods()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDeviceMethodsResponse, T> g) {
        return obj -> g.apply((GetDeviceMethodsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Iot1ClickDevicesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDeviceMethodsResponse> {
        /**
         * <p>
         * List of available device APIs.
         * </p>
         * 
         * @param deviceMethods
         *        List of available device APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceMethods(Collection<DeviceMethod> deviceMethods);

        /**
         * <p>
         * List of available device APIs.
         * </p>
         * 
         * @param deviceMethods
         *        List of available device APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceMethods(DeviceMethod... deviceMethods);

        /**
         * <p>
         * List of available device APIs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iot1clickdevices.model.DeviceMethod.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.iot1clickdevices.model.DeviceMethod#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iot1clickdevices.model.DeviceMethod.Builder#build()} is called
         * immediately and its result is passed to {@link #deviceMethods(List<DeviceMethod>)}.
         * 
         * @param deviceMethods
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iot1clickdevices.model.DeviceMethod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceMethods(java.util.Collection<DeviceMethod>)
         */
        Builder deviceMethods(Consumer<DeviceMethod.Builder>... deviceMethods);
    }

    static final class BuilderImpl extends Iot1ClickDevicesResponse.BuilderImpl implements Builder {
        private List<DeviceMethod> deviceMethods = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeviceMethodsResponse model) {
            super(model);
            deviceMethods(model.deviceMethods);
        }

        public final List<DeviceMethod.Builder> getDeviceMethods() {
            List<DeviceMethod.Builder> result = ___listOfDeviceMethodCopier.copyToBuilder(this.deviceMethods);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeviceMethods(Collection<DeviceMethod.BuilderImpl> deviceMethods) {
            this.deviceMethods = ___listOfDeviceMethodCopier.copyFromBuilder(deviceMethods);
        }

        @Override
        public final Builder deviceMethods(Collection<DeviceMethod> deviceMethods) {
            this.deviceMethods = ___listOfDeviceMethodCopier.copy(deviceMethods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceMethods(DeviceMethod... deviceMethods) {
            deviceMethods(Arrays.asList(deviceMethods));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceMethods(Consumer<DeviceMethod.Builder>... deviceMethods) {
            deviceMethods(Stream.of(deviceMethods).map(c -> DeviceMethod.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetDeviceMethodsResponse build() {
            return new GetDeviceMethodsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
