/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies MQTT Version 5.0 headers information. For more information, see <a
 * href="https://docs.aws.amazon.com/iot/latest/developerguide/mqtt.html"> MQTT</a> from Amazon Web Services IoT Core
 * Developer Guide.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MqttHeaders implements SdkPojo, Serializable, ToCopyableBuilder<MqttHeaders.Builder, MqttHeaders> {
    private static final SdkField<String> PAYLOAD_FORMAT_INDICATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("payloadFormatIndicator").getter(getter(MqttHeaders::payloadFormatIndicator))
            .setter(setter(Builder::payloadFormatIndicator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payloadFormatIndicator").build())
            .build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentType").getter(getter(MqttHeaders::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentType").build()).build();

    private static final SdkField<String> RESPONSE_TOPIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("responseTopic").getter(getter(MqttHeaders::responseTopic)).setter(setter(Builder::responseTopic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseTopic").build()).build();

    private static final SdkField<String> CORRELATION_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("correlationData").getter(getter(MqttHeaders::correlationData)).setter(setter(Builder::correlationData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("correlationData").build()).build();

    private static final SdkField<String> MESSAGE_EXPIRY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("messageExpiry").getter(getter(MqttHeaders::messageExpiry)).setter(setter(Builder::messageExpiry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageExpiry").build()).build();

    private static final SdkField<List<UserProperty>> USER_PROPERTIES_FIELD = SdkField
            .<List<UserProperty>> builder(MarshallingType.LIST)
            .memberName("userProperties")
            .getter(getter(MqttHeaders::userProperties))
            .setter(setter(Builder::userProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PAYLOAD_FORMAT_INDICATOR_FIELD, CONTENT_TYPE_FIELD, RESPONSE_TOPIC_FIELD, CORRELATION_DATA_FIELD,
            MESSAGE_EXPIRY_FIELD, USER_PROPERTIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String payloadFormatIndicator;

    private final String contentType;

    private final String responseTopic;

    private final String correlationData;

    private final String messageExpiry;

    private final List<UserProperty> userProperties;

    private MqttHeaders(BuilderImpl builder) {
        this.payloadFormatIndicator = builder.payloadFormatIndicator;
        this.contentType = builder.contentType;
        this.responseTopic = builder.responseTopic;
        this.correlationData = builder.correlationData;
        this.messageExpiry = builder.messageExpiry;
        this.userProperties = builder.userProperties;
    }

    /**
     * <p>
     * An <code>Enum</code> string value that indicates whether the payload is formatted as UTF-8.
     * </p>
     * <p>
     * Valid values are <code>UNSPECIFIED_BYTES</code> and <code>UTF8_DATA</code>.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.oasis-open.org/mqtt/mqtt/v5.0/os/mqtt-v5.0-os.html#_Toc3901111">
     * Payload Format Indicator</a> from the MQTT Version 5.0 specification.
     * </p>
     * <p>
     * Supports <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html">substitution
     * templates</a>.
     * </p>
     * 
     * @return An <code>Enum</code> string value that indicates whether the payload is formatted as UTF-8.</p>
     *         <p>
     *         Valid values are <code>UNSPECIFIED_BYTES</code> and <code>UTF8_DATA</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.oasis-open.org/mqtt/mqtt/v5.0/os/mqtt-v5.0-os.html#_Toc3901111"> Payload Format
     *         Indicator</a> from the MQTT Version 5.0 specification.
     *         </p>
     *         <p>
     *         Supports <a href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html">
     *         substitution templates</a>.
     */
    public final String payloadFormatIndicator() {
        return payloadFormatIndicator;
    }

    /**
     * <p>
     * A UTF-8 encoded string that describes the content of the publishing message.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.oasis-open.org/mqtt/mqtt/v5.0/os/mqtt-v5.0-os.html#_Toc3901118">
     * Content Type</a> from the MQTT Version 5.0 specification.
     * </p>
     * <p>
     * Supports <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html">substitution
     * templates</a>.
     * </p>
     * 
     * @return A UTF-8 encoded string that describes the content of the publishing message.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.oasis-open.org/mqtt/mqtt/v5.0/os/mqtt-v5.0-os.html#_Toc3901118"> Content Type</a> from
     *         the MQTT Version 5.0 specification.
     *         </p>
     *         <p>
     *         Supports <a href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html">
     *         substitution templates</a>.
     */
    public final String contentType() {
        return contentType;
    }

    /**
     * <p>
     * A UTF-8 encoded string that's used as the topic name for a response message. The response topic is used to
     * describe the topic which the receiver should publish to as part of the request-response flow. The topic must not
     * contain wildcard characters.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.oasis-open.org/mqtt/mqtt/v5.0/os/mqtt-v5.0-os.html#_Toc3901114">
     * Response Topic</a> from the MQTT Version 5.0 specification.
     * </p>
     * <p>
     * Supports <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html">substitution
     * templates</a>.
     * </p>
     * 
     * @return A UTF-8 encoded string that's used as the topic name for a response message. The response topic is used
     *         to describe the topic which the receiver should publish to as part of the request-response flow. The
     *         topic must not contain wildcard characters.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.oasis-open.org/mqtt/mqtt/v5.0/os/mqtt-v5.0-os.html#_Toc3901114"> Response Topic</a>
     *         from the MQTT Version 5.0 specification.
     *         </p>
     *         <p>
     *         Supports <a href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html">
     *         substitution templates</a>.
     */
    public final String responseTopic() {
        return responseTopic;
    }

    /**
     * <p>
     * The base64-encoded binary data used by the sender of the request message to identify which request the response
     * message is for when it's received.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.oasis-open.org/mqtt/mqtt/v5.0/os/mqtt-v5.0-os.html#_Toc3901115">
     * Correlation Data</a> from the MQTT Version 5.0 specification.
     * </p>
     * <note>
     * <p>
     * This binary data must be based64-encoded.
     * </p>
     * </note>
     * <p>
     * Supports <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html">substitution
     * templates</a>.
     * </p>
     * 
     * @return The base64-encoded binary data used by the sender of the request message to identify which request the
     *         response message is for when it's received.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.oasis-open.org/mqtt/mqtt/v5.0/os/mqtt-v5.0-os.html#_Toc3901115"> Correlation Data</a>
     *         from the MQTT Version 5.0 specification.
     *         </p>
     *         <note>
     *         <p>
     *         This binary data must be based64-encoded.
     *         </p>
     *         </note>
     *         <p>
     *         Supports <a href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html">
     *         substitution templates</a>.
     */
    public final String correlationData() {
        return correlationData;
    }

    /**
     * <p>
     * A user-defined integer value that will persist a message at the message broker for a specified amount of time to
     * ensure that the message will expire if it's no longer relevant to the subscriber. The value of
     * <code>messageExpiry</code> represents the number of seconds before it expires. For more information about the
     * limits of <code>messageExpiry</code>, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/mqtt.html">Amazon Web Services IoT Core message
     * broker and protocol limits and quotas </a> from the Amazon Web Services Reference Guide.
     * </p>
     * <p>
     * Supports <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html">substitution
     * templates</a>.
     * </p>
     * 
     * @return A user-defined integer value that will persist a message at the message broker for a specified amount of
     *         time to ensure that the message will expire if it's no longer relevant to the subscriber. The value of
     *         <code>messageExpiry</code> represents the number of seconds before it expires. For more information about
     *         the limits of <code>messageExpiry</code>, see <a
     *         href="https://docs.aws.amazon.com/iot/latest/developerguide/mqtt.html">Amazon Web Services IoT Core
     *         message broker and protocol limits and quotas </a> from the Amazon Web Services Reference Guide.</p>
     *         <p>
     *         Supports <a href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html">
     *         substitution templates</a>.
     */
    public final String messageExpiry() {
        return messageExpiry;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserProperties property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserProperties() {
        return userProperties != null && !(userProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of key-value pairs that you define in the MQTT5 header.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserProperties} method.
     * </p>
     * 
     * @return An array of key-value pairs that you define in the MQTT5 header.
     */
    public final List<UserProperty> userProperties() {
        return userProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(payloadFormatIndicator());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(responseTopic());
        hashCode = 31 * hashCode + Objects.hashCode(correlationData());
        hashCode = 31 * hashCode + Objects.hashCode(messageExpiry());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserProperties() ? userProperties() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MqttHeaders)) {
            return false;
        }
        MqttHeaders other = (MqttHeaders) obj;
        return Objects.equals(payloadFormatIndicator(), other.payloadFormatIndicator())
                && Objects.equals(contentType(), other.contentType()) && Objects.equals(responseTopic(), other.responseTopic())
                && Objects.equals(correlationData(), other.correlationData())
                && Objects.equals(messageExpiry(), other.messageExpiry()) && hasUserProperties() == other.hasUserProperties()
                && Objects.equals(userProperties(), other.userProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MqttHeaders").add("PayloadFormatIndicator", payloadFormatIndicator())
                .add("ContentType", contentType()).add("ResponseTopic", responseTopic())
                .add("CorrelationData", correlationData()).add("MessageExpiry", messageExpiry())
                .add("UserProperties", hasUserProperties() ? userProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "payloadFormatIndicator":
            return Optional.ofNullable(clazz.cast(payloadFormatIndicator()));
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "responseTopic":
            return Optional.ofNullable(clazz.cast(responseTopic()));
        case "correlationData":
            return Optional.ofNullable(clazz.cast(correlationData()));
        case "messageExpiry":
            return Optional.ofNullable(clazz.cast(messageExpiry()));
        case "userProperties":
            return Optional.ofNullable(clazz.cast(userProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MqttHeaders, T> g) {
        return obj -> g.apply((MqttHeaders) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MqttHeaders> {
        /**
         * <p>
         * An <code>Enum</code> string value that indicates whether the payload is formatted as UTF-8.
         * </p>
         * <p>
         * Valid values are <code>UNSPECIFIED_BYTES</code> and <code>UTF8_DATA</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.oasis-open.org/mqtt/mqtt/v5.0/os/mqtt-v5.0-os.html#_Toc3901111"> Payload Format
         * Indicator</a> from the MQTT Version 5.0 specification.
         * </p>
         * <p>
         * Supports <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html">substitution
         * templates</a>.
         * </p>
         * 
         * @param payloadFormatIndicator
         *        An <code>Enum</code> string value that indicates whether the payload is formatted as UTF-8.</p>
         *        <p>
         *        Valid values are <code>UNSPECIFIED_BYTES</code> and <code>UTF8_DATA</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.oasis-open.org/mqtt/mqtt/v5.0/os/mqtt-v5.0-os.html#_Toc3901111"> Payload Format
         *        Indicator</a> from the MQTT Version 5.0 specification.
         *        </p>
         *        <p>
         *        Supports <a
         *        href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html"
         *        >substitution templates</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payloadFormatIndicator(String payloadFormatIndicator);

        /**
         * <p>
         * A UTF-8 encoded string that describes the content of the publishing message.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.oasis-open.org/mqtt/mqtt/v5.0/os/mqtt-v5.0-os.html#_Toc3901118"> Content Type</a> from the
         * MQTT Version 5.0 specification.
         * </p>
         * <p>
         * Supports <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html">substitution
         * templates</a>.
         * </p>
         * 
         * @param contentType
         *        A UTF-8 encoded string that describes the content of the publishing message.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.oasis-open.org/mqtt/mqtt/v5.0/os/mqtt-v5.0-os.html#_Toc3901118"> Content Type</a>
         *        from the MQTT Version 5.0 specification.
         *        </p>
         *        <p>
         *        Supports <a
         *        href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html"
         *        >substitution templates</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * A UTF-8 encoded string that's used as the topic name for a response message. The response topic is used to
         * describe the topic which the receiver should publish to as part of the request-response flow. The topic must
         * not contain wildcard characters.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.oasis-open.org/mqtt/mqtt/v5.0/os/mqtt-v5.0-os.html#_Toc3901114"> Response Topic</a> from
         * the MQTT Version 5.0 specification.
         * </p>
         * <p>
         * Supports <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html">substitution
         * templates</a>.
         * </p>
         * 
         * @param responseTopic
         *        A UTF-8 encoded string that's used as the topic name for a response message. The response topic is
         *        used to describe the topic which the receiver should publish to as part of the request-response flow.
         *        The topic must not contain wildcard characters.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.oasis-open.org/mqtt/mqtt/v5.0/os/mqtt-v5.0-os.html#_Toc3901114"> Response Topic</a>
         *        from the MQTT Version 5.0 specification.
         *        </p>
         *        <p>
         *        Supports <a
         *        href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html"
         *        >substitution templates</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseTopic(String responseTopic);

        /**
         * <p>
         * The base64-encoded binary data used by the sender of the request message to identify which request the
         * response message is for when it's received.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.oasis-open.org/mqtt/mqtt/v5.0/os/mqtt-v5.0-os.html#_Toc3901115"> Correlation Data</a> from
         * the MQTT Version 5.0 specification.
         * </p>
         * <note>
         * <p>
         * This binary data must be based64-encoded.
         * </p>
         * </note>
         * <p>
         * Supports <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html">substitution
         * templates</a>.
         * </p>
         * 
         * @param correlationData
         *        The base64-encoded binary data used by the sender of the request message to identify which request the
         *        response message is for when it's received.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.oasis-open.org/mqtt/mqtt/v5.0/os/mqtt-v5.0-os.html#_Toc3901115"> Correlation
         *        Data</a> from the MQTT Version 5.0 specification.
         *        </p>
         *        <note>
         *        <p>
         *        This binary data must be based64-encoded.
         *        </p>
         *        </note>
         *        <p>
         *        Supports <a
         *        href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html"
         *        >substitution templates</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder correlationData(String correlationData);

        /**
         * <p>
         * A user-defined integer value that will persist a message at the message broker for a specified amount of time
         * to ensure that the message will expire if it's no longer relevant to the subscriber. The value of
         * <code>messageExpiry</code> represents the number of seconds before it expires. For more information about the
         * limits of <code>messageExpiry</code>, see <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/mqtt.html">Amazon Web Services IoT Core message
         * broker and protocol limits and quotas </a> from the Amazon Web Services Reference Guide.
         * </p>
         * <p>
         * Supports <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html">substitution
         * templates</a>.
         * </p>
         * 
         * @param messageExpiry
         *        A user-defined integer value that will persist a message at the message broker for a specified amount
         *        of time to ensure that the message will expire if it's no longer relevant to the subscriber. The value
         *        of <code>messageExpiry</code> represents the number of seconds before it expires. For more information
         *        about the limits of <code>messageExpiry</code>, see <a
         *        href="https://docs.aws.amazon.com/iot/latest/developerguide/mqtt.html">Amazon Web Services IoT Core
         *        message broker and protocol limits and quotas </a> from the Amazon Web Services Reference Guide.</p>
         *        <p>
         *        Supports <a
         *        href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html"
         *        >substitution templates</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageExpiry(String messageExpiry);

        /**
         * <p>
         * An array of key-value pairs that you define in the MQTT5 header.
         * </p>
         * 
         * @param userProperties
         *        An array of key-value pairs that you define in the MQTT5 header.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userProperties(Collection<UserProperty> userProperties);

        /**
         * <p>
         * An array of key-value pairs that you define in the MQTT5 header.
         * </p>
         * 
         * @param userProperties
         *        An array of key-value pairs that you define in the MQTT5 header.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userProperties(UserProperty... userProperties);

        /**
         * <p>
         * An array of key-value pairs that you define in the MQTT5 header.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iot.model.UserProperty.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iot.model.UserProperty#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iot.model.UserProperty.Builder#build()} is called immediately and its
         * result is passed to {@link #userProperties(List<UserProperty>)}.
         * 
         * @param userProperties
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iot.model.UserProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userProperties(java.util.Collection<UserProperty>)
         */
        Builder userProperties(Consumer<UserProperty.Builder>... userProperties);
    }

    static final class BuilderImpl implements Builder {
        private String payloadFormatIndicator;

        private String contentType;

        private String responseTopic;

        private String correlationData;

        private String messageExpiry;

        private List<UserProperty> userProperties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MqttHeaders model) {
            payloadFormatIndicator(model.payloadFormatIndicator);
            contentType(model.contentType);
            responseTopic(model.responseTopic);
            correlationData(model.correlationData);
            messageExpiry(model.messageExpiry);
            userProperties(model.userProperties);
        }

        public final String getPayloadFormatIndicator() {
            return payloadFormatIndicator;
        }

        public final void setPayloadFormatIndicator(String payloadFormatIndicator) {
            this.payloadFormatIndicator = payloadFormatIndicator;
        }

        @Override
        public final Builder payloadFormatIndicator(String payloadFormatIndicator) {
            this.payloadFormatIndicator = payloadFormatIndicator;
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getResponseTopic() {
            return responseTopic;
        }

        public final void setResponseTopic(String responseTopic) {
            this.responseTopic = responseTopic;
        }

        @Override
        public final Builder responseTopic(String responseTopic) {
            this.responseTopic = responseTopic;
            return this;
        }

        public final String getCorrelationData() {
            return correlationData;
        }

        public final void setCorrelationData(String correlationData) {
            this.correlationData = correlationData;
        }

        @Override
        public final Builder correlationData(String correlationData) {
            this.correlationData = correlationData;
            return this;
        }

        public final String getMessageExpiry() {
            return messageExpiry;
        }

        public final void setMessageExpiry(String messageExpiry) {
            this.messageExpiry = messageExpiry;
        }

        @Override
        public final Builder messageExpiry(String messageExpiry) {
            this.messageExpiry = messageExpiry;
            return this;
        }

        public final List<UserProperty.Builder> getUserProperties() {
            List<UserProperty.Builder> result = UserPropertiesCopier.copyToBuilder(this.userProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserProperties(Collection<UserProperty.BuilderImpl> userProperties) {
            this.userProperties = UserPropertiesCopier.copyFromBuilder(userProperties);
        }

        @Override
        public final Builder userProperties(Collection<UserProperty> userProperties) {
            this.userProperties = UserPropertiesCopier.copy(userProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userProperties(UserProperty... userProperties) {
            userProperties(Arrays.asList(userProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userProperties(Consumer<UserProperty.Builder>... userProperties) {
            userProperties(Stream.of(userProperties).map(c -> UserProperty.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public MqttHeaders build() {
            return new MqttHeaders(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
