/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetV2LoggingOptionsResponse extends IotResponse implements
        ToCopyableBuilder<GetV2LoggingOptionsResponse.Builder, GetV2LoggingOptionsResponse> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(GetV2LoggingOptionsResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> DEFAULT_LOG_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultLogLevel").getter(getter(GetV2LoggingOptionsResponse::defaultLogLevelAsString))
            .setter(setter(Builder::defaultLogLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultLogLevel").build()).build();

    private static final SdkField<Boolean> DISABLE_ALL_LOGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("disableAllLogs").getter(getter(GetV2LoggingOptionsResponse::disableAllLogs))
            .setter(setter(Builder::disableAllLogs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disableAllLogs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD,
            DEFAULT_LOG_LEVEL_FIELD, DISABLE_ALL_LOGS_FIELD));

    private final String roleArn;

    private final String defaultLogLevel;

    private final Boolean disableAllLogs;

    private GetV2LoggingOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.roleArn = builder.roleArn;
        this.defaultLogLevel = builder.defaultLogLevel;
        this.disableAllLogs = builder.disableAllLogs;
    }

    /**
     * <p>
     * The IAM role ARN IoT uses to write to your CloudWatch logs.
     * </p>
     * 
     * @return The IAM role ARN IoT uses to write to your CloudWatch logs.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The default log level.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #defaultLogLevel}
     * will return {@link LogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #defaultLogLevelAsString}.
     * </p>
     * 
     * @return The default log level.
     * @see LogLevel
     */
    public final LogLevel defaultLogLevel() {
        return LogLevel.fromValue(defaultLogLevel);
    }

    /**
     * <p>
     * The default log level.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #defaultLogLevel}
     * will return {@link LogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #defaultLogLevelAsString}.
     * </p>
     * 
     * @return The default log level.
     * @see LogLevel
     */
    public final String defaultLogLevelAsString() {
        return defaultLogLevel;
    }

    /**
     * <p>
     * Disables all logs.
     * </p>
     * 
     * @return Disables all logs.
     */
    public final Boolean disableAllLogs() {
        return disableAllLogs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(defaultLogLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(disableAllLogs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetV2LoggingOptionsResponse)) {
            return false;
        }
        GetV2LoggingOptionsResponse other = (GetV2LoggingOptionsResponse) obj;
        return Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(defaultLogLevelAsString(), other.defaultLogLevelAsString())
                && Objects.equals(disableAllLogs(), other.disableAllLogs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetV2LoggingOptionsResponse").add("RoleArn", roleArn())
                .add("DefaultLogLevel", defaultLogLevelAsString()).add("DisableAllLogs", disableAllLogs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "defaultLogLevel":
            return Optional.ofNullable(clazz.cast(defaultLogLevelAsString()));
        case "disableAllLogs":
            return Optional.ofNullable(clazz.cast(disableAllLogs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetV2LoggingOptionsResponse, T> g) {
        return obj -> g.apply((GetV2LoggingOptionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetV2LoggingOptionsResponse> {
        /**
         * <p>
         * The IAM role ARN IoT uses to write to your CloudWatch logs.
         * </p>
         * 
         * @param roleArn
         *        The IAM role ARN IoT uses to write to your CloudWatch logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The default log level.
         * </p>
         * 
         * @param defaultLogLevel
         *        The default log level.
         * @see LogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogLevel
         */
        Builder defaultLogLevel(String defaultLogLevel);

        /**
         * <p>
         * The default log level.
         * </p>
         * 
         * @param defaultLogLevel
         *        The default log level.
         * @see LogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogLevel
         */
        Builder defaultLogLevel(LogLevel defaultLogLevel);

        /**
         * <p>
         * Disables all logs.
         * </p>
         * 
         * @param disableAllLogs
         *        Disables all logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableAllLogs(Boolean disableAllLogs);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String roleArn;

        private String defaultLogLevel;

        private Boolean disableAllLogs;

        private BuilderImpl() {
        }

        private BuilderImpl(GetV2LoggingOptionsResponse model) {
            super(model);
            roleArn(model.roleArn);
            defaultLogLevel(model.defaultLogLevel);
            disableAllLogs(model.disableAllLogs);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getDefaultLogLevel() {
            return defaultLogLevel;
        }

        public final void setDefaultLogLevel(String defaultLogLevel) {
            this.defaultLogLevel = defaultLogLevel;
        }

        @Override
        public final Builder defaultLogLevel(String defaultLogLevel) {
            this.defaultLogLevel = defaultLogLevel;
            return this;
        }

        @Override
        public final Builder defaultLogLevel(LogLevel defaultLogLevel) {
            this.defaultLogLevel(defaultLogLevel == null ? null : defaultLogLevel.toString());
            return this;
        }

        public final Boolean getDisableAllLogs() {
            return disableAllLogs;
        }

        public final void setDisableAllLogs(Boolean disableAllLogs) {
            this.disableAllLogs = disableAllLogs;
        }

        @Override
        public final Builder disableAllLogs(Boolean disableAllLogs) {
            this.disableAllLogs = disableAllLogs;
            return this;
        }

        @Override
        public GetV2LoggingOptionsResponse build() {
            return new GetV2LoggingOptionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
