/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class DocumentParametersCopier {
    static List<DocumentParameter> copy(Collection<? extends DocumentParameter> documentParametersParam) {
        List<DocumentParameter> list;
        if (documentParametersParam == null || documentParametersParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DocumentParameter> modifiableList = new ArrayList<>();
            documentParametersParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<DocumentParameter> copyFromBuilder(Collection<? extends DocumentParameter.Builder> documentParametersParam) {
        List<DocumentParameter> list;
        if (documentParametersParam == null || documentParametersParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DocumentParameter> modifiableList = new ArrayList<>();
            documentParametersParam.forEach(entry -> {
                DocumentParameter member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<DocumentParameter.Builder> copyToBuilder(Collection<? extends DocumentParameter> documentParametersParam) {
        List<DocumentParameter.Builder> list;
        if (documentParametersParam == null || documentParametersParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DocumentParameter.Builder> modifiableList = new ArrayList<>();
            documentParametersParam.forEach(entry -> {
                DocumentParameter.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
