/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCoverageRequest extends GuardDutyRequest implements
        ToCopyableBuilder<ListCoverageRequest.Builder, ListCoverageRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetectorId").getter(getter(ListCoverageRequest::detectorId)).setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListCoverageRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListCoverageRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<CoverageFilterCriteria> FILTER_CRITERIA_FIELD = SdkField
            .<CoverageFilterCriteria> builder(MarshallingType.SDK_POJO).memberName("FilterCriteria")
            .getter(getter(ListCoverageRequest::filterCriteria)).setter(setter(Builder::filterCriteria))
            .constructor(CoverageFilterCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterCriteria").build()).build();

    private static final SdkField<CoverageSortCriteria> SORT_CRITERIA_FIELD = SdkField
            .<CoverageSortCriteria> builder(MarshallingType.SDK_POJO).memberName("SortCriteria")
            .getter(getter(ListCoverageRequest::sortCriteria)).setter(setter(Builder::sortCriteria))
            .constructor(CoverageSortCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortCriteria").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, FILTER_CRITERIA_FIELD, SORT_CRITERIA_FIELD));

    private final String detectorId;

    private final String nextToken;

    private final Integer maxResults;

    private final CoverageFilterCriteria filterCriteria;

    private final CoverageSortCriteria sortCriteria;

    private ListCoverageRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.filterCriteria = builder.filterCriteria;
        this.sortCriteria = builder.sortCriteria;
    }

    /**
     * <p>
     * The unique ID of the detector whose coverage details you want to retrieve.
     * </p>
     * 
     * @return The unique ID of the detector whose coverage details you want to retrieve.
     */
    public final String detectorId() {
        return detectorId;
    }

    /**
     * <p>
     * A token to use for paginating results that are returned in the response. Set the value of this parameter to null
     * for the first request to a list action. For subsequent calls, use the NextToken value returned from the previous
     * request to continue listing results after the first page.
     * </p>
     * 
     * @return A token to use for paginating results that are returned in the response. Set the value of this parameter
     *         to null for the first request to a list action. For subsequent calls, use the NextToken value returned
     *         from the previous request to continue listing results after the first page.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return in the response.
     * </p>
     * 
     * @return The maximum number of results to return in the response.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Represents the criteria used to filter the coverage details.
     * </p>
     * 
     * @return Represents the criteria used to filter the coverage details.
     */
    public final CoverageFilterCriteria filterCriteria() {
        return filterCriteria;
    }

    /**
     * <p>
     * Represents the criteria used to sort the coverage details.
     * </p>
     * 
     * @return Represents the criteria used to sort the coverage details.
     */
    public final CoverageSortCriteria sortCriteria() {
        return sortCriteria;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(filterCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(sortCriteria());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCoverageRequest)) {
            return false;
        }
        ListCoverageRequest other = (ListCoverageRequest) obj;
        return Objects.equals(detectorId(), other.detectorId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(filterCriteria(), other.filterCriteria())
                && Objects.equals(sortCriteria(), other.sortCriteria());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCoverageRequest").add("DetectorId", detectorId()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("FilterCriteria", filterCriteria()).add("SortCriteria", sortCriteria())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DetectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "FilterCriteria":
            return Optional.ofNullable(clazz.cast(filterCriteria()));
        case "SortCriteria":
            return Optional.ofNullable(clazz.cast(sortCriteria()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCoverageRequest, T> g) {
        return obj -> g.apply((ListCoverageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListCoverageRequest> {
        /**
         * <p>
         * The unique ID of the detector whose coverage details you want to retrieve.
         * </p>
         * 
         * @param detectorId
         *        The unique ID of the detector whose coverage details you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * A token to use for paginating results that are returned in the response. Set the value of this parameter to
         * null for the first request to a list action. For subsequent calls, use the NextToken value returned from the
         * previous request to continue listing results after the first page.
         * </p>
         * 
         * @param nextToken
         *        A token to use for paginating results that are returned in the response. Set the value of this
         *        parameter to null for the first request to a list action. For subsequent calls, use the NextToken
         *        value returned from the previous request to continue listing results after the first page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return in the response.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Represents the criteria used to filter the coverage details.
         * </p>
         * 
         * @param filterCriteria
         *        Represents the criteria used to filter the coverage details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterCriteria(CoverageFilterCriteria filterCriteria);

        /**
         * <p>
         * Represents the criteria used to filter the coverage details.
         * </p>
         * This is a convenience method that creates an instance of the {@link CoverageFilterCriteria.Builder} avoiding
         * the need to create one manually via {@link CoverageFilterCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CoverageFilterCriteria.Builder#build()} is called immediately and
         * its result is passed to {@link #filterCriteria(CoverageFilterCriteria)}.
         * 
         * @param filterCriteria
         *        a consumer that will call methods on {@link CoverageFilterCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterCriteria(CoverageFilterCriteria)
         */
        default Builder filterCriteria(Consumer<CoverageFilterCriteria.Builder> filterCriteria) {
            return filterCriteria(CoverageFilterCriteria.builder().applyMutation(filterCriteria).build());
        }

        /**
         * <p>
         * Represents the criteria used to sort the coverage details.
         * </p>
         * 
         * @param sortCriteria
         *        Represents the criteria used to sort the coverage details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortCriteria(CoverageSortCriteria sortCriteria);

        /**
         * <p>
         * Represents the criteria used to sort the coverage details.
         * </p>
         * This is a convenience method that creates an instance of the {@link CoverageSortCriteria.Builder} avoiding
         * the need to create one manually via {@link CoverageSortCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CoverageSortCriteria.Builder#build()} is called immediately and
         * its result is passed to {@link #sortCriteria(CoverageSortCriteria)}.
         * 
         * @param sortCriteria
         *        a consumer that will call methods on {@link CoverageSortCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortCriteria(CoverageSortCriteria)
         */
        default Builder sortCriteria(Consumer<CoverageSortCriteria.Builder> sortCriteria) {
            return sortCriteria(CoverageSortCriteria.builder().applyMutation(sortCriteria).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GuardDutyRequest.BuilderImpl implements Builder {
        private String detectorId;

        private String nextToken;

        private Integer maxResults;

        private CoverageFilterCriteria filterCriteria;

        private CoverageSortCriteria sortCriteria;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCoverageRequest model) {
            super(model);
            detectorId(model.detectorId);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            filterCriteria(model.filterCriteria);
            sortCriteria(model.sortCriteria);
        }

        public final String getDetectorId() {
            return detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final CoverageFilterCriteria.Builder getFilterCriteria() {
            return filterCriteria != null ? filterCriteria.toBuilder() : null;
        }

        public final void setFilterCriteria(CoverageFilterCriteria.BuilderImpl filterCriteria) {
            this.filterCriteria = filterCriteria != null ? filterCriteria.build() : null;
        }

        @Override
        public final Builder filterCriteria(CoverageFilterCriteria filterCriteria) {
            this.filterCriteria = filterCriteria;
            return this;
        }

        public final CoverageSortCriteria.Builder getSortCriteria() {
            return sortCriteria != null ? sortCriteria.toBuilder() : null;
        }

        public final void setSortCriteria(CoverageSortCriteria.BuilderImpl sortCriteria) {
            this.sortCriteria = sortCriteria != null ? sortCriteria.build() : null;
        }

        @Override
        public final Builder sortCriteria(CoverageSortCriteria sortCriteria) {
            this.sortCriteria = sortCriteria;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCoverageRequest build() {
            return new ListCoverageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
