/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFindingsStatisticsRequest extends GuardDutyRequest implements
        ToCopyableBuilder<GetFindingsStatisticsRequest.Builder, GetFindingsStatisticsRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetectorId").getter(getter(GetFindingsStatisticsRequest::detectorId))
            .setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()).build();

    private static final SdkField<List<String>> FINDING_STATISTIC_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FindingStatisticTypes")
            .getter(getter(GetFindingsStatisticsRequest::findingStatisticTypesAsStrings))
            .setter(setter(Builder::findingStatisticTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingStatisticTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<FindingCriteria> FINDING_CRITERIA_FIELD = SdkField
            .<FindingCriteria> builder(MarshallingType.SDK_POJO).memberName("FindingCriteria")
            .getter(getter(GetFindingsStatisticsRequest::findingCriteria)).setter(setter(Builder::findingCriteria))
            .constructor(FindingCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingCriteria").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD,
            FINDING_STATISTIC_TYPES_FIELD, FINDING_CRITERIA_FIELD));

    private final String detectorId;

    private final List<String> findingStatisticTypes;

    private final FindingCriteria findingCriteria;

    private GetFindingsStatisticsRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.findingStatisticTypes = builder.findingStatisticTypes;
        this.findingCriteria = builder.findingCriteria;
    }

    /**
     * <p>
     * The ID of the detector that specifies the GuardDuty service whose findings' statistics you want to retrieve.
     * </p>
     * 
     * @return The ID of the detector that specifies the GuardDuty service whose findings' statistics you want to
     *         retrieve.
     */
    public final String detectorId() {
        return detectorId;
    }

    /**
     * <p>
     * The types of finding statistics to retrieve.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFindingStatisticTypes} method.
     * </p>
     * 
     * @return The types of finding statistics to retrieve.
     */
    public final List<FindingStatisticType> findingStatisticTypes() {
        return FindingStatisticTypesCopier.copyStringToEnum(findingStatisticTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the FindingStatisticTypes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasFindingStatisticTypes() {
        return findingStatisticTypes != null && !(findingStatisticTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The types of finding statistics to retrieve.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFindingStatisticTypes} method.
     * </p>
     * 
     * @return The types of finding statistics to retrieve.
     */
    public final List<String> findingStatisticTypesAsStrings() {
        return findingStatisticTypes;
    }

    /**
     * <p>
     * Represents the criteria that is used for querying findings.
     * </p>
     * 
     * @return Represents the criteria that is used for querying findings.
     */
    public final FindingCriteria findingCriteria() {
        return findingCriteria;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(hasFindingStatisticTypes() ? findingStatisticTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(findingCriteria());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFindingsStatisticsRequest)) {
            return false;
        }
        GetFindingsStatisticsRequest other = (GetFindingsStatisticsRequest) obj;
        return Objects.equals(detectorId(), other.detectorId()) && hasFindingStatisticTypes() == other.hasFindingStatisticTypes()
                && Objects.equals(findingStatisticTypesAsStrings(), other.findingStatisticTypesAsStrings())
                && Objects.equals(findingCriteria(), other.findingCriteria());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFindingsStatisticsRequest").add("DetectorId", detectorId())
                .add("FindingStatisticTypes", hasFindingStatisticTypes() ? findingStatisticTypesAsStrings() : null)
                .add("FindingCriteria", findingCriteria()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DetectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "FindingStatisticTypes":
            return Optional.ofNullable(clazz.cast(findingStatisticTypesAsStrings()));
        case "FindingCriteria":
            return Optional.ofNullable(clazz.cast(findingCriteria()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFindingsStatisticsRequest, T> g) {
        return obj -> g.apply((GetFindingsStatisticsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GuardDutyRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetFindingsStatisticsRequest> {
        /**
         * <p>
         * The ID of the detector that specifies the GuardDuty service whose findings' statistics you want to retrieve.
         * </p>
         * 
         * @param detectorId
         *        The ID of the detector that specifies the GuardDuty service whose findings' statistics you want to
         *        retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * The types of finding statistics to retrieve.
         * </p>
         * 
         * @param findingStatisticTypes
         *        The types of finding statistics to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingStatisticTypesWithStrings(Collection<String> findingStatisticTypes);

        /**
         * <p>
         * The types of finding statistics to retrieve.
         * </p>
         * 
         * @param findingStatisticTypes
         *        The types of finding statistics to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingStatisticTypesWithStrings(String... findingStatisticTypes);

        /**
         * <p>
         * The types of finding statistics to retrieve.
         * </p>
         * 
         * @param findingStatisticTypes
         *        The types of finding statistics to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingStatisticTypes(Collection<FindingStatisticType> findingStatisticTypes);

        /**
         * <p>
         * The types of finding statistics to retrieve.
         * </p>
         * 
         * @param findingStatisticTypes
         *        The types of finding statistics to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingStatisticTypes(FindingStatisticType... findingStatisticTypes);

        /**
         * <p>
         * Represents the criteria that is used for querying findings.
         * </p>
         * 
         * @param findingCriteria
         *        Represents the criteria that is used for querying findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingCriteria(FindingCriteria findingCriteria);

        /**
         * <p>
         * Represents the criteria that is used for querying findings.
         * </p>
         * This is a convenience method that creates an instance of the {@link FindingCriteria.Builder} avoiding the
         * need to create one manually via {@link FindingCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FindingCriteria.Builder#build()} is called immediately and its
         * result is passed to {@link #findingCriteria(FindingCriteria)}.
         * 
         * @param findingCriteria
         *        a consumer that will call methods on {@link FindingCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findingCriteria(FindingCriteria)
         */
        default Builder findingCriteria(Consumer<FindingCriteria.Builder> findingCriteria) {
            return findingCriteria(FindingCriteria.builder().applyMutation(findingCriteria).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GuardDutyRequest.BuilderImpl implements Builder {
        private String detectorId;

        private List<String> findingStatisticTypes = DefaultSdkAutoConstructList.getInstance();

        private FindingCriteria findingCriteria;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFindingsStatisticsRequest model) {
            super(model);
            detectorId(model.detectorId);
            findingStatisticTypesWithStrings(model.findingStatisticTypes);
            findingCriteria(model.findingCriteria);
        }

        public final String getDetectorId() {
            return detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final Collection<String> getFindingStatisticTypes() {
            if (findingStatisticTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return findingStatisticTypes;
        }

        public final void setFindingStatisticTypes(Collection<String> findingStatisticTypes) {
            this.findingStatisticTypes = FindingStatisticTypesCopier.copy(findingStatisticTypes);
        }

        @Override
        public final Builder findingStatisticTypesWithStrings(Collection<String> findingStatisticTypes) {
            this.findingStatisticTypes = FindingStatisticTypesCopier.copy(findingStatisticTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingStatisticTypesWithStrings(String... findingStatisticTypes) {
            findingStatisticTypesWithStrings(Arrays.asList(findingStatisticTypes));
            return this;
        }

        @Override
        public final Builder findingStatisticTypes(Collection<FindingStatisticType> findingStatisticTypes) {
            this.findingStatisticTypes = FindingStatisticTypesCopier.copyEnumToString(findingStatisticTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingStatisticTypes(FindingStatisticType... findingStatisticTypes) {
            findingStatisticTypes(Arrays.asList(findingStatisticTypes));
            return this;
        }

        public final FindingCriteria.Builder getFindingCriteria() {
            return findingCriteria != null ? findingCriteria.toBuilder() : null;
        }

        public final void setFindingCriteria(FindingCriteria.BuilderImpl findingCriteria) {
            this.findingCriteria = findingCriteria != null ? findingCriteria.build() : null;
        }

        @Override
        public final Builder findingCriteria(FindingCriteria findingCriteria) {
            this.findingCriteria = findingCriteria;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetFindingsStatisticsRequest build() {
            return new GetFindingsStatisticsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
