/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the publishing destination, including the ID, type, and status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Destination implements SdkPojo, Serializable, ToCopyableBuilder<Destination.Builder, Destination> {
    private static final SdkField<String> DESTINATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationId").getter(getter(Destination::destinationId)).setter(setter(Builder::destinationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationId").build()).build();

    private static final SdkField<String> DESTINATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationType").getter(getter(Destination::destinationTypeAsString))
            .setter(setter(Builder::destinationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationType").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Destination::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_ID_FIELD,
            DESTINATION_TYPE_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String destinationId;

    private final String destinationType;

    private final String status;

    private Destination(BuilderImpl builder) {
        this.destinationId = builder.destinationId;
        this.destinationType = builder.destinationType;
        this.status = builder.status;
    }

    /**
     * <p>
     * The unique ID of the publishing destination.
     * </p>
     * 
     * @return The unique ID of the publishing destination.
     */
    public final String destinationId() {
        return destinationId;
    }

    /**
     * <p>
     * The type of resource used for the publishing destination. Currently, only Amazon S3 buckets are supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destinationType}
     * will return {@link DestinationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #destinationTypeAsString}.
     * </p>
     * 
     * @return The type of resource used for the publishing destination. Currently, only Amazon S3 buckets are
     *         supported.
     * @see DestinationType
     */
    public final DestinationType destinationType() {
        return DestinationType.fromValue(destinationType);
    }

    /**
     * <p>
     * The type of resource used for the publishing destination. Currently, only Amazon S3 buckets are supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destinationType}
     * will return {@link DestinationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #destinationTypeAsString}.
     * </p>
     * 
     * @return The type of resource used for the publishing destination. Currently, only Amazon S3 buckets are
     *         supported.
     * @see DestinationType
     */
    public final String destinationTypeAsString() {
        return destinationType;
    }

    /**
     * <p>
     * The status of the publishing destination.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PublishingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the publishing destination.
     * @see PublishingStatus
     */
    public final PublishingStatus status() {
        return PublishingStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the publishing destination.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PublishingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the publishing destination.
     * @see PublishingStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationId());
        hashCode = 31 * hashCode + Objects.hashCode(destinationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Destination)) {
            return false;
        }
        Destination other = (Destination) obj;
        return Objects.equals(destinationId(), other.destinationId())
                && Objects.equals(destinationTypeAsString(), other.destinationTypeAsString())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Destination").add("DestinationId", destinationId())
                .add("DestinationType", destinationTypeAsString()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationId":
            return Optional.ofNullable(clazz.cast(destinationId()));
        case "DestinationType":
            return Optional.ofNullable(clazz.cast(destinationTypeAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Destination, T> g) {
        return obj -> g.apply((Destination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Destination> {
        /**
         * <p>
         * The unique ID of the publishing destination.
         * </p>
         * 
         * @param destinationId
         *        The unique ID of the publishing destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationId(String destinationId);

        /**
         * <p>
         * The type of resource used for the publishing destination. Currently, only Amazon S3 buckets are supported.
         * </p>
         * 
         * @param destinationType
         *        The type of resource used for the publishing destination. Currently, only Amazon S3 buckets are
         *        supported.
         * @see DestinationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DestinationType
         */
        Builder destinationType(String destinationType);

        /**
         * <p>
         * The type of resource used for the publishing destination. Currently, only Amazon S3 buckets are supported.
         * </p>
         * 
         * @param destinationType
         *        The type of resource used for the publishing destination. Currently, only Amazon S3 buckets are
         *        supported.
         * @see DestinationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DestinationType
         */
        Builder destinationType(DestinationType destinationType);

        /**
         * <p>
         * The status of the publishing destination.
         * </p>
         * 
         * @param status
         *        The status of the publishing destination.
         * @see PublishingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PublishingStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the publishing destination.
         * </p>
         * 
         * @param status
         *        The status of the publishing destination.
         * @see PublishingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PublishingStatus
         */
        Builder status(PublishingStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String destinationId;

        private String destinationType;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(Destination model) {
            destinationId(model.destinationId);
            destinationType(model.destinationType);
            status(model.status);
        }

        public final String getDestinationId() {
            return destinationId;
        }

        public final void setDestinationId(String destinationId) {
            this.destinationId = destinationId;
        }

        @Override
        public final Builder destinationId(String destinationId) {
            this.destinationId = destinationId;
            return this;
        }

        public final String getDestinationType() {
            return destinationType;
        }

        public final void setDestinationType(String destinationType) {
            this.destinationType = destinationType;
        }

        @Override
        public final Builder destinationType(String destinationType) {
            this.destinationType = destinationType;
            return this;
        }

        @Override
        public final Builder destinationType(DestinationType destinationType) {
            this.destinationType(destinationType == null ? null : destinationType.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PublishingStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Destination build() {
            return new Destination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
