/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the account level permissions on the S3 bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountLevelPermissions implements SdkPojo, Serializable,
        ToCopyableBuilder<AccountLevelPermissions.Builder, AccountLevelPermissions> {
    private static final SdkField<BlockPublicAccess> BLOCK_PUBLIC_ACCESS_FIELD = SdkField
            .<BlockPublicAccess> builder(MarshallingType.SDK_POJO).memberName("BlockPublicAccess")
            .getter(getter(AccountLevelPermissions::blockPublicAccess)).setter(setter(Builder::blockPublicAccess))
            .constructor(BlockPublicAccess::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockPublicAccess").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCK_PUBLIC_ACCESS_FIELD));

    private static final long serialVersionUID = 1L;

    private final BlockPublicAccess blockPublicAccess;

    private AccountLevelPermissions(BuilderImpl builder) {
        this.blockPublicAccess = builder.blockPublicAccess;
    }

    /**
     * <p>
     * Describes the S3 Block Public Access settings of the bucket's parent account.
     * </p>
     * 
     * @return Describes the S3 Block Public Access settings of the bucket's parent account.
     */
    public final BlockPublicAccess blockPublicAccess() {
        return blockPublicAccess;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(blockPublicAccess());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountLevelPermissions)) {
            return false;
        }
        AccountLevelPermissions other = (AccountLevelPermissions) obj;
        return Objects.equals(blockPublicAccess(), other.blockPublicAccess());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountLevelPermissions").add("BlockPublicAccess", blockPublicAccess()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BlockPublicAccess":
            return Optional.ofNullable(clazz.cast(blockPublicAccess()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountLevelPermissions, T> g) {
        return obj -> g.apply((AccountLevelPermissions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountLevelPermissions> {
        /**
         * <p>
         * Describes the S3 Block Public Access settings of the bucket's parent account.
         * </p>
         * 
         * @param blockPublicAccess
         *        Describes the S3 Block Public Access settings of the bucket's parent account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockPublicAccess(BlockPublicAccess blockPublicAccess);

        /**
         * <p>
         * Describes the S3 Block Public Access settings of the bucket's parent account.
         * </p>
         * This is a convenience method that creates an instance of the {@link BlockPublicAccess.Builder} avoiding the
         * need to create one manually via {@link BlockPublicAccess#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BlockPublicAccess.Builder#build()} is called immediately and its
         * result is passed to {@link #blockPublicAccess(BlockPublicAccess)}.
         * 
         * @param blockPublicAccess
         *        a consumer that will call methods on {@link BlockPublicAccess.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockPublicAccess(BlockPublicAccess)
         */
        default Builder blockPublicAccess(Consumer<BlockPublicAccess.Builder> blockPublicAccess) {
            return blockPublicAccess(BlockPublicAccess.builder().applyMutation(blockPublicAccess).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BlockPublicAccess blockPublicAccess;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountLevelPermissions model) {
            blockPublicAccess(model.blockPublicAccess);
        }

        public final BlockPublicAccess.Builder getBlockPublicAccess() {
            return blockPublicAccess != null ? blockPublicAccess.toBuilder() : null;
        }

        public final void setBlockPublicAccess(BlockPublicAccess.BuilderImpl blockPublicAccess) {
            this.blockPublicAccess = blockPublicAccess != null ? blockPublicAccess.build() : null;
        }

        @Override
        public final Builder blockPublicAccess(BlockPublicAccess blockPublicAccess) {
            this.blockPublicAccess = blockPublicAccess;
            return this;
        }

        @Override
        public AccountLevelPermissions build() {
            return new AccountLevelPermissions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
