/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies options related to data preview for viewing a sample of your data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamingDataPreviewOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<StreamingDataPreviewOptions.Builder, StreamingDataPreviewOptions> {
    private static final SdkField<Long> POLLING_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("PollingTime").getter(getter(StreamingDataPreviewOptions::pollingTime))
            .setter(setter(Builder::pollingTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PollingTime").build()).build();

    private static final SdkField<Long> RECORD_POLLING_LIMIT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("RecordPollingLimit").getter(getter(StreamingDataPreviewOptions::recordPollingLimit))
            .setter(setter(Builder::recordPollingLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordPollingLimit").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLLING_TIME_FIELD,
            RECORD_POLLING_LIMIT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long pollingTime;

    private final Long recordPollingLimit;

    private StreamingDataPreviewOptions(BuilderImpl builder) {
        this.pollingTime = builder.pollingTime;
        this.recordPollingLimit = builder.recordPollingLimit;
    }

    /**
     * <p>
     * The polling time in milliseconds.
     * </p>
     * 
     * @return The polling time in milliseconds.
     */
    public final Long pollingTime() {
        return pollingTime;
    }

    /**
     * <p>
     * The limit to the number of records polled.
     * </p>
     * 
     * @return The limit to the number of records polled.
     */
    public final Long recordPollingLimit() {
        return recordPollingLimit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pollingTime());
        hashCode = 31 * hashCode + Objects.hashCode(recordPollingLimit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamingDataPreviewOptions)) {
            return false;
        }
        StreamingDataPreviewOptions other = (StreamingDataPreviewOptions) obj;
        return Objects.equals(pollingTime(), other.pollingTime())
                && Objects.equals(recordPollingLimit(), other.recordPollingLimit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StreamingDataPreviewOptions").add("PollingTime", pollingTime())
                .add("RecordPollingLimit", recordPollingLimit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PollingTime":
            return Optional.ofNullable(clazz.cast(pollingTime()));
        case "RecordPollingLimit":
            return Optional.ofNullable(clazz.cast(recordPollingLimit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamingDataPreviewOptions, T> g) {
        return obj -> g.apply((StreamingDataPreviewOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamingDataPreviewOptions> {
        /**
         * <p>
         * The polling time in milliseconds.
         * </p>
         * 
         * @param pollingTime
         *        The polling time in milliseconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pollingTime(Long pollingTime);

        /**
         * <p>
         * The limit to the number of records polled.
         * </p>
         * 
         * @param recordPollingLimit
         *        The limit to the number of records polled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordPollingLimit(Long recordPollingLimit);
    }

    static final class BuilderImpl implements Builder {
        private Long pollingTime;

        private Long recordPollingLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamingDataPreviewOptions model) {
            pollingTime(model.pollingTime);
            recordPollingLimit(model.recordPollingLimit);
        }

        public final Long getPollingTime() {
            return pollingTime;
        }

        public final void setPollingTime(Long pollingTime) {
            this.pollingTime = pollingTime;
        }

        @Override
        public final Builder pollingTime(Long pollingTime) {
            this.pollingTime = pollingTime;
            return this;
        }

        public final Long getRecordPollingLimit() {
            return recordPollingLimit;
        }

        public final void setRecordPollingLimit(Long recordPollingLimit) {
            this.recordPollingLimit = recordPollingLimit;
        }

        @Override
        public final Builder recordPollingLimit(Long recordPollingLimit) {
            this.recordPollingLimit = recordPollingLimit;
            return this;
        }

        @Override
        public StreamingDataPreviewOptions build() {
            return new StreamingDataPreviewOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
