/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.globalaccelerator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type for the endpoint group for a custom routing accelerator. An Amazon Web Services Region can have only
 * one endpoint group for a specific listener.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomRoutingEndpointGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomRoutingEndpointGroup.Builder, CustomRoutingEndpointGroup> {
    private static final SdkField<String> ENDPOINT_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointGroupArn").getter(getter(CustomRoutingEndpointGroup::endpointGroupArn))
            .setter(setter(Builder::endpointGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointGroupArn").build()).build();

    private static final SdkField<String> ENDPOINT_GROUP_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointGroupRegion").getter(getter(CustomRoutingEndpointGroup::endpointGroupRegion))
            .setter(setter(Builder::endpointGroupRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointGroupRegion").build())
            .build();

    private static final SdkField<List<CustomRoutingDestinationDescription>> DESTINATION_DESCRIPTIONS_FIELD = SdkField
            .<List<CustomRoutingDestinationDescription>> builder(MarshallingType.LIST)
            .memberName("DestinationDescriptions")
            .getter(getter(CustomRoutingEndpointGroup::destinationDescriptions))
            .setter(setter(Builder::destinationDescriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationDescriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomRoutingDestinationDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomRoutingDestinationDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CustomRoutingEndpointDescription>> ENDPOINT_DESCRIPTIONS_FIELD = SdkField
            .<List<CustomRoutingEndpointDescription>> builder(MarshallingType.LIST)
            .memberName("EndpointDescriptions")
            .getter(getter(CustomRoutingEndpointGroup::endpointDescriptions))
            .setter(setter(Builder::endpointDescriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointDescriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomRoutingEndpointDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomRoutingEndpointDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_GROUP_ARN_FIELD,
            ENDPOINT_GROUP_REGION_FIELD, DESTINATION_DESCRIPTIONS_FIELD, ENDPOINT_DESCRIPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String endpointGroupArn;

    private final String endpointGroupRegion;

    private final List<CustomRoutingDestinationDescription> destinationDescriptions;

    private final List<CustomRoutingEndpointDescription> endpointDescriptions;

    private CustomRoutingEndpointGroup(BuilderImpl builder) {
        this.endpointGroupArn = builder.endpointGroupArn;
        this.endpointGroupRegion = builder.endpointGroupRegion;
        this.destinationDescriptions = builder.destinationDescriptions;
        this.endpointDescriptions = builder.endpointDescriptions;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the endpoint group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the endpoint group.
     */
    public final String endpointGroupArn() {
        return endpointGroupArn;
    }

    /**
     * <p>
     * The Amazon Web Services Region where the endpoint group is located.
     * </p>
     * 
     * @return The Amazon Web Services Region where the endpoint group is located.
     */
    public final String endpointGroupRegion() {
        return endpointGroupRegion;
    }

    /**
     * For responses, this returns true if the service returned a value for the DestinationDescriptions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDestinationDescriptions() {
        return destinationDescriptions != null && !(destinationDescriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * For a custom routing accelerator, describes the port range and protocol for all endpoints (virtual private cloud
     * subnets) in an endpoint group to accept client traffic on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestinationDescriptions} method.
     * </p>
     * 
     * @return For a custom routing accelerator, describes the port range and protocol for all endpoints (virtual
     *         private cloud subnets) in an endpoint group to accept client traffic on.
     */
    public final List<CustomRoutingDestinationDescription> destinationDescriptions() {
        return destinationDescriptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the EndpointDescriptions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEndpointDescriptions() {
        return endpointDescriptions != null && !(endpointDescriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * For a custom routing accelerator, describes the endpoints (virtual private cloud subnets) in an endpoint group to
     * accept client traffic on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEndpointDescriptions} method.
     * </p>
     * 
     * @return For a custom routing accelerator, describes the endpoints (virtual private cloud subnets) in an endpoint
     *         group to accept client traffic on.
     */
    public final List<CustomRoutingEndpointDescription> endpointDescriptions() {
        return endpointDescriptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endpointGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(endpointGroupRegion());
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinationDescriptions() ? destinationDescriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEndpointDescriptions() ? endpointDescriptions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomRoutingEndpointGroup)) {
            return false;
        }
        CustomRoutingEndpointGroup other = (CustomRoutingEndpointGroup) obj;
        return Objects.equals(endpointGroupArn(), other.endpointGroupArn())
                && Objects.equals(endpointGroupRegion(), other.endpointGroupRegion())
                && hasDestinationDescriptions() == other.hasDestinationDescriptions()
                && Objects.equals(destinationDescriptions(), other.destinationDescriptions())
                && hasEndpointDescriptions() == other.hasEndpointDescriptions()
                && Objects.equals(endpointDescriptions(), other.endpointDescriptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomRoutingEndpointGroup").add("EndpointGroupArn", endpointGroupArn())
                .add("EndpointGroupRegion", endpointGroupRegion())
                .add("DestinationDescriptions", hasDestinationDescriptions() ? destinationDescriptions() : null)
                .add("EndpointDescriptions", hasEndpointDescriptions() ? endpointDescriptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointGroupArn":
            return Optional.ofNullable(clazz.cast(endpointGroupArn()));
        case "EndpointGroupRegion":
            return Optional.ofNullable(clazz.cast(endpointGroupRegion()));
        case "DestinationDescriptions":
            return Optional.ofNullable(clazz.cast(destinationDescriptions()));
        case "EndpointDescriptions":
            return Optional.ofNullable(clazz.cast(endpointDescriptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomRoutingEndpointGroup, T> g) {
        return obj -> g.apply((CustomRoutingEndpointGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomRoutingEndpointGroup> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the endpoint group.
         * </p>
         * 
         * @param endpointGroupArn
         *        The Amazon Resource Name (ARN) of the endpoint group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointGroupArn(String endpointGroupArn);

        /**
         * <p>
         * The Amazon Web Services Region where the endpoint group is located.
         * </p>
         * 
         * @param endpointGroupRegion
         *        The Amazon Web Services Region where the endpoint group is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointGroupRegion(String endpointGroupRegion);

        /**
         * <p>
         * For a custom routing accelerator, describes the port range and protocol for all endpoints (virtual private
         * cloud subnets) in an endpoint group to accept client traffic on.
         * </p>
         * 
         * @param destinationDescriptions
         *        For a custom routing accelerator, describes the port range and protocol for all endpoints (virtual
         *        private cloud subnets) in an endpoint group to accept client traffic on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationDescriptions(Collection<CustomRoutingDestinationDescription> destinationDescriptions);

        /**
         * <p>
         * For a custom routing accelerator, describes the port range and protocol for all endpoints (virtual private
         * cloud subnets) in an endpoint group to accept client traffic on.
         * </p>
         * 
         * @param destinationDescriptions
         *        For a custom routing accelerator, describes the port range and protocol for all endpoints (virtual
         *        private cloud subnets) in an endpoint group to accept client traffic on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationDescriptions(CustomRoutingDestinationDescription... destinationDescriptions);

        /**
         * <p>
         * For a custom routing accelerator, describes the port range and protocol for all endpoints (virtual private
         * cloud subnets) in an endpoint group to accept client traffic on.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingDestinationDescription.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingDestinationDescription#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingDestinationDescription.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #destinationDescriptions(List<CustomRoutingDestinationDescription>)}.
         * 
         * @param destinationDescriptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingDestinationDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationDescriptions(java.util.Collection<CustomRoutingDestinationDescription>)
         */
        Builder destinationDescriptions(Consumer<CustomRoutingDestinationDescription.Builder>... destinationDescriptions);

        /**
         * <p>
         * For a custom routing accelerator, describes the endpoints (virtual private cloud subnets) in an endpoint
         * group to accept client traffic on.
         * </p>
         * 
         * @param endpointDescriptions
         *        For a custom routing accelerator, describes the endpoints (virtual private cloud subnets) in an
         *        endpoint group to accept client traffic on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointDescriptions(Collection<CustomRoutingEndpointDescription> endpointDescriptions);

        /**
         * <p>
         * For a custom routing accelerator, describes the endpoints (virtual private cloud subnets) in an endpoint
         * group to accept client traffic on.
         * </p>
         * 
         * @param endpointDescriptions
         *        For a custom routing accelerator, describes the endpoints (virtual private cloud subnets) in an
         *        endpoint group to accept client traffic on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointDescriptions(CustomRoutingEndpointDescription... endpointDescriptions);

        /**
         * <p>
         * For a custom routing accelerator, describes the endpoints (virtual private cloud subnets) in an endpoint
         * group to accept client traffic on.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingEndpointDescription.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingEndpointDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingEndpointDescription.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #endpointDescriptions(List<CustomRoutingEndpointDescription>)}.
         * 
         * @param endpointDescriptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.globalaccelerator.model.CustomRoutingEndpointDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointDescriptions(java.util.Collection<CustomRoutingEndpointDescription>)
         */
        Builder endpointDescriptions(Consumer<CustomRoutingEndpointDescription.Builder>... endpointDescriptions);
    }

    static final class BuilderImpl implements Builder {
        private String endpointGroupArn;

        private String endpointGroupRegion;

        private List<CustomRoutingDestinationDescription> destinationDescriptions = DefaultSdkAutoConstructList.getInstance();

        private List<CustomRoutingEndpointDescription> endpointDescriptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CustomRoutingEndpointGroup model) {
            endpointGroupArn(model.endpointGroupArn);
            endpointGroupRegion(model.endpointGroupRegion);
            destinationDescriptions(model.destinationDescriptions);
            endpointDescriptions(model.endpointDescriptions);
        }

        public final String getEndpointGroupArn() {
            return endpointGroupArn;
        }

        public final void setEndpointGroupArn(String endpointGroupArn) {
            this.endpointGroupArn = endpointGroupArn;
        }

        @Override
        public final Builder endpointGroupArn(String endpointGroupArn) {
            this.endpointGroupArn = endpointGroupArn;
            return this;
        }

        public final String getEndpointGroupRegion() {
            return endpointGroupRegion;
        }

        public final void setEndpointGroupRegion(String endpointGroupRegion) {
            this.endpointGroupRegion = endpointGroupRegion;
        }

        @Override
        public final Builder endpointGroupRegion(String endpointGroupRegion) {
            this.endpointGroupRegion = endpointGroupRegion;
            return this;
        }

        public final List<CustomRoutingDestinationDescription.Builder> getDestinationDescriptions() {
            List<CustomRoutingDestinationDescription.Builder> result = CustomRoutingDestinationDescriptionsCopier
                    .copyToBuilder(this.destinationDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinationDescriptions(
                Collection<CustomRoutingDestinationDescription.BuilderImpl> destinationDescriptions) {
            this.destinationDescriptions = CustomRoutingDestinationDescriptionsCopier.copyFromBuilder(destinationDescriptions);
        }

        @Override
        public final Builder destinationDescriptions(Collection<CustomRoutingDestinationDescription> destinationDescriptions) {
            this.destinationDescriptions = CustomRoutingDestinationDescriptionsCopier.copy(destinationDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationDescriptions(CustomRoutingDestinationDescription... destinationDescriptions) {
            destinationDescriptions(Arrays.asList(destinationDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationDescriptions(
                Consumer<CustomRoutingDestinationDescription.Builder>... destinationDescriptions) {
            destinationDescriptions(Stream.of(destinationDescriptions)
                    .map(c -> CustomRoutingDestinationDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CustomRoutingEndpointDescription.Builder> getEndpointDescriptions() {
            List<CustomRoutingEndpointDescription.Builder> result = CustomRoutingEndpointDescriptionsCopier
                    .copyToBuilder(this.endpointDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEndpointDescriptions(Collection<CustomRoutingEndpointDescription.BuilderImpl> endpointDescriptions) {
            this.endpointDescriptions = CustomRoutingEndpointDescriptionsCopier.copyFromBuilder(endpointDescriptions);
        }

        @Override
        public final Builder endpointDescriptions(Collection<CustomRoutingEndpointDescription> endpointDescriptions) {
            this.endpointDescriptions = CustomRoutingEndpointDescriptionsCopier.copy(endpointDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointDescriptions(CustomRoutingEndpointDescription... endpointDescriptions) {
            endpointDescriptions(Arrays.asList(endpointDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpointDescriptions(Consumer<CustomRoutingEndpointDescription.Builder>... endpointDescriptions) {
            endpointDescriptions(Stream.of(endpointDescriptions)
                    .map(c -> CustomRoutingEndpointDescription.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CustomRoutingEndpointGroup build() {
            return new CustomRoutingEndpointGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
