/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartMatchBackfillRequest extends GameLiftRequest implements
        ToCopyableBuilder<StartMatchBackfillRequest.Builder, StartMatchBackfillRequest> {
    private static final SdkField<String> TICKET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TicketId").getter(getter(StartMatchBackfillRequest::ticketId)).setter(setter(Builder::ticketId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TicketId").build()).build();

    private static final SdkField<String> CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationName").getter(getter(StartMatchBackfillRequest::configurationName))
            .setter(setter(Builder::configurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationName").build()).build();

    private static final SdkField<String> GAME_SESSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GameSessionArn").getter(getter(StartMatchBackfillRequest::gameSessionArn))
            .setter(setter(Builder::gameSessionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionArn").build()).build();

    private static final SdkField<List<Player>> PLAYERS_FIELD = SdkField
            .<List<Player>> builder(MarshallingType.LIST)
            .memberName("Players")
            .getter(getter(StartMatchBackfillRequest::players))
            .setter(setter(Builder::players))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Players").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Player> builder(MarshallingType.SDK_POJO)
                                            .constructor(Player::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TICKET_ID_FIELD,
            CONFIGURATION_NAME_FIELD, GAME_SESSION_ARN_FIELD, PLAYERS_FIELD));

    private final String ticketId;

    private final String configurationName;

    private final String gameSessionArn;

    private final List<Player> players;

    private StartMatchBackfillRequest(BuilderImpl builder) {
        super(builder);
        this.ticketId = builder.ticketId;
        this.configurationName = builder.configurationName;
        this.gameSessionArn = builder.gameSessionArn;
        this.players = builder.players;
    }

    /**
     * <p>
     * A unique identifier for a matchmaking ticket. If no ticket ID is specified here, Amazon GameLift will generate
     * one in the form of a UUID. Use this identifier to track the match backfill ticket status and retrieve match
     * results.
     * </p>
     * 
     * @return A unique identifier for a matchmaking ticket. If no ticket ID is specified here, Amazon GameLift will
     *         generate one in the form of a UUID. Use this identifier to track the match backfill ticket status and
     *         retrieve match results.
     */
    public final String ticketId() {
        return ticketId;
    }

    /**
     * <p>
     * Name of the matchmaker to use for this request. You can use either the configuration name or ARN value. The ARN
     * of the matchmaker that was used with the original game session is listed in the <code>GameSession</code> object,
     * <code>MatchmakerData</code> property.
     * </p>
     * 
     * @return Name of the matchmaker to use for this request. You can use either the configuration name or ARN value.
     *         The ARN of the matchmaker that was used with the original game session is listed in the
     *         <code>GameSession</code> object, <code>MatchmakerData</code> property.
     */
    public final String configurationName() {
        return configurationName;
    }

    /**
     * <p>
     * A unique identifier for the game session. Use the game session ID. When using FlexMatch as a standalone
     * matchmaking solution, this parameter is not needed.
     * </p>
     * 
     * @return A unique identifier for the game session. Use the game session ID. When using FlexMatch as a standalone
     *         matchmaking solution, this parameter is not needed.
     */
    public final String gameSessionArn() {
        return gameSessionArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Players property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPlayers() {
        return players != null && !(players instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Match information on all players that are currently assigned to the game session. This information is used by the
     * matchmaker to find new players and add them to the existing game.
     * </p>
     * <p>
     * You can include up to 199 <code>Players</code> in a <code>StartMatchBackfill</code> request.
     * </p>
     * <ul>
     * <li>
     * <p>
     * PlayerID, PlayerAttributes, Team -- This information is maintained in the <code>GameSession</code> object,
     * <code>MatchmakerData</code> property, for all players who are currently assigned to the game session. The
     * matchmaker data is in JSON syntax, formatted as a string. For more details, see <a
     * href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-server.html#match-server-data"> Match
     * Data</a>.
     * </p>
     * <p>
     * The backfill request must specify the team membership for every player. Do not specify team if you are not using
     * backfill.
     * </p>
     * </li>
     * <li>
     * <p>
     * LatencyInMs -- If the matchmaker uses player latency, include a latency value, in milliseconds, for the Region
     * that the game session is currently in. Do not include latency values for any other Region.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPlayers} method.
     * </p>
     * 
     * @return Match information on all players that are currently assigned to the game session. This information is
     *         used by the matchmaker to find new players and add them to the existing game.</p>
     *         <p>
     *         You can include up to 199 <code>Players</code> in a <code>StartMatchBackfill</code> request.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PlayerID, PlayerAttributes, Team -- This information is maintained in the <code>GameSession</code>
     *         object, <code>MatchmakerData</code> property, for all players who are currently assigned to the game
     *         session. The matchmaker data is in JSON syntax, formatted as a string. For more details, see <a
     *         href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-server.html#match-server-data">
     *         Match Data</a>.
     *         </p>
     *         <p>
     *         The backfill request must specify the team membership for every player. Do not specify team if you are
     *         not using backfill.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LatencyInMs -- If the matchmaker uses player latency, include a latency value, in milliseconds, for the
     *         Region that the game session is currently in. Do not include latency values for any other Region.
     *         </p>
     *         </li>
     */
    public final List<Player> players() {
        return players;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ticketId());
        hashCode = 31 * hashCode + Objects.hashCode(configurationName());
        hashCode = 31 * hashCode + Objects.hashCode(gameSessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasPlayers() ? players() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMatchBackfillRequest)) {
            return false;
        }
        StartMatchBackfillRequest other = (StartMatchBackfillRequest) obj;
        return Objects.equals(ticketId(), other.ticketId()) && Objects.equals(configurationName(), other.configurationName())
                && Objects.equals(gameSessionArn(), other.gameSessionArn()) && hasPlayers() == other.hasPlayers()
                && Objects.equals(players(), other.players());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartMatchBackfillRequest").add("TicketId", ticketId())
                .add("ConfigurationName", configurationName()).add("GameSessionArn", gameSessionArn())
                .add("Players", hasPlayers() ? players() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TicketId":
            return Optional.ofNullable(clazz.cast(ticketId()));
        case "ConfigurationName":
            return Optional.ofNullable(clazz.cast(configurationName()));
        case "GameSessionArn":
            return Optional.ofNullable(clazz.cast(gameSessionArn()));
        case "Players":
            return Optional.ofNullable(clazz.cast(players()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartMatchBackfillRequest, T> g) {
        return obj -> g.apply((StartMatchBackfillRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartMatchBackfillRequest> {
        /**
         * <p>
         * A unique identifier for a matchmaking ticket. If no ticket ID is specified here, Amazon GameLift will
         * generate one in the form of a UUID. Use this identifier to track the match backfill ticket status and
         * retrieve match results.
         * </p>
         * 
         * @param ticketId
         *        A unique identifier for a matchmaking ticket. If no ticket ID is specified here, Amazon GameLift will
         *        generate one in the form of a UUID. Use this identifier to track the match backfill ticket status and
         *        retrieve match results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ticketId(String ticketId);

        /**
         * <p>
         * Name of the matchmaker to use for this request. You can use either the configuration name or ARN value. The
         * ARN of the matchmaker that was used with the original game session is listed in the <code>GameSession</code>
         * object, <code>MatchmakerData</code> property.
         * </p>
         * 
         * @param configurationName
         *        Name of the matchmaker to use for this request. You can use either the configuration name or ARN
         *        value. The ARN of the matchmaker that was used with the original game session is listed in the
         *        <code>GameSession</code> object, <code>MatchmakerData</code> property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationName(String configurationName);

        /**
         * <p>
         * A unique identifier for the game session. Use the game session ID. When using FlexMatch as a standalone
         * matchmaking solution, this parameter is not needed.
         * </p>
         * 
         * @param gameSessionArn
         *        A unique identifier for the game session. Use the game session ID. When using FlexMatch as a
         *        standalone matchmaking solution, this parameter is not needed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameSessionArn(String gameSessionArn);

        /**
         * <p>
         * Match information on all players that are currently assigned to the game session. This information is used by
         * the matchmaker to find new players and add them to the existing game.
         * </p>
         * <p>
         * You can include up to 199 <code>Players</code> in a <code>StartMatchBackfill</code> request.
         * </p>
         * <ul>
         * <li>
         * <p>
         * PlayerID, PlayerAttributes, Team -- This information is maintained in the <code>GameSession</code> object,
         * <code>MatchmakerData</code> property, for all players who are currently assigned to the game session. The
         * matchmaker data is in JSON syntax, formatted as a string. For more details, see <a
         * href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-server.html#match-server-data"> Match
         * Data</a>.
         * </p>
         * <p>
         * The backfill request must specify the team membership for every player. Do not specify team if you are not
         * using backfill.
         * </p>
         * </li>
         * <li>
         * <p>
         * LatencyInMs -- If the matchmaker uses player latency, include a latency value, in milliseconds, for the
         * Region that the game session is currently in. Do not include latency values for any other Region.
         * </p>
         * </li>
         * </ul>
         * 
         * @param players
         *        Match information on all players that are currently assigned to the game session. This information is
         *        used by the matchmaker to find new players and add them to the existing game.</p>
         *        <p>
         *        You can include up to 199 <code>Players</code> in a <code>StartMatchBackfill</code> request.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PlayerID, PlayerAttributes, Team -- This information is maintained in the <code>GameSession</code>
         *        object, <code>MatchmakerData</code> property, for all players who are currently assigned to the game
         *        session. The matchmaker data is in JSON syntax, formatted as a string. For more details, see <a href=
         *        "https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-server.html#match-server-data">
         *        Match Data</a>.
         *        </p>
         *        <p>
         *        The backfill request must specify the team membership for every player. Do not specify team if you are
         *        not using backfill.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LatencyInMs -- If the matchmaker uses player latency, include a latency value, in milliseconds, for
         *        the Region that the game session is currently in. Do not include latency values for any other Region.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder players(Collection<Player> players);

        /**
         * <p>
         * Match information on all players that are currently assigned to the game session. This information is used by
         * the matchmaker to find new players and add them to the existing game.
         * </p>
         * <p>
         * You can include up to 199 <code>Players</code> in a <code>StartMatchBackfill</code> request.
         * </p>
         * <ul>
         * <li>
         * <p>
         * PlayerID, PlayerAttributes, Team -- This information is maintained in the <code>GameSession</code> object,
         * <code>MatchmakerData</code> property, for all players who are currently assigned to the game session. The
         * matchmaker data is in JSON syntax, formatted as a string. For more details, see <a
         * href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-server.html#match-server-data"> Match
         * Data</a>.
         * </p>
         * <p>
         * The backfill request must specify the team membership for every player. Do not specify team if you are not
         * using backfill.
         * </p>
         * </li>
         * <li>
         * <p>
         * LatencyInMs -- If the matchmaker uses player latency, include a latency value, in milliseconds, for the
         * Region that the game session is currently in. Do not include latency values for any other Region.
         * </p>
         * </li>
         * </ul>
         * 
         * @param players
         *        Match information on all players that are currently assigned to the game session. This information is
         *        used by the matchmaker to find new players and add them to the existing game.</p>
         *        <p>
         *        You can include up to 199 <code>Players</code> in a <code>StartMatchBackfill</code> request.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PlayerID, PlayerAttributes, Team -- This information is maintained in the <code>GameSession</code>
         *        object, <code>MatchmakerData</code> property, for all players who are currently assigned to the game
         *        session. The matchmaker data is in JSON syntax, formatted as a string. For more details, see <a href=
         *        "https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-server.html#match-server-data">
         *        Match Data</a>.
         *        </p>
         *        <p>
         *        The backfill request must specify the team membership for every player. Do not specify team if you are
         *        not using backfill.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LatencyInMs -- If the matchmaker uses player latency, include a latency value, in milliseconds, for
         *        the Region that the game session is currently in. Do not include latency values for any other Region.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder players(Player... players);

        /**
         * <p>
         * Match information on all players that are currently assigned to the game session. This information is used by
         * the matchmaker to find new players and add them to the existing game.
         * </p>
         * <p>
         * You can include up to 199 <code>Players</code> in a <code>StartMatchBackfill</code> request.
         * </p>
         * <ul>
         * <li>
         * <p>
         * PlayerID, PlayerAttributes, Team -- This information is maintained in the <code>GameSession</code> object,
         * <code>MatchmakerData</code> property, for all players who are currently assigned to the game session. The
         * matchmaker data is in JSON syntax, formatted as a string. For more details, see <a
         * href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-server.html#match-server-data"> Match
         * Data</a>.
         * </p>
         * <p>
         * The backfill request must specify the team membership for every player. Do not specify team if you are not
         * using backfill.
         * </p>
         * </li>
         * <li>
         * <p>
         * LatencyInMs -- If the matchmaker uses player latency, include a latency value, in milliseconds, for the
         * Region that the game session is currently in. Do not include latency values for any other Region.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.gamelift.model.Player.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.gamelift.model.Player#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.gamelift.model.Player.Builder#build()} is called immediately and its
         * result is passed to {@link #players(List<Player>)}.
         * 
         * @param players
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.gamelift.model.Player.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #players(java.util.Collection<Player>)
         */
        Builder players(Consumer<Player.Builder>... players);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String ticketId;

        private String configurationName;

        private String gameSessionArn;

        private List<Player> players = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartMatchBackfillRequest model) {
            super(model);
            ticketId(model.ticketId);
            configurationName(model.configurationName);
            gameSessionArn(model.gameSessionArn);
            players(model.players);
        }

        public final String getTicketId() {
            return ticketId;
        }

        public final void setTicketId(String ticketId) {
            this.ticketId = ticketId;
        }

        @Override
        public final Builder ticketId(String ticketId) {
            this.ticketId = ticketId;
            return this;
        }

        public final String getConfigurationName() {
            return configurationName;
        }

        public final void setConfigurationName(String configurationName) {
            this.configurationName = configurationName;
        }

        @Override
        public final Builder configurationName(String configurationName) {
            this.configurationName = configurationName;
            return this;
        }

        public final String getGameSessionArn() {
            return gameSessionArn;
        }

        public final void setGameSessionArn(String gameSessionArn) {
            this.gameSessionArn = gameSessionArn;
        }

        @Override
        public final Builder gameSessionArn(String gameSessionArn) {
            this.gameSessionArn = gameSessionArn;
            return this;
        }

        public final List<Player.Builder> getPlayers() {
            List<Player.Builder> result = PlayerListCopier.copyToBuilder(this.players);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlayers(Collection<Player.BuilderImpl> players) {
            this.players = PlayerListCopier.copyFromBuilder(players);
        }

        @Override
        public final Builder players(Collection<Player> players) {
            this.players = PlayerListCopier.copy(players);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder players(Player... players) {
            players(Arrays.asList(players));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder players(Consumer<Player.Builder>... players) {
            players(Stream.of(players).map(c -> Player.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartMatchBackfillRequest build() {
            return new StartMatchBackfillRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
