/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeGameServerGroupResponse extends GameLiftResponse implements
        ToCopyableBuilder<DescribeGameServerGroupResponse.Builder, DescribeGameServerGroupResponse> {
    private static final SdkField<GameServerGroup> GAME_SERVER_GROUP_FIELD = SdkField
            .<GameServerGroup> builder(MarshallingType.SDK_POJO).memberName("GameServerGroup")
            .getter(getter(DescribeGameServerGroupResponse::gameServerGroup)).setter(setter(Builder::gameServerGroup))
            .constructor(GameServerGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SERVER_GROUP_FIELD));

    private final GameServerGroup gameServerGroup;

    private DescribeGameServerGroupResponse(BuilderImpl builder) {
        super(builder);
        this.gameServerGroup = builder.gameServerGroup;
    }

    /**
     * <p>
     * An object with the property settings for the requested game server group resource.
     * </p>
     * 
     * @return An object with the property settings for the requested game server group resource.
     */
    public final GameServerGroup gameServerGroup() {
        return gameServerGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gameServerGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGameServerGroupResponse)) {
            return false;
        }
        DescribeGameServerGroupResponse other = (DescribeGameServerGroupResponse) obj;
        return Objects.equals(gameServerGroup(), other.gameServerGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeGameServerGroupResponse").add("GameServerGroup", gameServerGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GameServerGroup":
            return Optional.ofNullable(clazz.cast(gameServerGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeGameServerGroupResponse, T> g) {
        return obj -> g.apply((DescribeGameServerGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeGameServerGroupResponse> {
        /**
         * <p>
         * An object with the property settings for the requested game server group resource.
         * </p>
         * 
         * @param gameServerGroup
         *        An object with the property settings for the requested game server group resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameServerGroup(GameServerGroup gameServerGroup);

        /**
         * <p>
         * An object with the property settings for the requested game server group resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link GameServerGroup.Builder} avoiding the
         * need to create one manually via {@link GameServerGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GameServerGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #gameServerGroup(GameServerGroup)}.
         * 
         * @param gameServerGroup
         *        a consumer that will call methods on {@link GameServerGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gameServerGroup(GameServerGroup)
         */
        default Builder gameServerGroup(Consumer<GameServerGroup.Builder> gameServerGroup) {
            return gameServerGroup(GameServerGroup.builder().applyMutation(gameServerGroup).build());
        }
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private GameServerGroup gameServerGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGameServerGroupResponse model) {
            super(model);
            gameServerGroup(model.gameServerGroup);
        }

        public final GameServerGroup.Builder getGameServerGroup() {
            return gameServerGroup != null ? gameServerGroup.toBuilder() : null;
        }

        public final void setGameServerGroup(GameServerGroup.BuilderImpl gameServerGroup) {
            this.gameServerGroup = gameServerGroup != null ? gameServerGroup.build() : null;
        }

        @Override
        public final Builder gameServerGroup(GameServerGroup gameServerGroup) {
            this.gameServerGroup = gameServerGroup;
            return this;
        }

        @Override
        public DescribeGameServerGroupResponse build() {
            return new DescribeGameServerGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
