/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFileCacheResponse extends FSxResponse implements
        ToCopyableBuilder<CreateFileCacheResponse.Builder, CreateFileCacheResponse> {
    private static final SdkField<FileCacheCreating> FILE_CACHE_FIELD = SdkField
            .<FileCacheCreating> builder(MarshallingType.SDK_POJO).memberName("FileCache")
            .getter(getter(CreateFileCacheResponse::fileCache)).setter(setter(Builder::fileCache))
            .constructor(FileCacheCreating::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileCache").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_CACHE_FIELD));

    private final FileCacheCreating fileCache;

    private CreateFileCacheResponse(BuilderImpl builder) {
        super(builder);
        this.fileCache = builder.fileCache;
    }

    /**
     * <p>
     * A description of the cache that was created.
     * </p>
     * 
     * @return A description of the cache that was created.
     */
    public final FileCacheCreating fileCache() {
        return fileCache;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fileCache());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFileCacheResponse)) {
            return false;
        }
        CreateFileCacheResponse other = (CreateFileCacheResponse) obj;
        return Objects.equals(fileCache(), other.fileCache());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFileCacheResponse").add("FileCache", fileCache()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileCache":
            return Optional.ofNullable(clazz.cast(fileCache()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFileCacheResponse, T> g) {
        return obj -> g.apply((CreateFileCacheResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FSxResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateFileCacheResponse> {
        /**
         * <p>
         * A description of the cache that was created.
         * </p>
         * 
         * @param fileCache
         *        A description of the cache that was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileCache(FileCacheCreating fileCache);

        /**
         * <p>
         * A description of the cache that was created.
         * </p>
         * This is a convenience method that creates an instance of the {@link FileCacheCreating.Builder} avoiding the
         * need to create one manually via {@link FileCacheCreating#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FileCacheCreating.Builder#build()} is called immediately and its
         * result is passed to {@link #fileCache(FileCacheCreating)}.
         * 
         * @param fileCache
         *        a consumer that will call methods on {@link FileCacheCreating.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileCache(FileCacheCreating)
         */
        default Builder fileCache(Consumer<FileCacheCreating.Builder> fileCache) {
            return fileCache(FileCacheCreating.builder().applyMutation(fileCache).build());
        }
    }

    static final class BuilderImpl extends FSxResponse.BuilderImpl implements Builder {
        private FileCacheCreating fileCache;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFileCacheResponse model) {
            super(model);
            fileCache(model.fileCache);
        }

        public final FileCacheCreating.Builder getFileCache() {
            return fileCache != null ? fileCache.toBuilder() : null;
        }

        public final void setFileCache(FileCacheCreating.BuilderImpl fileCache) {
            this.fileCache = fileCache != null ? fileCache.build() : null;
        }

        @Override
        public final Builder fileCache(FileCacheCreating fileCache) {
            this.fileCache = fileCache;
            return this;
        }

        @Override
        public CreateFileCacheResponse build() {
            return new CreateFileCacheResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
