/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a Kinesis data stream used as the source for a Kinesis Data Firehose delivery stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<SourceDescription.Builder, SourceDescription> {
    private static final SdkField<KinesisStreamSourceDescription> KINESIS_STREAM_SOURCE_DESCRIPTION_FIELD = SdkField
            .<KinesisStreamSourceDescription> builder(MarshallingType.SDK_POJO)
            .memberName("KinesisStreamSourceDescription")
            .getter(getter(SourceDescription::kinesisStreamSourceDescription))
            .setter(setter(Builder::kinesisStreamSourceDescription))
            .constructor(KinesisStreamSourceDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisStreamSourceDescription")
                    .build()).build();

    private static final SdkField<MSKSourceDescription> MSK_SOURCE_DESCRIPTION_FIELD = SdkField
            .<MSKSourceDescription> builder(MarshallingType.SDK_POJO).memberName("MSKSourceDescription")
            .getter(getter(SourceDescription::mskSourceDescription)).setter(setter(Builder::mskSourceDescription))
            .constructor(MSKSourceDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MSKSourceDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            KINESIS_STREAM_SOURCE_DESCRIPTION_FIELD, MSK_SOURCE_DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final KinesisStreamSourceDescription kinesisStreamSourceDescription;

    private final MSKSourceDescription mskSourceDescription;

    private SourceDescription(BuilderImpl builder) {
        this.kinesisStreamSourceDescription = builder.kinesisStreamSourceDescription;
        this.mskSourceDescription = builder.mskSourceDescription;
    }

    /**
     * <p>
     * The <a>KinesisStreamSourceDescription</a> value for the source Kinesis data stream.
     * </p>
     * 
     * @return The <a>KinesisStreamSourceDescription</a> value for the source Kinesis data stream.
     */
    public final KinesisStreamSourceDescription kinesisStreamSourceDescription() {
        return kinesisStreamSourceDescription;
    }

    /**
     * <p>
     * The configuration description for the Amazon MSK cluster to be used as the source for a delivery stream.
     * </p>
     * 
     * @return The configuration description for the Amazon MSK cluster to be used as the source for a delivery stream.
     */
    public final MSKSourceDescription mskSourceDescription() {
        return mskSourceDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kinesisStreamSourceDescription());
        hashCode = 31 * hashCode + Objects.hashCode(mskSourceDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceDescription)) {
            return false;
        }
        SourceDescription other = (SourceDescription) obj;
        return Objects.equals(kinesisStreamSourceDescription(), other.kinesisStreamSourceDescription())
                && Objects.equals(mskSourceDescription(), other.mskSourceDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceDescription").add("KinesisStreamSourceDescription", kinesisStreamSourceDescription())
                .add("MSKSourceDescription", mskSourceDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KinesisStreamSourceDescription":
            return Optional.ofNullable(clazz.cast(kinesisStreamSourceDescription()));
        case "MSKSourceDescription":
            return Optional.ofNullable(clazz.cast(mskSourceDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceDescription, T> g) {
        return obj -> g.apply((SourceDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceDescription> {
        /**
         * <p>
         * The <a>KinesisStreamSourceDescription</a> value for the source Kinesis data stream.
         * </p>
         * 
         * @param kinesisStreamSourceDescription
         *        The <a>KinesisStreamSourceDescription</a> value for the source Kinesis data stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisStreamSourceDescription(KinesisStreamSourceDescription kinesisStreamSourceDescription);

        /**
         * <p>
         * The <a>KinesisStreamSourceDescription</a> value for the source Kinesis data stream.
         * </p>
         * This is a convenience method that creates an instance of the {@link KinesisStreamSourceDescription.Builder}
         * avoiding the need to create one manually via {@link KinesisStreamSourceDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KinesisStreamSourceDescription.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #kinesisStreamSourceDescription(KinesisStreamSourceDescription)}.
         * 
         * @param kinesisStreamSourceDescription
         *        a consumer that will call methods on {@link KinesisStreamSourceDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisStreamSourceDescription(KinesisStreamSourceDescription)
         */
        default Builder kinesisStreamSourceDescription(
                Consumer<KinesisStreamSourceDescription.Builder> kinesisStreamSourceDescription) {
            return kinesisStreamSourceDescription(KinesisStreamSourceDescription.builder()
                    .applyMutation(kinesisStreamSourceDescription).build());
        }

        /**
         * <p>
         * The configuration description for the Amazon MSK cluster to be used as the source for a delivery stream.
         * </p>
         * 
         * @param mskSourceDescription
         *        The configuration description for the Amazon MSK cluster to be used as the source for a delivery
         *        stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mskSourceDescription(MSKSourceDescription mskSourceDescription);

        /**
         * <p>
         * The configuration description for the Amazon MSK cluster to be used as the source for a delivery stream.
         * </p>
         * This is a convenience method that creates an instance of the {@link MSKSourceDescription.Builder} avoiding
         * the need to create one manually via {@link MSKSourceDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MSKSourceDescription.Builder#build()} is called immediately and
         * its result is passed to {@link #mskSourceDescription(MSKSourceDescription)}.
         * 
         * @param mskSourceDescription
         *        a consumer that will call methods on {@link MSKSourceDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mskSourceDescription(MSKSourceDescription)
         */
        default Builder mskSourceDescription(Consumer<MSKSourceDescription.Builder> mskSourceDescription) {
            return mskSourceDescription(MSKSourceDescription.builder().applyMutation(mskSourceDescription).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private KinesisStreamSourceDescription kinesisStreamSourceDescription;

        private MSKSourceDescription mskSourceDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceDescription model) {
            kinesisStreamSourceDescription(model.kinesisStreamSourceDescription);
            mskSourceDescription(model.mskSourceDescription);
        }

        public final KinesisStreamSourceDescription.Builder getKinesisStreamSourceDescription() {
            return kinesisStreamSourceDescription != null ? kinesisStreamSourceDescription.toBuilder() : null;
        }

        public final void setKinesisStreamSourceDescription(
                KinesisStreamSourceDescription.BuilderImpl kinesisStreamSourceDescription) {
            this.kinesisStreamSourceDescription = kinesisStreamSourceDescription != null ? kinesisStreamSourceDescription.build()
                    : null;
        }

        @Override
        public final Builder kinesisStreamSourceDescription(KinesisStreamSourceDescription kinesisStreamSourceDescription) {
            this.kinesisStreamSourceDescription = kinesisStreamSourceDescription;
            return this;
        }

        public final MSKSourceDescription.Builder getMskSourceDescription() {
            return mskSourceDescription != null ? mskSourceDescription.toBuilder() : null;
        }

        public final void setMskSourceDescription(MSKSourceDescription.BuilderImpl mskSourceDescription) {
            this.mskSourceDescription = mskSourceDescription != null ? mskSourceDescription.build() : null;
        }

        @Override
        public final Builder mskSourceDescription(MSKSourceDescription mskSourceDescription) {
            this.mskSourceDescription = mskSourceDescription;
            return this;
        }

        @Override
        public SourceDescription build() {
            return new SourceDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
