/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStudioSessionMappingsResponse extends EmrResponse implements
        ToCopyableBuilder<ListStudioSessionMappingsResponse.Builder, ListStudioSessionMappingsResponse> {
    private static final SdkField<List<SessionMappingSummary>> SESSION_MAPPINGS_FIELD = SdkField
            .<List<SessionMappingSummary>> builder(MarshallingType.LIST)
            .memberName("SessionMappings")
            .getter(getter(ListStudioSessionMappingsResponse::sessionMappings))
            .setter(setter(Builder::sessionMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SessionMappingSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(SessionMappingSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(ListStudioSessionMappingsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_MAPPINGS_FIELD,
            MARKER_FIELD));

    private final List<SessionMappingSummary> sessionMappings;

    private final String marker;

    private ListStudioSessionMappingsResponse(BuilderImpl builder) {
        super(builder);
        this.sessionMappings = builder.sessionMappings;
        this.marker = builder.marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the SessionMappings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSessionMappings() {
        return sessionMappings != null && !(sessionMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of session mapping summary objects. Each object includes session mapping details such as creation time,
     * identity type (user or group), and Amazon EMR Studio ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSessionMappings} method.
     * </p>
     * 
     * @return A list of session mapping summary objects. Each object includes session mapping details such as creation
     *         time, identity type (user or group), and Amazon EMR Studio ID.
     */
    public final List<SessionMappingSummary> sessionMappings() {
        return sessionMappings;
    }

    /**
     * <p>
     * The pagination token that indicates the next set of results to retrieve.
     * </p>
     * 
     * @return The pagination token that indicates the next set of results to retrieve.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSessionMappings() ? sessionMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStudioSessionMappingsResponse)) {
            return false;
        }
        ListStudioSessionMappingsResponse other = (ListStudioSessionMappingsResponse) obj;
        return hasSessionMappings() == other.hasSessionMappings() && Objects.equals(sessionMappings(), other.sessionMappings())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListStudioSessionMappingsResponse")
                .add("SessionMappings", hasSessionMappings() ? sessionMappings() : null).add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SessionMappings":
            return Optional.ofNullable(clazz.cast(sessionMappings()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStudioSessionMappingsResponse, T> g) {
        return obj -> g.apply((ListStudioSessionMappingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListStudioSessionMappingsResponse> {
        /**
         * <p>
         * A list of session mapping summary objects. Each object includes session mapping details such as creation
         * time, identity type (user or group), and Amazon EMR Studio ID.
         * </p>
         * 
         * @param sessionMappings
         *        A list of session mapping summary objects. Each object includes session mapping details such as
         *        creation time, identity type (user or group), and Amazon EMR Studio ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionMappings(Collection<SessionMappingSummary> sessionMappings);

        /**
         * <p>
         * A list of session mapping summary objects. Each object includes session mapping details such as creation
         * time, identity type (user or group), and Amazon EMR Studio ID.
         * </p>
         * 
         * @param sessionMappings
         *        A list of session mapping summary objects. Each object includes session mapping details such as
         *        creation time, identity type (user or group), and Amazon EMR Studio ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionMappings(SessionMappingSummary... sessionMappings);

        /**
         * <p>
         * A list of session mapping summary objects. Each object includes session mapping details such as creation
         * time, identity type (user or group), and Amazon EMR Studio ID.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.emr.model.SessionMappingSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.emr.model.SessionMappingSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.emr.model.SessionMappingSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #sessionMappings(List<SessionMappingSummary>)}.
         * 
         * @param sessionMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.emr.model.SessionMappingSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sessionMappings(java.util.Collection<SessionMappingSummary>)
         */
        Builder sessionMappings(Consumer<SessionMappingSummary.Builder>... sessionMappings);

        /**
         * <p>
         * The pagination token that indicates the next set of results to retrieve.
         * </p>
         * 
         * @param marker
         *        The pagination token that indicates the next set of results to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends EmrResponse.BuilderImpl implements Builder {
        private List<SessionMappingSummary> sessionMappings = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStudioSessionMappingsResponse model) {
            super(model);
            sessionMappings(model.sessionMappings);
            marker(model.marker);
        }

        public final List<SessionMappingSummary.Builder> getSessionMappings() {
            List<SessionMappingSummary.Builder> result = SessionMappingSummaryListCopier.copyToBuilder(this.sessionMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSessionMappings(Collection<SessionMappingSummary.BuilderImpl> sessionMappings) {
            this.sessionMappings = SessionMappingSummaryListCopier.copyFromBuilder(sessionMappings);
        }

        @Override
        public final Builder sessionMappings(Collection<SessionMappingSummary> sessionMappings) {
            this.sessionMappings = SessionMappingSummaryListCopier.copy(sessionMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessionMappings(SessionMappingSummary... sessionMappings) {
            sessionMappings(Arrays.asList(sessionMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessionMappings(Consumer<SessionMappingSummary.Builder>... sessionMappings) {
            sessionMappings(Stream.of(sessionMappings).map(c -> SessionMappingSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public ListStudioSessionMappingsResponse build() {
            return new ListStudioSessionMappingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
