/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.elasticsearch.internal.ElasticsearchServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.elasticsearch.model.AcceptInboundCrossClusterSearchConnectionRequest;
import software.amazon.awssdk.services.elasticsearch.model.AcceptInboundCrossClusterSearchConnectionResponse;
import software.amazon.awssdk.services.elasticsearch.model.AccessDeniedException;
import software.amazon.awssdk.services.elasticsearch.model.AddTagsRequest;
import software.amazon.awssdk.services.elasticsearch.model.AddTagsResponse;
import software.amazon.awssdk.services.elasticsearch.model.AssociatePackageRequest;
import software.amazon.awssdk.services.elasticsearch.model.AssociatePackageResponse;
import software.amazon.awssdk.services.elasticsearch.model.AuthorizeVpcEndpointAccessRequest;
import software.amazon.awssdk.services.elasticsearch.model.AuthorizeVpcEndpointAccessResponse;
import software.amazon.awssdk.services.elasticsearch.model.BaseException;
import software.amazon.awssdk.services.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateRequest;
import software.amazon.awssdk.services.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateResponse;
import software.amazon.awssdk.services.elasticsearch.model.ConflictException;
import software.amazon.awssdk.services.elasticsearch.model.CreateElasticsearchDomainRequest;
import software.amazon.awssdk.services.elasticsearch.model.CreateElasticsearchDomainResponse;
import software.amazon.awssdk.services.elasticsearch.model.CreateOutboundCrossClusterSearchConnectionRequest;
import software.amazon.awssdk.services.elasticsearch.model.CreateOutboundCrossClusterSearchConnectionResponse;
import software.amazon.awssdk.services.elasticsearch.model.CreatePackageRequest;
import software.amazon.awssdk.services.elasticsearch.model.CreatePackageResponse;
import software.amazon.awssdk.services.elasticsearch.model.CreateVpcEndpointRequest;
import software.amazon.awssdk.services.elasticsearch.model.CreateVpcEndpointResponse;
import software.amazon.awssdk.services.elasticsearch.model.DeleteElasticsearchDomainRequest;
import software.amazon.awssdk.services.elasticsearch.model.DeleteElasticsearchDomainResponse;
import software.amazon.awssdk.services.elasticsearch.model.DeleteElasticsearchServiceRoleRequest;
import software.amazon.awssdk.services.elasticsearch.model.DeleteElasticsearchServiceRoleResponse;
import software.amazon.awssdk.services.elasticsearch.model.DeleteInboundCrossClusterSearchConnectionRequest;
import software.amazon.awssdk.services.elasticsearch.model.DeleteInboundCrossClusterSearchConnectionResponse;
import software.amazon.awssdk.services.elasticsearch.model.DeleteOutboundCrossClusterSearchConnectionRequest;
import software.amazon.awssdk.services.elasticsearch.model.DeleteOutboundCrossClusterSearchConnectionResponse;
import software.amazon.awssdk.services.elasticsearch.model.DeletePackageRequest;
import software.amazon.awssdk.services.elasticsearch.model.DeletePackageResponse;
import software.amazon.awssdk.services.elasticsearch.model.DeleteVpcEndpointRequest;
import software.amazon.awssdk.services.elasticsearch.model.DeleteVpcEndpointResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeDomainAutoTunesRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeDomainAutoTunesResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeDomainChangeProgressRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeDomainChangeProgressResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainConfigRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainConfigResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainsRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainsResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchInstanceTypeLimitsRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchInstanceTypeLimitsResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeOutboundCrossClusterSearchConnectionsRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeOutboundCrossClusterSearchConnectionsResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribePackagesRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribePackagesResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse;
import software.amazon.awssdk.services.elasticsearch.model.DescribeVpcEndpointsRequest;
import software.amazon.awssdk.services.elasticsearch.model.DescribeVpcEndpointsResponse;
import software.amazon.awssdk.services.elasticsearch.model.DisabledOperationException;
import software.amazon.awssdk.services.elasticsearch.model.DissociatePackageRequest;
import software.amazon.awssdk.services.elasticsearch.model.DissociatePackageResponse;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchException;
import software.amazon.awssdk.services.elasticsearch.model.GetCompatibleElasticsearchVersionsRequest;
import software.amazon.awssdk.services.elasticsearch.model.GetCompatibleElasticsearchVersionsResponse;
import software.amazon.awssdk.services.elasticsearch.model.GetPackageVersionHistoryRequest;
import software.amazon.awssdk.services.elasticsearch.model.GetPackageVersionHistoryResponse;
import software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryRequest;
import software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryResponse;
import software.amazon.awssdk.services.elasticsearch.model.GetUpgradeStatusRequest;
import software.amazon.awssdk.services.elasticsearch.model.GetUpgradeStatusResponse;
import software.amazon.awssdk.services.elasticsearch.model.InternalException;
import software.amazon.awssdk.services.elasticsearch.model.InvalidPaginationTokenException;
import software.amazon.awssdk.services.elasticsearch.model.InvalidTypeException;
import software.amazon.awssdk.services.elasticsearch.model.LimitExceededException;
import software.amazon.awssdk.services.elasticsearch.model.ListDomainNamesRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListDomainNamesResponse;
import software.amazon.awssdk.services.elasticsearch.model.ListDomainsForPackageRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListDomainsForPackageResponse;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesResponse;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsResponse;
import software.amazon.awssdk.services.elasticsearch.model.ListPackagesForDomainRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListPackagesForDomainResponse;
import software.amazon.awssdk.services.elasticsearch.model.ListTagsRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListTagsResponse;
import software.amazon.awssdk.services.elasticsearch.model.ListVpcEndpointAccessRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListVpcEndpointAccessResponse;
import software.amazon.awssdk.services.elasticsearch.model.ListVpcEndpointsForDomainRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListVpcEndpointsForDomainResponse;
import software.amazon.awssdk.services.elasticsearch.model.ListVpcEndpointsRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListVpcEndpointsResponse;
import software.amazon.awssdk.services.elasticsearch.model.PurchaseReservedElasticsearchInstanceOfferingRequest;
import software.amazon.awssdk.services.elasticsearch.model.PurchaseReservedElasticsearchInstanceOfferingResponse;
import software.amazon.awssdk.services.elasticsearch.model.RejectInboundCrossClusterSearchConnectionRequest;
import software.amazon.awssdk.services.elasticsearch.model.RejectInboundCrossClusterSearchConnectionResponse;
import software.amazon.awssdk.services.elasticsearch.model.RemoveTagsRequest;
import software.amazon.awssdk.services.elasticsearch.model.RemoveTagsResponse;
import software.amazon.awssdk.services.elasticsearch.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.elasticsearch.model.ResourceNotFoundException;
import software.amazon.awssdk.services.elasticsearch.model.RevokeVpcEndpointAccessRequest;
import software.amazon.awssdk.services.elasticsearch.model.RevokeVpcEndpointAccessResponse;
import software.amazon.awssdk.services.elasticsearch.model.StartElasticsearchServiceSoftwareUpdateRequest;
import software.amazon.awssdk.services.elasticsearch.model.StartElasticsearchServiceSoftwareUpdateResponse;
import software.amazon.awssdk.services.elasticsearch.model.UpdateElasticsearchDomainConfigRequest;
import software.amazon.awssdk.services.elasticsearch.model.UpdateElasticsearchDomainConfigResponse;
import software.amazon.awssdk.services.elasticsearch.model.UpdatePackageRequest;
import software.amazon.awssdk.services.elasticsearch.model.UpdatePackageResponse;
import software.amazon.awssdk.services.elasticsearch.model.UpdateVpcEndpointRequest;
import software.amazon.awssdk.services.elasticsearch.model.UpdateVpcEndpointResponse;
import software.amazon.awssdk.services.elasticsearch.model.UpgradeElasticsearchDomainRequest;
import software.amazon.awssdk.services.elasticsearch.model.UpgradeElasticsearchDomainResponse;
import software.amazon.awssdk.services.elasticsearch.model.ValidationException;
import software.amazon.awssdk.services.elasticsearch.transform.AcceptInboundCrossClusterSearchConnectionRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.AddTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.AssociatePackageRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.AuthorizeVpcEndpointAccessRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.CancelElasticsearchServiceSoftwareUpdateRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.CreateElasticsearchDomainRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.CreateOutboundCrossClusterSearchConnectionRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.CreatePackageRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.CreateVpcEndpointRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DeleteElasticsearchDomainRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DeleteElasticsearchServiceRoleRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DeleteInboundCrossClusterSearchConnectionRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DeleteOutboundCrossClusterSearchConnectionRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DeletePackageRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DeleteVpcEndpointRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeDomainAutoTunesRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeDomainChangeProgressRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeElasticsearchDomainConfigRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeElasticsearchDomainRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeElasticsearchDomainsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeElasticsearchInstanceTypeLimitsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeInboundCrossClusterSearchConnectionsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeOutboundCrossClusterSearchConnectionsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribePackagesRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeReservedElasticsearchInstanceOfferingsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeReservedElasticsearchInstancesRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DescribeVpcEndpointsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.DissociatePackageRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.GetCompatibleElasticsearchVersionsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.GetPackageVersionHistoryRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.GetUpgradeHistoryRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.GetUpgradeStatusRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.ListDomainNamesRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.ListDomainsForPackageRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.ListElasticsearchInstanceTypesRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.ListElasticsearchVersionsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.ListPackagesForDomainRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.ListTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.ListVpcEndpointAccessRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.ListVpcEndpointsForDomainRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.ListVpcEndpointsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.PurchaseReservedElasticsearchInstanceOfferingRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.RejectInboundCrossClusterSearchConnectionRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.RemoveTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.RevokeVpcEndpointAccessRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.StartElasticsearchServiceSoftwareUpdateRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.UpdateElasticsearchDomainConfigRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.UpdatePackageRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.UpdateVpcEndpointRequestMarshaller;
import software.amazon.awssdk.services.elasticsearch.transform.UpgradeElasticsearchDomainRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link ElasticsearchAsyncClient}.
 *
 * @see ElasticsearchAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultElasticsearchAsyncClient implements ElasticsearchAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultElasticsearchAsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final ElasticsearchServiceClientConfiguration serviceClientConfiguration;

    protected DefaultElasticsearchAsyncClient(ElasticsearchServiceClientConfiguration serviceClientConfiguration,
            SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Allows the destination domain owner to accept an inbound cross-cluster search connection request.
     * </p>
     *
     * @param acceptInboundCrossClusterSearchConnectionRequest
     *        Container for the parameters to the <code><a>AcceptInboundCrossClusterSearchConnection</a></code>
     *        operation.
     * @return A Java Future containing the result of the AcceptInboundCrossClusterSearchConnection operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.AcceptInboundCrossClusterSearchConnection
     */
    @Override
    public CompletableFuture<AcceptInboundCrossClusterSearchConnectionResponse> acceptInboundCrossClusterSearchConnection(
            AcceptInboundCrossClusterSearchConnectionRequest acceptInboundCrossClusterSearchConnectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                acceptInboundCrossClusterSearchConnectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                acceptInboundCrossClusterSearchConnectionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptInboundCrossClusterSearchConnection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AcceptInboundCrossClusterSearchConnectionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, AcceptInboundCrossClusterSearchConnectionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AcceptInboundCrossClusterSearchConnectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AcceptInboundCrossClusterSearchConnectionRequest, AcceptInboundCrossClusterSearchConnectionResponse>()
                            .withOperationName("AcceptInboundCrossClusterSearchConnection")
                            .withMarshaller(new AcceptInboundCrossClusterSearchConnectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(acceptInboundCrossClusterSearchConnectionRequest));
            CompletableFuture<AcceptInboundCrossClusterSearchConnectionResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Attaches tags to an existing Elasticsearch domain. Tags are a set of case-sensitive key value pairs. An
     * Elasticsearch domain may have up to 10 tags. See <a href=
     * "http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-awsresorcetagging"
     * target="_blank"> Tagging Amazon Elasticsearch Service Domains for more information.</a>
     * </p>
     *
     * @param addTagsRequest
     *        Container for the parameters to the <code><a>AddTags</a></code> operation. Specify the tags that you want
     *        to attach to the Elasticsearch domain.
     * @return A Java Future containing the result of the AddTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.AddTags
     */
    @Override
    public CompletableFuture<AddTagsResponse> addTags(AddTagsRequest addTagsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AddTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    AddTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AddTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AddTagsRequest, AddTagsResponse>().withOperationName("AddTags")
                            .withMarshaller(new AddTagsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(addTagsRequest));
            CompletableFuture<AddTagsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a package with an Amazon ES domain.
     * </p>
     *
     * @param associatePackageRequest
     *        Container for request parameters to <code> <a>AssociatePackage</a> </code> operation.
     * @return A Java Future containing the result of the AssociatePackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>ConflictException An error occurred because the client attempts to remove a resource that is
     *         currently in use. Returns HTTP status code 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.AssociatePackage
     */
    @Override
    public CompletableFuture<AssociatePackageResponse> associatePackage(AssociatePackageRequest associatePackageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associatePackageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associatePackageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociatePackage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociatePackageResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociatePackageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociatePackageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociatePackageRequest, AssociatePackageResponse>()
                            .withOperationName("AssociatePackage")
                            .withMarshaller(new AssociatePackageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associatePackageRequest));
            CompletableFuture<AssociatePackageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides access to an Amazon OpenSearch Service domain through the use of an interface VPC endpoint.
     * </p>
     *
     * @param authorizeVpcEndpointAccessRequest
     *        Container for request parameters to the <code><a>AuthorizeVpcEndpointAccess</a></code> operation.
     *        Specifies the account to be permitted to manage VPC endpoints against the domain.
     * @return A Java Future containing the result of the AuthorizeVpcEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.AuthorizeVpcEndpointAccess
     */
    @Override
    public CompletableFuture<AuthorizeVpcEndpointAccessResponse> authorizeVpcEndpointAccess(
            AuthorizeVpcEndpointAccessRequest authorizeVpcEndpointAccessRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(authorizeVpcEndpointAccessRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, authorizeVpcEndpointAccessRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AuthorizeVpcEndpointAccess");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AuthorizeVpcEndpointAccessResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AuthorizeVpcEndpointAccessResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AuthorizeVpcEndpointAccessResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AuthorizeVpcEndpointAccessRequest, AuthorizeVpcEndpointAccessResponse>()
                            .withOperationName("AuthorizeVpcEndpointAccess")
                            .withMarshaller(new AuthorizeVpcEndpointAccessRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(authorizeVpcEndpointAccessRequest));
            CompletableFuture<AuthorizeVpcEndpointAccessResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels a scheduled service software update for an Amazon ES domain. You can only perform this operation before
     * the <code>AutomatedUpdateDate</code> and when the <code>UpdateStatus</code> is in the <code>PENDING_UPDATE</code>
     * state.
     * </p>
     *
     * @param cancelElasticsearchServiceSoftwareUpdateRequest
     *        Container for the parameters to the <code><a>CancelElasticsearchServiceSoftwareUpdate</a></code>
     *        operation. Specifies the name of the Elasticsearch domain that you wish to cancel a service software
     *        update on.
     * @return A Java Future containing the result of the CancelElasticsearchServiceSoftwareUpdate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.CancelElasticsearchServiceSoftwareUpdate
     */
    @Override
    public CompletableFuture<CancelElasticsearchServiceSoftwareUpdateResponse> cancelElasticsearchServiceSoftwareUpdate(
            CancelElasticsearchServiceSoftwareUpdateRequest cancelElasticsearchServiceSoftwareUpdateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                cancelElasticsearchServiceSoftwareUpdateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                cancelElasticsearchServiceSoftwareUpdateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelElasticsearchServiceSoftwareUpdate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelElasticsearchServiceSoftwareUpdateResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CancelElasticsearchServiceSoftwareUpdateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CancelElasticsearchServiceSoftwareUpdateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelElasticsearchServiceSoftwareUpdateRequest, CancelElasticsearchServiceSoftwareUpdateResponse>()
                            .withOperationName("CancelElasticsearchServiceSoftwareUpdate")
                            .withMarshaller(new CancelElasticsearchServiceSoftwareUpdateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelElasticsearchServiceSoftwareUpdateRequest));
            CompletableFuture<CancelElasticsearchServiceSoftwareUpdateResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new Elasticsearch domain. For more information, see <a href=
     * "http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomains"
     * target="_blank">Creating Elasticsearch Domains</a> in the <i>Amazon Elasticsearch Service Developer Guide</i>.
     * </p>
     *
     * @param createElasticsearchDomainRequest
     * @return A Java Future containing the result of the CreateElasticsearchDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>InvalidTypeException An exception for trying to create or access sub-resource that is either invalid
     *         or not supported. Gives http status code of 409.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>ResourceAlreadyExistsException An exception for creating a resource that already exists. Gives http
     *         status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.CreateElasticsearchDomain
     */
    @Override
    public CompletableFuture<CreateElasticsearchDomainResponse> createElasticsearchDomain(
            CreateElasticsearchDomainRequest createElasticsearchDomainRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createElasticsearchDomainRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createElasticsearchDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateElasticsearchDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateElasticsearchDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateElasticsearchDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateElasticsearchDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateElasticsearchDomainRequest, CreateElasticsearchDomainResponse>()
                            .withOperationName("CreateElasticsearchDomain")
                            .withMarshaller(new CreateElasticsearchDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createElasticsearchDomainRequest));
            CompletableFuture<CreateElasticsearchDomainResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new cross-cluster search connection from a source domain to a destination domain.
     * </p>
     *
     * @param createOutboundCrossClusterSearchConnectionRequest
     *        Container for the parameters to the <code><a>CreateOutboundCrossClusterSearchConnection</a></code>
     *        operation.
     * @return A Java Future containing the result of the CreateOutboundCrossClusterSearchConnection operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceAlreadyExistsException An exception for creating a resource that already exists. Gives http
     *         status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.CreateOutboundCrossClusterSearchConnection
     */
    @Override
    public CompletableFuture<CreateOutboundCrossClusterSearchConnectionResponse> createOutboundCrossClusterSearchConnection(
            CreateOutboundCrossClusterSearchConnectionRequest createOutboundCrossClusterSearchConnectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                createOutboundCrossClusterSearchConnectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createOutboundCrossClusterSearchConnectionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateOutboundCrossClusterSearchConnection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateOutboundCrossClusterSearchConnectionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateOutboundCrossClusterSearchConnectionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateOutboundCrossClusterSearchConnectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateOutboundCrossClusterSearchConnectionRequest, CreateOutboundCrossClusterSearchConnectionResponse>()
                            .withOperationName("CreateOutboundCrossClusterSearchConnection")
                            .withMarshaller(new CreateOutboundCrossClusterSearchConnectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createOutboundCrossClusterSearchConnectionRequest));
            CompletableFuture<CreateOutboundCrossClusterSearchConnectionResponse> whenCompleted = executeFuture.whenComplete((r,
                    e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Create a package for use with Amazon ES domains.
     * </p>
     *
     * @param createPackageRequest
     *        Container for request parameters to <code> <a>CreatePackage</a> </code> operation.
     * @return A Java Future containing the result of the CreatePackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>InvalidTypeException An exception for trying to create or access sub-resource that is either invalid
     *         or not supported. Gives http status code of 409.</li>
     *         <li>ResourceAlreadyExistsException An exception for creating a resource that already exists. Gives http
     *         status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.CreatePackage
     */
    @Override
    public CompletableFuture<CreatePackageResponse> createPackage(CreatePackageRequest createPackageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPackageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPackageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePackage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreatePackageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreatePackageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreatePackageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreatePackageRequest, CreatePackageResponse>()
                            .withOperationName("CreatePackage")
                            .withMarshaller(new CreatePackageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createPackageRequest));
            CompletableFuture<CreatePackageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Amazon OpenSearch Service-managed VPC endpoint.
     * </p>
     *
     * @param createVpcEndpointRequest
     *        Container for the parameters to the <code><a>CreateVpcEndpointRequest</a></code> operation.
     * @return A Java Future containing the result of the CreateVpcEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException An error occurred because the client attempts to remove a resource that is
     *         currently in use. Returns HTTP status code 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.CreateVpcEndpoint
     */
    @Override
    public CompletableFuture<CreateVpcEndpointResponse> createVpcEndpoint(CreateVpcEndpointRequest createVpcEndpointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVpcEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVpcEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVpcEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateVpcEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateVpcEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateVpcEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateVpcEndpointRequest, CreateVpcEndpointResponse>()
                            .withOperationName("CreateVpcEndpoint")
                            .withMarshaller(new CreateVpcEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createVpcEndpointRequest));
            CompletableFuture<CreateVpcEndpointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Permanently deletes the specified Elasticsearch domain and all of its data. Once a domain is deleted, it cannot
     * be recovered.
     * </p>
     *
     * @param deleteElasticsearchDomainRequest
     *        Container for the parameters to the <code><a>DeleteElasticsearchDomain</a></code> operation. Specifies the
     *        name of the Elasticsearch domain that you want to delete.
     * @return A Java Future containing the result of the DeleteElasticsearchDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DeleteElasticsearchDomain
     */
    @Override
    public CompletableFuture<DeleteElasticsearchDomainResponse> deleteElasticsearchDomain(
            DeleteElasticsearchDomainRequest deleteElasticsearchDomainRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteElasticsearchDomainRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteElasticsearchDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteElasticsearchDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteElasticsearchDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteElasticsearchDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteElasticsearchDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteElasticsearchDomainRequest, DeleteElasticsearchDomainResponse>()
                            .withOperationName("DeleteElasticsearchDomain")
                            .withMarshaller(new DeleteElasticsearchDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteElasticsearchDomainRequest));
            CompletableFuture<DeleteElasticsearchDomainResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the service-linked role that Elasticsearch Service uses to manage and maintain VPC domains. Role deletion
     * will fail if any existing VPC domains use the role. You must delete any such Elasticsearch domains before
     * deleting the role. See <a
     * href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-vpc.html#es-enabling-slr"
     * target="_blank">Deleting Elasticsearch Service Role</a> in <i>VPC Endpoints for Amazon Elasticsearch Service
     * Domains</i>.
     * </p>
     *
     * @param deleteElasticsearchServiceRoleRequest
     * @return A Java Future containing the result of the DeleteElasticsearchServiceRole operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DeleteElasticsearchServiceRole
     */
    @Override
    public CompletableFuture<DeleteElasticsearchServiceRoleResponse> deleteElasticsearchServiceRole(
            DeleteElasticsearchServiceRoleRequest deleteElasticsearchServiceRoleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteElasticsearchServiceRoleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteElasticsearchServiceRoleRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteElasticsearchServiceRole");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteElasticsearchServiceRoleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteElasticsearchServiceRoleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteElasticsearchServiceRoleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteElasticsearchServiceRoleRequest, DeleteElasticsearchServiceRoleResponse>()
                            .withOperationName("DeleteElasticsearchServiceRole")
                            .withMarshaller(new DeleteElasticsearchServiceRoleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteElasticsearchServiceRoleRequest));
            CompletableFuture<DeleteElasticsearchServiceRoleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Allows the destination domain owner to delete an existing inbound cross-cluster search connection.
     * </p>
     *
     * @param deleteInboundCrossClusterSearchConnectionRequest
     *        Container for the parameters to the <code><a>DeleteInboundCrossClusterSearchConnection</a></code>
     *        operation.
     * @return A Java Future containing the result of the DeleteInboundCrossClusterSearchConnection operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DeleteInboundCrossClusterSearchConnection
     */
    @Override
    public CompletableFuture<DeleteInboundCrossClusterSearchConnectionResponse> deleteInboundCrossClusterSearchConnection(
            DeleteInboundCrossClusterSearchConnectionRequest deleteInboundCrossClusterSearchConnectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                deleteInboundCrossClusterSearchConnectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteInboundCrossClusterSearchConnectionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInboundCrossClusterSearchConnection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteInboundCrossClusterSearchConnectionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteInboundCrossClusterSearchConnectionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteInboundCrossClusterSearchConnectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteInboundCrossClusterSearchConnectionRequest, DeleteInboundCrossClusterSearchConnectionResponse>()
                            .withOperationName("DeleteInboundCrossClusterSearchConnection")
                            .withMarshaller(new DeleteInboundCrossClusterSearchConnectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteInboundCrossClusterSearchConnectionRequest));
            CompletableFuture<DeleteInboundCrossClusterSearchConnectionResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Allows the source domain owner to delete an existing outbound cross-cluster search connection.
     * </p>
     *
     * @param deleteOutboundCrossClusterSearchConnectionRequest
     *        Container for the parameters to the <code><a>DeleteOutboundCrossClusterSearchConnection</a></code>
     *        operation.
     * @return A Java Future containing the result of the DeleteOutboundCrossClusterSearchConnection operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DeleteOutboundCrossClusterSearchConnection
     */
    @Override
    public CompletableFuture<DeleteOutboundCrossClusterSearchConnectionResponse> deleteOutboundCrossClusterSearchConnection(
            DeleteOutboundCrossClusterSearchConnectionRequest deleteOutboundCrossClusterSearchConnectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                deleteOutboundCrossClusterSearchConnectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteOutboundCrossClusterSearchConnectionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteOutboundCrossClusterSearchConnection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteOutboundCrossClusterSearchConnectionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteOutboundCrossClusterSearchConnectionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteOutboundCrossClusterSearchConnectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteOutboundCrossClusterSearchConnectionRequest, DeleteOutboundCrossClusterSearchConnectionResponse>()
                            .withOperationName("DeleteOutboundCrossClusterSearchConnection")
                            .withMarshaller(new DeleteOutboundCrossClusterSearchConnectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteOutboundCrossClusterSearchConnectionRequest));
            CompletableFuture<DeleteOutboundCrossClusterSearchConnectionResponse> whenCompleted = executeFuture.whenComplete((r,
                    e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete the package.
     * </p>
     *
     * @param deletePackageRequest
     *        Container for request parameters to <code> <a>DeletePackage</a> </code> operation.
     * @return A Java Future containing the result of the DeletePackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>ConflictException An error occurred because the client attempts to remove a resource that is
     *         currently in use. Returns HTTP status code 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DeletePackage
     */
    @Override
    public CompletableFuture<DeletePackageResponse> deletePackage(DeletePackageRequest deletePackageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deletePackageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePackageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePackage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeletePackageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeletePackageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeletePackageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeletePackageRequest, DeletePackageResponse>()
                            .withOperationName("DeletePackage")
                            .withMarshaller(new DeletePackageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deletePackageRequest));
            CompletableFuture<DeletePackageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an Amazon OpenSearch Service-managed interface VPC endpoint.
     * </p>
     *
     * @param deleteVpcEndpointRequest
     *        Deletes an Amazon OpenSearch Service-managed interface VPC endpoint.
     * @return A Java Future containing the result of the DeleteVpcEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DeleteVpcEndpoint
     */
    @Override
    public CompletableFuture<DeleteVpcEndpointResponse> deleteVpcEndpoint(DeleteVpcEndpointRequest deleteVpcEndpointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteVpcEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVpcEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVpcEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteVpcEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteVpcEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteVpcEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteVpcEndpointRequest, DeleteVpcEndpointResponse>()
                            .withOperationName("DeleteVpcEndpoint")
                            .withMarshaller(new DeleteVpcEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteVpcEndpointRequest));
            CompletableFuture<DeleteVpcEndpointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides scheduled Auto-Tune action details for the Elasticsearch domain, such as Auto-Tune action type,
     * description, severity, and scheduled date.
     * </p>
     *
     * @param describeDomainAutoTunesRequest
     *        Container for the parameters to the <code>DescribeDomainAutoTunes</code> operation.
     * @return A Java Future containing the result of the DescribeDomainAutoTunes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeDomainAutoTunes
     */
    @Override
    public CompletableFuture<DescribeDomainAutoTunesResponse> describeDomainAutoTunes(
            DescribeDomainAutoTunesRequest describeDomainAutoTunesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDomainAutoTunesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDomainAutoTunesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDomainAutoTunes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDomainAutoTunesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDomainAutoTunesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeDomainAutoTunesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDomainAutoTunesRequest, DescribeDomainAutoTunesResponse>()
                            .withOperationName("DescribeDomainAutoTunes")
                            .withMarshaller(new DescribeDomainAutoTunesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDomainAutoTunesRequest));
            CompletableFuture<DescribeDomainAutoTunesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the current blue/green deployment happening on a domain, including a change ID, status,
     * and progress stages.
     * </p>
     *
     * @param describeDomainChangeProgressRequest
     *        Container for the parameters to the <code>DescribeDomainChangeProgress</code> operation. Specifies the
     *        domain name and optional change specific identity for which you want progress information.
     * @return A Java Future containing the result of the DescribeDomainChangeProgress operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeDomainChangeProgress
     */
    @Override
    public CompletableFuture<DescribeDomainChangeProgressResponse> describeDomainChangeProgress(
            DescribeDomainChangeProgressRequest describeDomainChangeProgressRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDomainChangeProgressRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDomainChangeProgressRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDomainChangeProgress");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDomainChangeProgressResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDomainChangeProgressResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeDomainChangeProgressResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDomainChangeProgressRequest, DescribeDomainChangeProgressResponse>()
                            .withOperationName("DescribeDomainChangeProgress")
                            .withMarshaller(new DescribeDomainChangeProgressRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDomainChangeProgressRequest));
            CompletableFuture<DescribeDomainChangeProgressResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns domain configuration information about the specified Elasticsearch domain, including the domain ID,
     * domain endpoint, and domain ARN.
     * </p>
     *
     * @param describeElasticsearchDomainRequest
     *        Container for the parameters to the <code><a>DescribeElasticsearchDomain</a></code> operation.
     * @return A Java Future containing the result of the DescribeElasticsearchDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeElasticsearchDomain
     */
    @Override
    public CompletableFuture<DescribeElasticsearchDomainResponse> describeElasticsearchDomain(
            DescribeElasticsearchDomainRequest describeElasticsearchDomainRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeElasticsearchDomainRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeElasticsearchDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeElasticsearchDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeElasticsearchDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeElasticsearchDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeElasticsearchDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeElasticsearchDomainRequest, DescribeElasticsearchDomainResponse>()
                            .withOperationName("DescribeElasticsearchDomain")
                            .withMarshaller(new DescribeElasticsearchDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeElasticsearchDomainRequest));
            CompletableFuture<DescribeElasticsearchDomainResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides cluster configuration information about the specified Elasticsearch domain, such as the state, creation
     * date, update version, and update date for cluster options.
     * </p>
     *
     * @param describeElasticsearchDomainConfigRequest
     *        Container for the parameters to the <code>DescribeElasticsearchDomainConfig</code> operation. Specifies
     *        the domain name for which you want configuration information.
     * @return A Java Future containing the result of the DescribeElasticsearchDomainConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeElasticsearchDomainConfig
     */
    @Override
    public CompletableFuture<DescribeElasticsearchDomainConfigResponse> describeElasticsearchDomainConfig(
            DescribeElasticsearchDomainConfigRequest describeElasticsearchDomainConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeElasticsearchDomainConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeElasticsearchDomainConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeElasticsearchDomainConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeElasticsearchDomainConfigResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeElasticsearchDomainConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeElasticsearchDomainConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeElasticsearchDomainConfigRequest, DescribeElasticsearchDomainConfigResponse>()
                            .withOperationName("DescribeElasticsearchDomainConfig")
                            .withMarshaller(new DescribeElasticsearchDomainConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeElasticsearchDomainConfigRequest));
            CompletableFuture<DescribeElasticsearchDomainConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns domain configuration information about the specified Elasticsearch domains, including the domain ID,
     * domain endpoint, and domain ARN.
     * </p>
     *
     * @param describeElasticsearchDomainsRequest
     *        Container for the parameters to the <code><a>DescribeElasticsearchDomains</a></code> operation. By
     *        default, the API returns the status of all Elasticsearch domains.
     * @return A Java Future containing the result of the DescribeElasticsearchDomains operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeElasticsearchDomains
     */
    @Override
    public CompletableFuture<DescribeElasticsearchDomainsResponse> describeElasticsearchDomains(
            DescribeElasticsearchDomainsRequest describeElasticsearchDomainsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeElasticsearchDomainsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeElasticsearchDomainsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeElasticsearchDomains");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeElasticsearchDomainsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeElasticsearchDomainsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeElasticsearchDomainsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeElasticsearchDomainsRequest, DescribeElasticsearchDomainsResponse>()
                            .withOperationName("DescribeElasticsearchDomains")
                            .withMarshaller(new DescribeElasticsearchDomainsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeElasticsearchDomainsRequest));
            CompletableFuture<DescribeElasticsearchDomainsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describe Elasticsearch Limits for a given InstanceType and ElasticsearchVersion. When modifying existing Domain,
     * specify the <code> <a>DomainName</a> </code> to know what Limits are supported for modifying.
     * </p>
     *
     * @param describeElasticsearchInstanceTypeLimitsRequest
     *        Container for the parameters to <code> <a>DescribeElasticsearchInstanceTypeLimits</a> </code> operation.
     * @return A Java Future containing the result of the DescribeElasticsearchInstanceTypeLimits operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>InvalidTypeException An exception for trying to create or access sub-resource that is either invalid
     *         or not supported. Gives http status code of 409.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeElasticsearchInstanceTypeLimits
     */
    @Override
    public CompletableFuture<DescribeElasticsearchInstanceTypeLimitsResponse> describeElasticsearchInstanceTypeLimits(
            DescribeElasticsearchInstanceTypeLimitsRequest describeElasticsearchInstanceTypeLimitsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeElasticsearchInstanceTypeLimitsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeElasticsearchInstanceTypeLimitsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeElasticsearchInstanceTypeLimits");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeElasticsearchInstanceTypeLimitsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeElasticsearchInstanceTypeLimitsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeElasticsearchInstanceTypeLimitsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeElasticsearchInstanceTypeLimitsRequest, DescribeElasticsearchInstanceTypeLimitsResponse>()
                            .withOperationName("DescribeElasticsearchInstanceTypeLimits")
                            .withMarshaller(new DescribeElasticsearchInstanceTypeLimitsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeElasticsearchInstanceTypeLimitsRequest));
            CompletableFuture<DescribeElasticsearchInstanceTypeLimitsResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all the inbound cross-cluster search connections for a destination domain.
     * </p>
     *
     * @param describeInboundCrossClusterSearchConnectionsRequest
     *        Container for the parameters to the <code><a>DescribeInboundCrossClusterSearchConnections</a></code>
     *        operation.
     * @return A Java Future containing the result of the DescribeInboundCrossClusterSearchConnections operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidPaginationTokenException The request processing has failed because of invalid pagination token
     *         provided by customer. Returns an HTTP status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeInboundCrossClusterSearchConnections
     */
    @Override
    public CompletableFuture<DescribeInboundCrossClusterSearchConnectionsResponse> describeInboundCrossClusterSearchConnections(
            DescribeInboundCrossClusterSearchConnectionsRequest describeInboundCrossClusterSearchConnectionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                describeInboundCrossClusterSearchConnectionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeInboundCrossClusterSearchConnectionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeInboundCrossClusterSearchConnections");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeInboundCrossClusterSearchConnectionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeInboundCrossClusterSearchConnectionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeInboundCrossClusterSearchConnectionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeInboundCrossClusterSearchConnectionsRequest, DescribeInboundCrossClusterSearchConnectionsResponse>()
                            .withOperationName("DescribeInboundCrossClusterSearchConnections")
                            .withMarshaller(new DescribeInboundCrossClusterSearchConnectionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeInboundCrossClusterSearchConnectionsRequest));
            CompletableFuture<DescribeInboundCrossClusterSearchConnectionsResponse> whenCompleted = executeFuture.whenComplete((
                    r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all the outbound cross-cluster search connections for a source domain.
     * </p>
     *
     * @param describeOutboundCrossClusterSearchConnectionsRequest
     *        Container for the parameters to the <code><a>DescribeOutboundCrossClusterSearchConnections</a></code>
     *        operation.
     * @return A Java Future containing the result of the DescribeOutboundCrossClusterSearchConnections operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidPaginationTokenException The request processing has failed because of invalid pagination token
     *         provided by customer. Returns an HTTP status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeOutboundCrossClusterSearchConnections
     */
    @Override
    public CompletableFuture<DescribeOutboundCrossClusterSearchConnectionsResponse> describeOutboundCrossClusterSearchConnections(
            DescribeOutboundCrossClusterSearchConnectionsRequest describeOutboundCrossClusterSearchConnectionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                describeOutboundCrossClusterSearchConnectionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeOutboundCrossClusterSearchConnectionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeOutboundCrossClusterSearchConnections");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeOutboundCrossClusterSearchConnectionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeOutboundCrossClusterSearchConnectionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeOutboundCrossClusterSearchConnectionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeOutboundCrossClusterSearchConnectionsRequest, DescribeOutboundCrossClusterSearchConnectionsResponse>()
                            .withOperationName("DescribeOutboundCrossClusterSearchConnections")
                            .withMarshaller(new DescribeOutboundCrossClusterSearchConnectionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeOutboundCrossClusterSearchConnectionsRequest));
            CompletableFuture<DescribeOutboundCrossClusterSearchConnectionsResponse> whenCompleted = executeFuture.whenComplete((
                    r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes all packages available to Amazon ES. Includes options for filtering, limiting the number of results,
     * and pagination.
     * </p>
     *
     * @param describePackagesRequest
     *        Container for request parameters to <code> <a>DescribePackage</a> </code> operation.
     * @return A Java Future containing the result of the DescribePackages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribePackages
     */
    @Override
    public CompletableFuture<DescribePackagesResponse> describePackages(DescribePackagesRequest describePackagesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describePackagesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describePackagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePackages");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribePackagesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribePackagesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribePackagesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribePackagesRequest, DescribePackagesResponse>()
                            .withOperationName("DescribePackages")
                            .withMarshaller(new DescribePackagesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describePackagesRequest));
            CompletableFuture<DescribePackagesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists available reserved Elasticsearch instance offerings.
     * </p>
     *
     * @param describeReservedElasticsearchInstanceOfferingsRequest
     *        Container for parameters to <code>DescribeReservedElasticsearchInstanceOfferings</code>
     * @return A Java Future containing the result of the DescribeReservedElasticsearchInstanceOfferings operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeReservedElasticsearchInstanceOfferings
     */
    @Override
    public CompletableFuture<DescribeReservedElasticsearchInstanceOfferingsResponse> describeReservedElasticsearchInstanceOfferings(
            DescribeReservedElasticsearchInstanceOfferingsRequest describeReservedElasticsearchInstanceOfferingsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                describeReservedElasticsearchInstanceOfferingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeReservedElasticsearchInstanceOfferingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReservedElasticsearchInstanceOfferings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeReservedElasticsearchInstanceOfferingsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeReservedElasticsearchInstanceOfferingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeReservedElasticsearchInstanceOfferingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeReservedElasticsearchInstanceOfferingsRequest, DescribeReservedElasticsearchInstanceOfferingsResponse>()
                            .withOperationName("DescribeReservedElasticsearchInstanceOfferings")
                            .withMarshaller(new DescribeReservedElasticsearchInstanceOfferingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeReservedElasticsearchInstanceOfferingsRequest));
            CompletableFuture<DescribeReservedElasticsearchInstanceOfferingsResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about reserved Elasticsearch instances for this account.
     * </p>
     *
     * @param describeReservedElasticsearchInstancesRequest
     *        Container for parameters to <code>DescribeReservedElasticsearchInstances</code>
     * @return A Java Future containing the result of the DescribeReservedElasticsearchInstances operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeReservedElasticsearchInstances
     */
    @Override
    public CompletableFuture<DescribeReservedElasticsearchInstancesResponse> describeReservedElasticsearchInstances(
            DescribeReservedElasticsearchInstancesRequest describeReservedElasticsearchInstancesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeReservedElasticsearchInstancesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeReservedElasticsearchInstancesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReservedElasticsearchInstances");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeReservedElasticsearchInstancesResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeReservedElasticsearchInstancesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeReservedElasticsearchInstancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeReservedElasticsearchInstancesRequest, DescribeReservedElasticsearchInstancesResponse>()
                            .withOperationName("DescribeReservedElasticsearchInstances")
                            .withMarshaller(new DescribeReservedElasticsearchInstancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeReservedElasticsearchInstancesRequest));
            CompletableFuture<DescribeReservedElasticsearchInstancesResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes one or more Amazon OpenSearch Service-managed VPC endpoints.
     * </p>
     *
     * @param describeVpcEndpointsRequest
     *        Container for request parameters to the <code><a>DescribeVpcEndpoints</a></code> operation. Specifies the
     *        list of VPC endpoints to be described.
     * @return A Java Future containing the result of the DescribeVpcEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DescribeVpcEndpoints
     */
    @Override
    public CompletableFuture<DescribeVpcEndpointsResponse> describeVpcEndpoints(
            DescribeVpcEndpointsRequest describeVpcEndpointsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeVpcEndpointsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeVpcEndpointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeVpcEndpoints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeVpcEndpointsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeVpcEndpointsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeVpcEndpointsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeVpcEndpointsRequest, DescribeVpcEndpointsResponse>()
                            .withOperationName("DescribeVpcEndpoints")
                            .withMarshaller(new DescribeVpcEndpointsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeVpcEndpointsRequest));
            CompletableFuture<DescribeVpcEndpointsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Dissociates a package from the Amazon ES domain.
     * </p>
     *
     * @param dissociatePackageRequest
     *        Container for request parameters to <code> <a>DissociatePackage</a> </code> operation.
     * @return A Java Future containing the result of the DissociatePackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>ConflictException An error occurred because the client attempts to remove a resource that is
     *         currently in use. Returns HTTP status code 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.DissociatePackage
     */
    @Override
    public CompletableFuture<DissociatePackageResponse> dissociatePackage(DissociatePackageRequest dissociatePackageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(dissociatePackageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, dissociatePackageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DissociatePackage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DissociatePackageResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DissociatePackageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DissociatePackageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DissociatePackageRequest, DissociatePackageResponse>()
                            .withOperationName("DissociatePackage")
                            .withMarshaller(new DissociatePackageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(dissociatePackageRequest));
            CompletableFuture<DissociatePackageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of upgrade compatible Elastisearch versions. You can optionally pass a
     * <code> <a>DomainName</a> </code> to get all upgrade compatible Elasticsearch versions for that specific domain.
     * </p>
     *
     * @param getCompatibleElasticsearchVersionsRequest
     *        Container for request parameters to <code> <a>GetCompatibleElasticsearchVersions</a> </code> operation.
     * @return A Java Future containing the result of the GetCompatibleElasticsearchVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.GetCompatibleElasticsearchVersions
     */
    @Override
    public CompletableFuture<GetCompatibleElasticsearchVersionsResponse> getCompatibleElasticsearchVersions(
            GetCompatibleElasticsearchVersionsRequest getCompatibleElasticsearchVersionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCompatibleElasticsearchVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getCompatibleElasticsearchVersionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCompatibleElasticsearchVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCompatibleElasticsearchVersionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetCompatibleElasticsearchVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCompatibleElasticsearchVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCompatibleElasticsearchVersionsRequest, GetCompatibleElasticsearchVersionsResponse>()
                            .withOperationName("GetCompatibleElasticsearchVersions")
                            .withMarshaller(new GetCompatibleElasticsearchVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCompatibleElasticsearchVersionsRequest));
            CompletableFuture<GetCompatibleElasticsearchVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of versions of the package, along with their creation time and commit message.
     * </p>
     *
     * @param getPackageVersionHistoryRequest
     *        Container for request parameters to <code> <a>GetPackageVersionHistory</a> </code> operation.
     * @return A Java Future containing the result of the GetPackageVersionHistory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.GetPackageVersionHistory
     */
    @Override
    public CompletableFuture<GetPackageVersionHistoryResponse> getPackageVersionHistory(
            GetPackageVersionHistoryRequest getPackageVersionHistoryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getPackageVersionHistoryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPackageVersionHistoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPackageVersionHistory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetPackageVersionHistoryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetPackageVersionHistoryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetPackageVersionHistoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetPackageVersionHistoryRequest, GetPackageVersionHistoryResponse>()
                            .withOperationName("GetPackageVersionHistory")
                            .withMarshaller(new GetPackageVersionHistoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getPackageVersionHistoryRequest));
            CompletableFuture<GetPackageVersionHistoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the complete history of the last 10 upgrades that were performed on the domain.
     * </p>
     *
     * @param getUpgradeHistoryRequest
     *        Container for request parameters to <code> <a>GetUpgradeHistory</a> </code> operation.
     * @return A Java Future containing the result of the GetUpgradeHistory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.GetUpgradeHistory
     */
    @Override
    public CompletableFuture<GetUpgradeHistoryResponse> getUpgradeHistory(GetUpgradeHistoryRequest getUpgradeHistoryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getUpgradeHistoryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUpgradeHistoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUpgradeHistory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetUpgradeHistoryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetUpgradeHistoryResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetUpgradeHistoryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetUpgradeHistoryRequest, GetUpgradeHistoryResponse>()
                            .withOperationName("GetUpgradeHistory")
                            .withMarshaller(new GetUpgradeHistoryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getUpgradeHistoryRequest));
            CompletableFuture<GetUpgradeHistoryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the latest status of the last upgrade or upgrade eligibility check that was performed on the domain.
     * </p>
     *
     * @param getUpgradeStatusRequest
     *        Container for request parameters to <code> <a>GetUpgradeStatus</a> </code> operation.
     * @return A Java Future containing the result of the GetUpgradeStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.GetUpgradeStatus
     */
    @Override
    public CompletableFuture<GetUpgradeStatusResponse> getUpgradeStatus(GetUpgradeStatusRequest getUpgradeStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getUpgradeStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUpgradeStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUpgradeStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetUpgradeStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetUpgradeStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetUpgradeStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetUpgradeStatusRequest, GetUpgradeStatusResponse>()
                            .withOperationName("GetUpgradeStatus")
                            .withMarshaller(new GetUpgradeStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getUpgradeStatusRequest));
            CompletableFuture<GetUpgradeStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the name of all Elasticsearch domains owned by the current user's account.
     * </p>
     *
     * @param listDomainNamesRequest
     *        Container for the parameters to the <code><a>ListDomainNames</a></code> operation.
     * @return A Java Future containing the result of the ListDomainNames operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.ListDomainNames
     */
    @Override
    public CompletableFuture<ListDomainNamesResponse> listDomainNames(ListDomainNamesRequest listDomainNamesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDomainNamesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDomainNamesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDomainNames");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDomainNamesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDomainNamesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDomainNamesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDomainNamesRequest, ListDomainNamesResponse>()
                            .withOperationName("ListDomainNames")
                            .withMarshaller(new ListDomainNamesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDomainNamesRequest));
            CompletableFuture<ListDomainNamesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all Amazon ES domains associated with the package.
     * </p>
     *
     * @param listDomainsForPackageRequest
     *        Container for request parameters to <code> <a>ListDomainsForPackage</a> </code> operation.
     * @return A Java Future containing the result of the ListDomainsForPackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.ListDomainsForPackage
     */
    @Override
    public CompletableFuture<ListDomainsForPackageResponse> listDomainsForPackage(
            ListDomainsForPackageRequest listDomainsForPackageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDomainsForPackageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDomainsForPackageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDomainsForPackage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDomainsForPackageResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDomainsForPackageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDomainsForPackageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDomainsForPackageRequest, ListDomainsForPackageResponse>()
                            .withOperationName("ListDomainsForPackage")
                            .withMarshaller(new ListDomainsForPackageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDomainsForPackageRequest));
            CompletableFuture<ListDomainsForPackageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List all Elasticsearch instance types that are supported for given ElasticsearchVersion
     * </p>
     *
     * @param listElasticsearchInstanceTypesRequest
     *        Container for the parameters to the <code> <a>ListElasticsearchInstanceTypes</a> </code> operation.
     * @return A Java Future containing the result of the ListElasticsearchInstanceTypes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.ListElasticsearchInstanceTypes
     */
    @Override
    public CompletableFuture<ListElasticsearchInstanceTypesResponse> listElasticsearchInstanceTypes(
            ListElasticsearchInstanceTypesRequest listElasticsearchInstanceTypesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listElasticsearchInstanceTypesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listElasticsearchInstanceTypesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListElasticsearchInstanceTypes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListElasticsearchInstanceTypesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListElasticsearchInstanceTypesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListElasticsearchInstanceTypesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListElasticsearchInstanceTypesRequest, ListElasticsearchInstanceTypesResponse>()
                            .withOperationName("ListElasticsearchInstanceTypes")
                            .withMarshaller(new ListElasticsearchInstanceTypesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listElasticsearchInstanceTypesRequest));
            CompletableFuture<ListElasticsearchInstanceTypesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List all supported Elasticsearch versions
     * </p>
     *
     * @param listElasticsearchVersionsRequest
     *        Container for the parameters to the <code> <a>ListElasticsearchVersions</a> </code> operation.
     *        <p>
     *        Use <code> <a>MaxResults</a> </code> to control the maximum number of results to retrieve in a single
     *        call.
     *        </p>
     *        <p>
     *        Use <code> <a>NextToken</a> </code> in response to retrieve more results. If the received response does
     *        not contain a NextToken, then there are no more results to retrieve.
     *        </p>
     * @return A Java Future containing the result of the ListElasticsearchVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.ListElasticsearchVersions
     */
    @Override
    public CompletableFuture<ListElasticsearchVersionsResponse> listElasticsearchVersions(
            ListElasticsearchVersionsRequest listElasticsearchVersionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listElasticsearchVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listElasticsearchVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListElasticsearchVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListElasticsearchVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListElasticsearchVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListElasticsearchVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListElasticsearchVersionsRequest, ListElasticsearchVersionsResponse>()
                            .withOperationName("ListElasticsearchVersions")
                            .withMarshaller(new ListElasticsearchVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listElasticsearchVersionsRequest));
            CompletableFuture<ListElasticsearchVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all packages associated with the Amazon ES domain.
     * </p>
     *
     * @param listPackagesForDomainRequest
     *        Container for request parameters to <code> <a>ListPackagesForDomain</a> </code> operation.
     * @return A Java Future containing the result of the ListPackagesForDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.ListPackagesForDomain
     */
    @Override
    public CompletableFuture<ListPackagesForDomainResponse> listPackagesForDomain(
            ListPackagesForDomainRequest listPackagesForDomainRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listPackagesForDomainRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPackagesForDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPackagesForDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListPackagesForDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListPackagesForDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListPackagesForDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListPackagesForDomainRequest, ListPackagesForDomainResponse>()
                            .withOperationName("ListPackagesForDomain")
                            .withMarshaller(new ListPackagesForDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listPackagesForDomainRequest));
            CompletableFuture<ListPackagesForDomainResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns all tags for the given Elasticsearch domain.
     * </p>
     *
     * @param listTagsRequest
     *        Container for the parameters to the <code><a>ListTags</a></code> operation. Specify the <code>ARN</code>
     *        for the Elasticsearch domain to which the tags are attached that you want to view are attached.
     * @return A Java Future containing the result of the ListTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.ListTags
     */
    @Override
    public CompletableFuture<ListTagsResponse> listTags(ListTagsRequest listTagsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsRequest, ListTagsResponse>().withOperationName("ListTags")
                            .withMarshaller(new ListTagsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(listTagsRequest));
            CompletableFuture<ListTagsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about each principal that is allowed to access a given Amazon OpenSearch Service domain
     * through the use of an interface VPC endpoint.
     * </p>
     *
     * @param listVpcEndpointAccessRequest
     *        Retrieves information about each principal that is allowed to access a given Amazon OpenSearch Service
     *        domain through the use of an interface VPC endpoint
     * @return A Java Future containing the result of the ListVpcEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.ListVpcEndpointAccess
     */
    @Override
    public CompletableFuture<ListVpcEndpointAccessResponse> listVpcEndpointAccess(
            ListVpcEndpointAccessRequest listVpcEndpointAccessRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listVpcEndpointAccessRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listVpcEndpointAccessRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListVpcEndpointAccess");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListVpcEndpointAccessResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListVpcEndpointAccessResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListVpcEndpointAccessResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListVpcEndpointAccessRequest, ListVpcEndpointAccessResponse>()
                            .withOperationName("ListVpcEndpointAccess")
                            .withMarshaller(new ListVpcEndpointAccessRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listVpcEndpointAccessRequest));
            CompletableFuture<ListVpcEndpointAccessResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves all Amazon OpenSearch Service-managed VPC endpoints in the current account and Region.
     * </p>
     *
     * @param listVpcEndpointsRequest
     *        Container for request parameters to the <code><a>ListVpcEndpoints</a></code> operation.
     * @return A Java Future containing the result of the ListVpcEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.ListVpcEndpoints
     */
    @Override
    public CompletableFuture<ListVpcEndpointsResponse> listVpcEndpoints(ListVpcEndpointsRequest listVpcEndpointsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listVpcEndpointsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listVpcEndpointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListVpcEndpoints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListVpcEndpointsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListVpcEndpointsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListVpcEndpointsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListVpcEndpointsRequest, ListVpcEndpointsResponse>()
                            .withOperationName("ListVpcEndpoints")
                            .withMarshaller(new ListVpcEndpointsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listVpcEndpointsRequest));
            CompletableFuture<ListVpcEndpointsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves all Amazon OpenSearch Service-managed VPC endpoints associated with a particular domain.
     * </p>
     *
     * @param listVpcEndpointsForDomainRequest
     *        Container for request parameters to the <code><a>ListVpcEndpointsForDomain</a></code> operation. Specifies
     *        the domain whose VPC endpoints will be listed.
     * @return A Java Future containing the result of the ListVpcEndpointsForDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.ListVpcEndpointsForDomain
     */
    @Override
    public CompletableFuture<ListVpcEndpointsForDomainResponse> listVpcEndpointsForDomain(
            ListVpcEndpointsForDomainRequest listVpcEndpointsForDomainRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listVpcEndpointsForDomainRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listVpcEndpointsForDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListVpcEndpointsForDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListVpcEndpointsForDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListVpcEndpointsForDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListVpcEndpointsForDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListVpcEndpointsForDomainRequest, ListVpcEndpointsForDomainResponse>()
                            .withOperationName("ListVpcEndpointsForDomain")
                            .withMarshaller(new ListVpcEndpointsForDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listVpcEndpointsForDomainRequest));
            CompletableFuture<ListVpcEndpointsForDomainResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Allows you to purchase reserved Elasticsearch instances.
     * </p>
     *
     * @param purchaseReservedElasticsearchInstanceOfferingRequest
     *        Container for parameters to <code>PurchaseReservedElasticsearchInstanceOffering</code>
     * @return A Java Future containing the result of the PurchaseReservedElasticsearchInstanceOffering operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ResourceAlreadyExistsException An exception for creating a resource that already exists. Gives http
     *         status code of 400.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.PurchaseReservedElasticsearchInstanceOffering
     */
    @Override
    public CompletableFuture<PurchaseReservedElasticsearchInstanceOfferingResponse> purchaseReservedElasticsearchInstanceOffering(
            PurchaseReservedElasticsearchInstanceOfferingRequest purchaseReservedElasticsearchInstanceOfferingRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                purchaseReservedElasticsearchInstanceOfferingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                purchaseReservedElasticsearchInstanceOfferingRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PurchaseReservedElasticsearchInstanceOffering");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PurchaseReservedElasticsearchInstanceOfferingResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, PurchaseReservedElasticsearchInstanceOfferingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PurchaseReservedElasticsearchInstanceOfferingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PurchaseReservedElasticsearchInstanceOfferingRequest, PurchaseReservedElasticsearchInstanceOfferingResponse>()
                            .withOperationName("PurchaseReservedElasticsearchInstanceOffering")
                            .withMarshaller(new PurchaseReservedElasticsearchInstanceOfferingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(purchaseReservedElasticsearchInstanceOfferingRequest));
            CompletableFuture<PurchaseReservedElasticsearchInstanceOfferingResponse> whenCompleted = executeFuture.whenComplete((
                    r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Allows the destination domain owner to reject an inbound cross-cluster search connection request.
     * </p>
     *
     * @param rejectInboundCrossClusterSearchConnectionRequest
     *        Container for the parameters to the <code><a>RejectInboundCrossClusterSearchConnection</a></code>
     *        operation.
     * @return A Java Future containing the result of the RejectInboundCrossClusterSearchConnection operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.RejectInboundCrossClusterSearchConnection
     */
    @Override
    public CompletableFuture<RejectInboundCrossClusterSearchConnectionResponse> rejectInboundCrossClusterSearchConnection(
            RejectInboundCrossClusterSearchConnectionRequest rejectInboundCrossClusterSearchConnectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                rejectInboundCrossClusterSearchConnectionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                rejectInboundCrossClusterSearchConnectionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RejectInboundCrossClusterSearchConnection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RejectInboundCrossClusterSearchConnectionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, RejectInboundCrossClusterSearchConnectionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RejectInboundCrossClusterSearchConnectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RejectInboundCrossClusterSearchConnectionRequest, RejectInboundCrossClusterSearchConnectionResponse>()
                            .withOperationName("RejectInboundCrossClusterSearchConnection")
                            .withMarshaller(new RejectInboundCrossClusterSearchConnectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(rejectInboundCrossClusterSearchConnectionRequest));
            CompletableFuture<RejectInboundCrossClusterSearchConnectionResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes the specified set of tags from the specified Elasticsearch domain.
     * </p>
     *
     * @param removeTagsRequest
     *        Container for the parameters to the <code><a>RemoveTags</a></code> operation. Specify the <code>ARN</code>
     *        for the Elasticsearch domain from which you want to remove the specified <code>TagKey</code>.
     * @return A Java Future containing the result of the RemoveTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.RemoveTags
     */
    @Override
    public CompletableFuture<RemoveTagsResponse> removeTags(RemoveTagsRequest removeTagsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RemoveTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    RemoveTagsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RemoveTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RemoveTagsRequest, RemoveTagsResponse>().withOperationName("RemoveTags")
                            .withMarshaller(new RemoveTagsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(removeTagsRequest));
            CompletableFuture<RemoveTagsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Revokes access to an Amazon OpenSearch Service domain that was provided through an interface VPC endpoint.
     * </p>
     *
     * @param revokeVpcEndpointAccessRequest
     *        Revokes access to an Amazon OpenSearch Service domain that was provided through an interface VPC endpoint.
     * @return A Java Future containing the result of the RevokeVpcEndpointAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.RevokeVpcEndpointAccess
     */
    @Override
    public CompletableFuture<RevokeVpcEndpointAccessResponse> revokeVpcEndpointAccess(
            RevokeVpcEndpointAccessRequest revokeVpcEndpointAccessRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(revokeVpcEndpointAccessRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, revokeVpcEndpointAccessRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RevokeVpcEndpointAccess");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RevokeVpcEndpointAccessResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RevokeVpcEndpointAccessResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RevokeVpcEndpointAccessResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RevokeVpcEndpointAccessRequest, RevokeVpcEndpointAccessResponse>()
                            .withOperationName("RevokeVpcEndpointAccess")
                            .withMarshaller(new RevokeVpcEndpointAccessRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(revokeVpcEndpointAccessRequest));
            CompletableFuture<RevokeVpcEndpointAccessResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Schedules a service software update for an Amazon ES domain.
     * </p>
     *
     * @param startElasticsearchServiceSoftwareUpdateRequest
     *        Container for the parameters to the <code><a>StartElasticsearchServiceSoftwareUpdate</a></code> operation.
     *        Specifies the name of the Elasticsearch domain that you wish to schedule a service software update on.
     * @return A Java Future containing the result of the StartElasticsearchServiceSoftwareUpdate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.StartElasticsearchServiceSoftwareUpdate
     */
    @Override
    public CompletableFuture<StartElasticsearchServiceSoftwareUpdateResponse> startElasticsearchServiceSoftwareUpdate(
            StartElasticsearchServiceSoftwareUpdateRequest startElasticsearchServiceSoftwareUpdateRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startElasticsearchServiceSoftwareUpdateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                startElasticsearchServiceSoftwareUpdateRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartElasticsearchServiceSoftwareUpdate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartElasticsearchServiceSoftwareUpdateResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, StartElasticsearchServiceSoftwareUpdateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartElasticsearchServiceSoftwareUpdateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartElasticsearchServiceSoftwareUpdateRequest, StartElasticsearchServiceSoftwareUpdateResponse>()
                            .withOperationName("StartElasticsearchServiceSoftwareUpdate")
                            .withMarshaller(new StartElasticsearchServiceSoftwareUpdateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startElasticsearchServiceSoftwareUpdateRequest));
            CompletableFuture<StartElasticsearchServiceSoftwareUpdateResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies the cluster configuration of the specified Elasticsearch domain, setting as setting the instance type
     * and the number of instances.
     * </p>
     *
     * @param updateElasticsearchDomainConfigRequest
     *        Container for the parameters to the <code><a>UpdateElasticsearchDomain</a></code> operation. Specifies the
     *        type and number of instances in the domain cluster.
     * @return A Java Future containing the result of the UpdateElasticsearchDomainConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>InvalidTypeException An exception for trying to create or access sub-resource that is either invalid
     *         or not supported. Gives http status code of 409.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.UpdateElasticsearchDomainConfig
     */
    @Override
    public CompletableFuture<UpdateElasticsearchDomainConfigResponse> updateElasticsearchDomainConfig(
            UpdateElasticsearchDomainConfigRequest updateElasticsearchDomainConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateElasticsearchDomainConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateElasticsearchDomainConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateElasticsearchDomainConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateElasticsearchDomainConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateElasticsearchDomainConfigResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateElasticsearchDomainConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateElasticsearchDomainConfigRequest, UpdateElasticsearchDomainConfigResponse>()
                            .withOperationName("UpdateElasticsearchDomainConfig")
                            .withMarshaller(new UpdateElasticsearchDomainConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateElasticsearchDomainConfigRequest));
            CompletableFuture<UpdateElasticsearchDomainConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a package for use with Amazon ES domains.
     * </p>
     *
     * @param updatePackageRequest
     *        Container for request parameters to <code> <a>UpdatePackage</a> </code> operation.
     * @return A Java Future containing the result of the UpdatePackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>LimitExceededException An exception for trying to create more than allowed resources or
     *         sub-resources. Gives http status code of 409.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>AccessDeniedException An error occurred because user does not have permissions to access the
     *         resource. Returns HTTP status code 403.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.UpdatePackage
     */
    @Override
    public CompletableFuture<UpdatePackageResponse> updatePackage(UpdatePackageRequest updatePackageRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updatePackageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePackageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePackage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdatePackageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdatePackageResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdatePackageResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdatePackageRequest, UpdatePackageResponse>()
                            .withOperationName("UpdatePackage")
                            .withMarshaller(new UpdatePackageRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updatePackageRequest));
            CompletableFuture<UpdatePackageResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies an Amazon OpenSearch Service-managed interface VPC endpoint.
     * </p>
     *
     * @param updateVpcEndpointRequest
     *        Modifies an Amazon OpenSearch Service-managed interface VPC endpoint.
     * @return A Java Future containing the result of the UpdateVpcEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>ConflictException An error occurred because the client attempts to remove a resource that is
     *         currently in use. Returns HTTP status code 409.</li>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.UpdateVpcEndpoint
     */
    @Override
    public CompletableFuture<UpdateVpcEndpointResponse> updateVpcEndpoint(UpdateVpcEndpointRequest updateVpcEndpointRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateVpcEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateVpcEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateVpcEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateVpcEndpointResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateVpcEndpointResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateVpcEndpointResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateVpcEndpointRequest, UpdateVpcEndpointResponse>()
                            .withOperationName("UpdateVpcEndpoint")
                            .withMarshaller(new UpdateVpcEndpointRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateVpcEndpointRequest));
            CompletableFuture<UpdateVpcEndpointResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Allows you to either upgrade your domain or perform an Upgrade eligibility check to a compatible Elasticsearch
     * version.
     * </p>
     *
     * @param upgradeElasticsearchDomainRequest
     *        Container for request parameters to <code> <a>UpgradeElasticsearchDomain</a> </code> operation.
     * @return A Java Future containing the result of the UpgradeElasticsearchDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>ResourceNotFoundException An exception for accessing or deleting a resource that does not exist.
     *         Gives http status code of 400.</li>
     *         <li>ResourceAlreadyExistsException An exception for creating a resource that already exists. Gives http
     *         status code of 400.</li>
     *         <li>DisabledOperationException An error occured because the client wanted to access a not supported
     *         operation. Gives http status code of 409.</li>
     *         <li>ValidationException An exception for missing / invalid input fields. Gives http status code of 400.</li>
     *         <li>InternalException The request processing has failed because of an unknown error, exception or failure
     *         (the failure is internal to the service) . Gives http status code of 500.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ElasticsearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ElasticsearchAsyncClient.UpgradeElasticsearchDomain
     */
    @Override
    public CompletableFuture<UpgradeElasticsearchDomainResponse> upgradeElasticsearchDomain(
            UpgradeElasticsearchDomainRequest upgradeElasticsearchDomainRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(upgradeElasticsearchDomainRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, upgradeElasticsearchDomainRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elasticsearch Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpgradeElasticsearchDomain");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpgradeElasticsearchDomainResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpgradeElasticsearchDomainResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpgradeElasticsearchDomainResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpgradeElasticsearchDomainRequest, UpgradeElasticsearchDomainResponse>()
                            .withOperationName("UpgradeElasticsearchDomain")
                            .withMarshaller(new UpgradeElasticsearchDomainRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(upgradeElasticsearchDomainRequest));
            CompletableFuture<UpgradeElasticsearchDomainResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final ElasticsearchServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(ElasticsearchException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DisabledOperationException")
                                .exceptionBuilderSupplier(DisabledOperationException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTypeException")
                                .exceptionBuilderSupplier(InvalidTypeException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                                .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalException")
                                .exceptionBuilderSupplier(InternalException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidPaginationTokenException")
                                .exceptionBuilderSupplier(InvalidPaginationTokenException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder)
                                .build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        ElasticsearchServiceClientConfigurationBuilder.BuilderInternal serviceConfigBuilder = ElasticsearchServiceClientConfigurationBuilder
                .builder(clientConfiguration.toBuilder());
        serviceConfigBuilder.overrideConfiguration(serviceClientConfiguration.overrideConfiguration());
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        return serviceConfigBuilder.buildSdkClientConfiguration();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
