/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the percentage of requests over the last 10 seconds that resulted in each type of status code response.
 * For more information, see <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html">Status Code
 * Definitions</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StatusCodes implements SdkPojo, Serializable, ToCopyableBuilder<StatusCodes.Builder, StatusCodes> {
    private static final SdkField<Integer> STATUS2_XX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status2xx").getter(getter(StatusCodes::status2xx)).setter(setter(Builder::status2xx))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status2xx").build()).build();

    private static final SdkField<Integer> STATUS3_XX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status3xx").getter(getter(StatusCodes::status3xx)).setter(setter(Builder::status3xx))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status3xx").build()).build();

    private static final SdkField<Integer> STATUS4_XX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status4xx").getter(getter(StatusCodes::status4xx)).setter(setter(Builder::status4xx))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status4xx").build()).build();

    private static final SdkField<Integer> STATUS5_XX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status5xx").getter(getter(StatusCodes::status5xx)).setter(setter(Builder::status5xx))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status5xx").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS2_XX_FIELD,
            STATUS3_XX_FIELD, STATUS4_XX_FIELD, STATUS5_XX_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer status2xx;

    private final Integer status3xx;

    private final Integer status4xx;

    private final Integer status5xx;

    private StatusCodes(BuilderImpl builder) {
        this.status2xx = builder.status2xx;
        this.status3xx = builder.status3xx;
        this.status4xx = builder.status4xx;
        this.status5xx = builder.status5xx;
    }

    /**
     * <p>
     * The percentage of requests over the last 10 seconds that resulted in a 2xx (200, 201, etc.) status code.
     * </p>
     * 
     * @return The percentage of requests over the last 10 seconds that resulted in a 2xx (200, 201, etc.) status code.
     */
    public final Integer status2xx() {
        return status2xx;
    }

    /**
     * <p>
     * The percentage of requests over the last 10 seconds that resulted in a 3xx (300, 301, etc.) status code.
     * </p>
     * 
     * @return The percentage of requests over the last 10 seconds that resulted in a 3xx (300, 301, etc.) status code.
     */
    public final Integer status3xx() {
        return status3xx;
    }

    /**
     * <p>
     * The percentage of requests over the last 10 seconds that resulted in a 4xx (400, 401, etc.) status code.
     * </p>
     * 
     * @return The percentage of requests over the last 10 seconds that resulted in a 4xx (400, 401, etc.) status code.
     */
    public final Integer status4xx() {
        return status4xx;
    }

    /**
     * <p>
     * The percentage of requests over the last 10 seconds that resulted in a 5xx (500, 501, etc.) status code.
     * </p>
     * 
     * @return The percentage of requests over the last 10 seconds that resulted in a 5xx (500, 501, etc.) status code.
     */
    public final Integer status5xx() {
        return status5xx;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(status2xx());
        hashCode = 31 * hashCode + Objects.hashCode(status3xx());
        hashCode = 31 * hashCode + Objects.hashCode(status4xx());
        hashCode = 31 * hashCode + Objects.hashCode(status5xx());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatusCodes)) {
            return false;
        }
        StatusCodes other = (StatusCodes) obj;
        return Objects.equals(status2xx(), other.status2xx()) && Objects.equals(status3xx(), other.status3xx())
                && Objects.equals(status4xx(), other.status4xx()) && Objects.equals(status5xx(), other.status5xx());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StatusCodes").add("Status2xx", status2xx()).add("Status3xx", status3xx())
                .add("Status4xx", status4xx()).add("Status5xx", status5xx()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status2xx":
            return Optional.ofNullable(clazz.cast(status2xx()));
        case "Status3xx":
            return Optional.ofNullable(clazz.cast(status3xx()));
        case "Status4xx":
            return Optional.ofNullable(clazz.cast(status4xx()));
        case "Status5xx":
            return Optional.ofNullable(clazz.cast(status5xx()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StatusCodes, T> g) {
        return obj -> g.apply((StatusCodes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StatusCodes> {
        /**
         * <p>
         * The percentage of requests over the last 10 seconds that resulted in a 2xx (200, 201, etc.) status code.
         * </p>
         * 
         * @param status2xx
         *        The percentage of requests over the last 10 seconds that resulted in a 2xx (200, 201, etc.) status
         *        code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status2xx(Integer status2xx);

        /**
         * <p>
         * The percentage of requests over the last 10 seconds that resulted in a 3xx (300, 301, etc.) status code.
         * </p>
         * 
         * @param status3xx
         *        The percentage of requests over the last 10 seconds that resulted in a 3xx (300, 301, etc.) status
         *        code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status3xx(Integer status3xx);

        /**
         * <p>
         * The percentage of requests over the last 10 seconds that resulted in a 4xx (400, 401, etc.) status code.
         * </p>
         * 
         * @param status4xx
         *        The percentage of requests over the last 10 seconds that resulted in a 4xx (400, 401, etc.) status
         *        code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status4xx(Integer status4xx);

        /**
         * <p>
         * The percentage of requests over the last 10 seconds that resulted in a 5xx (500, 501, etc.) status code.
         * </p>
         * 
         * @param status5xx
         *        The percentage of requests over the last 10 seconds that resulted in a 5xx (500, 501, etc.) status
         *        code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status5xx(Integer status5xx);
    }

    static final class BuilderImpl implements Builder {
        private Integer status2xx;

        private Integer status3xx;

        private Integer status4xx;

        private Integer status5xx;

        private BuilderImpl() {
        }

        private BuilderImpl(StatusCodes model) {
            status2xx(model.status2xx);
            status3xx(model.status3xx);
            status4xx(model.status4xx);
            status5xx(model.status5xx);
        }

        public final Integer getStatus2xx() {
            return status2xx;
        }

        public final void setStatus2xx(Integer status2xx) {
            this.status2xx = status2xx;
        }

        @Override
        public final Builder status2xx(Integer status2xx) {
            this.status2xx = status2xx;
            return this;
        }

        public final Integer getStatus3xx() {
            return status3xx;
        }

        public final void setStatus3xx(Integer status3xx) {
            this.status3xx = status3xx;
        }

        @Override
        public final Builder status3xx(Integer status3xx) {
            this.status3xx = status3xx;
            return this;
        }

        public final Integer getStatus4xx() {
            return status4xx;
        }

        public final void setStatus4xx(Integer status4xx) {
            this.status4xx = status4xx;
        }

        @Override
        public final Builder status4xx(Integer status4xx) {
            this.status4xx = status4xx;
            return this;
        }

        public final Integer getStatus5xx() {
            return status5xx;
        }

        public final void setStatus5xx(Integer status5xx) {
            this.status5xx = status5xx;
        }

        @Override
        public final Builder status5xx(Integer status5xx) {
            this.status5xx = status5xx;
            return this;
        }

        @Override
        public StatusCodes build() {
            return new StatusCodes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
