/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about a platform branch.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PlatformBranchSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<PlatformBranchSummary.Builder, PlatformBranchSummary> {
    private static final SdkField<String> PLATFORM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlatformName").getter(getter(PlatformBranchSummary::platformName)).setter(setter(Builder::platformName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformName").build()).build();

    private static final SdkField<String> BRANCH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BranchName").getter(getter(PlatformBranchSummary::branchName)).setter(setter(Builder::branchName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BranchName").build()).build();

    private static final SdkField<String> LIFECYCLE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LifecycleState").getter(getter(PlatformBranchSummary::lifecycleState))
            .setter(setter(Builder::lifecycleState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleState").build()).build();

    private static final SdkField<Integer> BRANCH_ORDER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BranchOrder").getter(getter(PlatformBranchSummary::branchOrder)).setter(setter(Builder::branchOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BranchOrder").build()).build();

    private static final SdkField<List<String>> SUPPORTED_TIER_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedTierList")
            .getter(getter(PlatformBranchSummary::supportedTierList))
            .setter(setter(Builder::supportedTierList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedTierList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLATFORM_NAME_FIELD,
            BRANCH_NAME_FIELD, LIFECYCLE_STATE_FIELD, BRANCH_ORDER_FIELD, SUPPORTED_TIER_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String platformName;

    private final String branchName;

    private final String lifecycleState;

    private final Integer branchOrder;

    private final List<String> supportedTierList;

    private PlatformBranchSummary(BuilderImpl builder) {
        this.platformName = builder.platformName;
        this.branchName = builder.branchName;
        this.lifecycleState = builder.lifecycleState;
        this.branchOrder = builder.branchOrder;
        this.supportedTierList = builder.supportedTierList;
    }

    /**
     * <p>
     * The name of the platform to which this platform branch belongs.
     * </p>
     * 
     * @return The name of the platform to which this platform branch belongs.
     */
    public final String platformName() {
        return platformName;
    }

    /**
     * <p>
     * The name of the platform branch.
     * </p>
     * 
     * @return The name of the platform branch.
     */
    public final String branchName() {
        return branchName;
    }

    /**
     * <p>
     * The support life cycle state of the platform branch.
     * </p>
     * <p>
     * Possible values: <code>beta</code> | <code>supported</code> | <code>deprecated</code> | <code>retired</code>
     * </p>
     * 
     * @return The support life cycle state of the platform branch.</p>
     *         <p>
     *         Possible values: <code>beta</code> | <code>supported</code> | <code>deprecated</code> |
     *         <code>retired</code>
     */
    public final String lifecycleState() {
        return lifecycleState;
    }

    /**
     * <p>
     * An ordinal number that designates the order in which platform branches have been added to a platform. This can be
     * helpful, for example, if your code calls the <code>ListPlatformBranches</code> action and then displays a list of
     * platform branches.
     * </p>
     * <p>
     * A larger <code>BranchOrder</code> value designates a newer platform branch within the platform.
     * </p>
     * 
     * @return An ordinal number that designates the order in which platform branches have been added to a platform.
     *         This can be helpful, for example, if your code calls the <code>ListPlatformBranches</code> action and
     *         then displays a list of platform branches.</p>
     *         <p>
     *         A larger <code>BranchOrder</code> value designates a newer platform branch within the platform.
     */
    public final Integer branchOrder() {
        return branchOrder;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedTierList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSupportedTierList() {
        return supportedTierList != null && !(supportedTierList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The environment tiers that platform versions in this branch support.
     * </p>
     * <p>
     * Possible values: <code>WebServer/Standard</code> | <code>Worker/SQS/HTTP</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedTierList} method.
     * </p>
     * 
     * @return The environment tiers that platform versions in this branch support.</p>
     *         <p>
     *         Possible values: <code>WebServer/Standard</code> | <code>Worker/SQS/HTTP</code>
     */
    public final List<String> supportedTierList() {
        return supportedTierList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(platformName());
        hashCode = 31 * hashCode + Objects.hashCode(branchName());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleState());
        hashCode = 31 * hashCode + Objects.hashCode(branchOrder());
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedTierList() ? supportedTierList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlatformBranchSummary)) {
            return false;
        }
        PlatformBranchSummary other = (PlatformBranchSummary) obj;
        return Objects.equals(platformName(), other.platformName()) && Objects.equals(branchName(), other.branchName())
                && Objects.equals(lifecycleState(), other.lifecycleState()) && Objects.equals(branchOrder(), other.branchOrder())
                && hasSupportedTierList() == other.hasSupportedTierList()
                && Objects.equals(supportedTierList(), other.supportedTierList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PlatformBranchSummary").add("PlatformName", platformName()).add("BranchName", branchName())
                .add("LifecycleState", lifecycleState()).add("BranchOrder", branchOrder())
                .add("SupportedTierList", hasSupportedTierList() ? supportedTierList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PlatformName":
            return Optional.ofNullable(clazz.cast(platformName()));
        case "BranchName":
            return Optional.ofNullable(clazz.cast(branchName()));
        case "LifecycleState":
            return Optional.ofNullable(clazz.cast(lifecycleState()));
        case "BranchOrder":
            return Optional.ofNullable(clazz.cast(branchOrder()));
        case "SupportedTierList":
            return Optional.ofNullable(clazz.cast(supportedTierList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PlatformBranchSummary, T> g) {
        return obj -> g.apply((PlatformBranchSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PlatformBranchSummary> {
        /**
         * <p>
         * The name of the platform to which this platform branch belongs.
         * </p>
         * 
         * @param platformName
         *        The name of the platform to which this platform branch belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformName(String platformName);

        /**
         * <p>
         * The name of the platform branch.
         * </p>
         * 
         * @param branchName
         *        The name of the platform branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branchName(String branchName);

        /**
         * <p>
         * The support life cycle state of the platform branch.
         * </p>
         * <p>
         * Possible values: <code>beta</code> | <code>supported</code> | <code>deprecated</code> | <code>retired</code>
         * </p>
         * 
         * @param lifecycleState
         *        The support life cycle state of the platform branch.</p>
         *        <p>
         *        Possible values: <code>beta</code> | <code>supported</code> | <code>deprecated</code> |
         *        <code>retired</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleState(String lifecycleState);

        /**
         * <p>
         * An ordinal number that designates the order in which platform branches have been added to a platform. This
         * can be helpful, for example, if your code calls the <code>ListPlatformBranches</code> action and then
         * displays a list of platform branches.
         * </p>
         * <p>
         * A larger <code>BranchOrder</code> value designates a newer platform branch within the platform.
         * </p>
         * 
         * @param branchOrder
         *        An ordinal number that designates the order in which platform branches have been added to a platform.
         *        This can be helpful, for example, if your code calls the <code>ListPlatformBranches</code> action and
         *        then displays a list of platform branches.</p>
         *        <p>
         *        A larger <code>BranchOrder</code> value designates a newer platform branch within the platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branchOrder(Integer branchOrder);

        /**
         * <p>
         * The environment tiers that platform versions in this branch support.
         * </p>
         * <p>
         * Possible values: <code>WebServer/Standard</code> | <code>Worker/SQS/HTTP</code>
         * </p>
         * 
         * @param supportedTierList
         *        The environment tiers that platform versions in this branch support.</p>
         *        <p>
         *        Possible values: <code>WebServer/Standard</code> | <code>Worker/SQS/HTTP</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedTierList(Collection<String> supportedTierList);

        /**
         * <p>
         * The environment tiers that platform versions in this branch support.
         * </p>
         * <p>
         * Possible values: <code>WebServer/Standard</code> | <code>Worker/SQS/HTTP</code>
         * </p>
         * 
         * @param supportedTierList
         *        The environment tiers that platform versions in this branch support.</p>
         *        <p>
         *        Possible values: <code>WebServer/Standard</code> | <code>Worker/SQS/HTTP</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedTierList(String... supportedTierList);
    }

    static final class BuilderImpl implements Builder {
        private String platformName;

        private String branchName;

        private String lifecycleState;

        private Integer branchOrder;

        private List<String> supportedTierList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PlatformBranchSummary model) {
            platformName(model.platformName);
            branchName(model.branchName);
            lifecycleState(model.lifecycleState);
            branchOrder(model.branchOrder);
            supportedTierList(model.supportedTierList);
        }

        public final String getPlatformName() {
            return platformName;
        }

        public final void setPlatformName(String platformName) {
            this.platformName = platformName;
        }

        @Override
        public final Builder platformName(String platformName) {
            this.platformName = platformName;
            return this;
        }

        public final String getBranchName() {
            return branchName;
        }

        public final void setBranchName(String branchName) {
            this.branchName = branchName;
        }

        @Override
        public final Builder branchName(String branchName) {
            this.branchName = branchName;
            return this;
        }

        public final String getLifecycleState() {
            return lifecycleState;
        }

        public final void setLifecycleState(String lifecycleState) {
            this.lifecycleState = lifecycleState;
        }

        @Override
        public final Builder lifecycleState(String lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public final Integer getBranchOrder() {
            return branchOrder;
        }

        public final void setBranchOrder(Integer branchOrder) {
            this.branchOrder = branchOrder;
        }

        @Override
        public final Builder branchOrder(Integer branchOrder) {
            this.branchOrder = branchOrder;
            return this;
        }

        public final Collection<String> getSupportedTierList() {
            if (supportedTierList instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedTierList;
        }

        public final void setSupportedTierList(Collection<String> supportedTierList) {
            this.supportedTierList = SupportedTierListCopier.copy(supportedTierList);
        }

        @Override
        public final Builder supportedTierList(Collection<String> supportedTierList) {
            this.supportedTierList = SupportedTierListCopier.copy(supportedTierList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedTierList(String... supportedTierList) {
            supportedTierList(Arrays.asList(supportedTierList));
            return this;
        }

        @Override
        public PlatformBranchSummary build() {
            return new PlatformBranchSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
