/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents summary information about the health of an instance. For more information, see <a
 * href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">Health Colors and
 * Statuses</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceHealthSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceHealthSummary.Builder, InstanceHealthSummary> {
    private static final SdkField<Integer> NO_DATA_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NoData").getter(getter(InstanceHealthSummary::noData)).setter(setter(Builder::noData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoData").build()).build();

    private static final SdkField<Integer> UNKNOWN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Unknown").getter(getter(InstanceHealthSummary::unknown)).setter(setter(Builder::unknown))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unknown").build()).build();

    private static final SdkField<Integer> PENDING_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Pending").getter(getter(InstanceHealthSummary::pending)).setter(setter(Builder::pending))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pending").build()).build();

    private static final SdkField<Integer> OK_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Ok")
            .getter(getter(InstanceHealthSummary::ok)).setter(setter(Builder::ok))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ok").build()).build();

    private static final SdkField<Integer> INFO_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Info")
            .getter(getter(InstanceHealthSummary::info)).setter(setter(Builder::info))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Info").build()).build();

    private static final SdkField<Integer> WARNING_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Warning").getter(getter(InstanceHealthSummary::warning)).setter(setter(Builder::warning))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Warning").build()).build();

    private static final SdkField<Integer> DEGRADED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Degraded").getter(getter(InstanceHealthSummary::degraded)).setter(setter(Builder::degraded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Degraded").build()).build();

    private static final SdkField<Integer> SEVERE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Severe").getter(getter(InstanceHealthSummary::severe)).setter(setter(Builder::severe))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severe").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NO_DATA_FIELD, UNKNOWN_FIELD,
            PENDING_FIELD, OK_FIELD, INFO_FIELD, WARNING_FIELD, DEGRADED_FIELD, SEVERE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer noData;

    private final Integer unknown;

    private final Integer pending;

    private final Integer ok;

    private final Integer info;

    private final Integer warning;

    private final Integer degraded;

    private final Integer severe;

    private InstanceHealthSummary(BuilderImpl builder) {
        this.noData = builder.noData;
        this.unknown = builder.unknown;
        this.pending = builder.pending;
        this.ok = builder.ok;
        this.info = builder.info;
        this.warning = builder.warning;
        this.degraded = builder.degraded;
        this.severe = builder.severe;
    }

    /**
     * <p>
     * <b>Grey.</b> AWS Elastic Beanstalk and the health agent are reporting no data on an instance.
     * </p>
     * 
     * @return <b>Grey.</b> AWS Elastic Beanstalk and the health agent are reporting no data on an instance.
     */
    public final Integer noData() {
        return noData;
    }

    /**
     * <p>
     * <b>Grey.</b> AWS Elastic Beanstalk and the health agent are reporting an insufficient amount of data on an
     * instance.
     * </p>
     * 
     * @return <b>Grey.</b> AWS Elastic Beanstalk and the health agent are reporting an insufficient amount of data on
     *         an instance.
     */
    public final Integer unknown() {
        return unknown;
    }

    /**
     * <p>
     * <b>Grey.</b> An operation is in progress on an instance within the command timeout.
     * </p>
     * 
     * @return <b>Grey.</b> An operation is in progress on an instance within the command timeout.
     */
    public final Integer pending() {
        return pending;
    }

    /**
     * <p>
     * <b>Green.</b> An instance is passing health checks and the health agent is not reporting any problems.
     * </p>
     * 
     * @return <b>Green.</b> An instance is passing health checks and the health agent is not reporting any problems.
     */
    public final Integer ok() {
        return ok;
    }

    /**
     * <p>
     * <b>Green.</b> An operation is in progress on an instance.
     * </p>
     * 
     * @return <b>Green.</b> An operation is in progress on an instance.
     */
    public final Integer info() {
        return info;
    }

    /**
     * <p>
     * <b>Yellow.</b> The health agent is reporting a moderate number of request failures or other issues for an
     * instance or environment.
     * </p>
     * 
     * @return <b>Yellow.</b> The health agent is reporting a moderate number of request failures or other issues for an
     *         instance or environment.
     */
    public final Integer warning() {
        return warning;
    }

    /**
     * <p>
     * <b>Red.</b> The health agent is reporting a high number of request failures or other issues for an instance or
     * environment.
     * </p>
     * 
     * @return <b>Red.</b> The health agent is reporting a high number of request failures or other issues for an
     *         instance or environment.
     */
    public final Integer degraded() {
        return degraded;
    }

    /**
     * <p>
     * <b>Red.</b> The health agent is reporting a very high number of request failures or other issues for an instance
     * or environment.
     * </p>
     * 
     * @return <b>Red.</b> The health agent is reporting a very high number of request failures or other issues for an
     *         instance or environment.
     */
    public final Integer severe() {
        return severe;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(noData());
        hashCode = 31 * hashCode + Objects.hashCode(unknown());
        hashCode = 31 * hashCode + Objects.hashCode(pending());
        hashCode = 31 * hashCode + Objects.hashCode(ok());
        hashCode = 31 * hashCode + Objects.hashCode(info());
        hashCode = 31 * hashCode + Objects.hashCode(warning());
        hashCode = 31 * hashCode + Objects.hashCode(degraded());
        hashCode = 31 * hashCode + Objects.hashCode(severe());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceHealthSummary)) {
            return false;
        }
        InstanceHealthSummary other = (InstanceHealthSummary) obj;
        return Objects.equals(noData(), other.noData()) && Objects.equals(unknown(), other.unknown())
                && Objects.equals(pending(), other.pending()) && Objects.equals(ok(), other.ok())
                && Objects.equals(info(), other.info()) && Objects.equals(warning(), other.warning())
                && Objects.equals(degraded(), other.degraded()) && Objects.equals(severe(), other.severe());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceHealthSummary").add("NoData", noData()).add("Unknown", unknown())
                .add("Pending", pending()).add("Ok", ok()).add("Info", info()).add("Warning", warning())
                .add("Degraded", degraded()).add("Severe", severe()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NoData":
            return Optional.ofNullable(clazz.cast(noData()));
        case "Unknown":
            return Optional.ofNullable(clazz.cast(unknown()));
        case "Pending":
            return Optional.ofNullable(clazz.cast(pending()));
        case "Ok":
            return Optional.ofNullable(clazz.cast(ok()));
        case "Info":
            return Optional.ofNullable(clazz.cast(info()));
        case "Warning":
            return Optional.ofNullable(clazz.cast(warning()));
        case "Degraded":
            return Optional.ofNullable(clazz.cast(degraded()));
        case "Severe":
            return Optional.ofNullable(clazz.cast(severe()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceHealthSummary, T> g) {
        return obj -> g.apply((InstanceHealthSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceHealthSummary> {
        /**
         * <p>
         * <b>Grey.</b> AWS Elastic Beanstalk and the health agent are reporting no data on an instance.
         * </p>
         * 
         * @param noData
         *        <b>Grey.</b> AWS Elastic Beanstalk and the health agent are reporting no data on an instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noData(Integer noData);

        /**
         * <p>
         * <b>Grey.</b> AWS Elastic Beanstalk and the health agent are reporting an insufficient amount of data on an
         * instance.
         * </p>
         * 
         * @param unknown
         *        <b>Grey.</b> AWS Elastic Beanstalk and the health agent are reporting an insufficient amount of data
         *        on an instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unknown(Integer unknown);

        /**
         * <p>
         * <b>Grey.</b> An operation is in progress on an instance within the command timeout.
         * </p>
         * 
         * @param pending
         *        <b>Grey.</b> An operation is in progress on an instance within the command timeout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pending(Integer pending);

        /**
         * <p>
         * <b>Green.</b> An instance is passing health checks and the health agent is not reporting any problems.
         * </p>
         * 
         * @param ok
         *        <b>Green.</b> An instance is passing health checks and the health agent is not reporting any problems.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ok(Integer ok);

        /**
         * <p>
         * <b>Green.</b> An operation is in progress on an instance.
         * </p>
         * 
         * @param info
         *        <b>Green.</b> An operation is in progress on an instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder info(Integer info);

        /**
         * <p>
         * <b>Yellow.</b> The health agent is reporting a moderate number of request failures or other issues for an
         * instance or environment.
         * </p>
         * 
         * @param warning
         *        <b>Yellow.</b> The health agent is reporting a moderate number of request failures or other issues for
         *        an instance or environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warning(Integer warning);

        /**
         * <p>
         * <b>Red.</b> The health agent is reporting a high number of request failures or other issues for an instance
         * or environment.
         * </p>
         * 
         * @param degraded
         *        <b>Red.</b> The health agent is reporting a high number of request failures or other issues for an
         *        instance or environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder degraded(Integer degraded);

        /**
         * <p>
         * <b>Red.</b> The health agent is reporting a very high number of request failures or other issues for an
         * instance or environment.
         * </p>
         * 
         * @param severe
         *        <b>Red.</b> The health agent is reporting a very high number of request failures or other issues for
         *        an instance or environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severe(Integer severe);
    }

    static final class BuilderImpl implements Builder {
        private Integer noData;

        private Integer unknown;

        private Integer pending;

        private Integer ok;

        private Integer info;

        private Integer warning;

        private Integer degraded;

        private Integer severe;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceHealthSummary model) {
            noData(model.noData);
            unknown(model.unknown);
            pending(model.pending);
            ok(model.ok);
            info(model.info);
            warning(model.warning);
            degraded(model.degraded);
            severe(model.severe);
        }

        public final Integer getNoData() {
            return noData;
        }

        public final void setNoData(Integer noData) {
            this.noData = noData;
        }

        @Override
        public final Builder noData(Integer noData) {
            this.noData = noData;
            return this;
        }

        public final Integer getUnknown() {
            return unknown;
        }

        public final void setUnknown(Integer unknown) {
            this.unknown = unknown;
        }

        @Override
        public final Builder unknown(Integer unknown) {
            this.unknown = unknown;
            return this;
        }

        public final Integer getPending() {
            return pending;
        }

        public final void setPending(Integer pending) {
            this.pending = pending;
        }

        @Override
        public final Builder pending(Integer pending) {
            this.pending = pending;
            return this;
        }

        public final Integer getOk() {
            return ok;
        }

        public final void setOk(Integer ok) {
            this.ok = ok;
        }

        @Override
        public final Builder ok(Integer ok) {
            this.ok = ok;
            return this;
        }

        public final Integer getInfo() {
            return info;
        }

        public final void setInfo(Integer info) {
            this.info = info;
        }

        @Override
        public final Builder info(Integer info) {
            this.info = info;
            return this;
        }

        public final Integer getWarning() {
            return warning;
        }

        public final void setWarning(Integer warning) {
            this.warning = warning;
        }

        @Override
        public final Builder warning(Integer warning) {
            this.warning = warning;
            return this;
        }

        public final Integer getDegraded() {
            return degraded;
        }

        public final void setDegraded(Integer degraded) {
            this.degraded = degraded;
        }

        @Override
        public final Builder degraded(Integer degraded) {
            this.degraded = degraded;
            return this;
        }

        public final Integer getSevere() {
            return severe;
        }

        public final void setSevere(Integer severe) {
            this.severe = severe;
        }

        @Override
        public final Builder severe(Integer severe) {
            this.severe = severe;
            return this;
        }

        @Override
        public InstanceHealthSummary build() {
            return new InstanceHealthSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
