/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutBackupPolicyResponse extends EfsResponse implements
        ToCopyableBuilder<PutBackupPolicyResponse.Builder, PutBackupPolicyResponse> {
    private static final SdkField<BackupPolicy> BACKUP_POLICY_FIELD = SdkField.<BackupPolicy> builder(MarshallingType.SDK_POJO)
            .memberName("BackupPolicy").getter(getter(PutBackupPolicyResponse::backupPolicy))
            .setter(setter(Builder::backupPolicy)).constructor(BackupPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_POLICY_FIELD));

    private final BackupPolicy backupPolicy;

    private PutBackupPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.backupPolicy = builder.backupPolicy;
    }

    /**
     * <p>
     * Describes the file system's backup policy, indicating whether automatic backups are turned on or off.
     * </p>
     * 
     * @return Describes the file system's backup policy, indicating whether automatic backups are turned on or off.
     */
    public final BackupPolicy backupPolicy() {
        return backupPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backupPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBackupPolicyResponse)) {
            return false;
        }
        PutBackupPolicyResponse other = (PutBackupPolicyResponse) obj;
        return Objects.equals(backupPolicy(), other.backupPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutBackupPolicyResponse").add("BackupPolicy", backupPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupPolicy":
            return Optional.ofNullable(clazz.cast(backupPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutBackupPolicyResponse, T> g) {
        return obj -> g.apply((PutBackupPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EfsResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutBackupPolicyResponse> {
        /**
         * <p>
         * Describes the file system's backup policy, indicating whether automatic backups are turned on or off.
         * </p>
         * 
         * @param backupPolicy
         *        Describes the file system's backup policy, indicating whether automatic backups are turned on or off.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPolicy(BackupPolicy backupPolicy);

        /**
         * <p>
         * Describes the file system's backup policy, indicating whether automatic backups are turned on or off.
         * </p>
         * This is a convenience method that creates an instance of the {@link BackupPolicy.Builder} avoiding the need
         * to create one manually via {@link BackupPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BackupPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #backupPolicy(BackupPolicy)}.
         * 
         * @param backupPolicy
         *        a consumer that will call methods on {@link BackupPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #backupPolicy(BackupPolicy)
         */
        default Builder backupPolicy(Consumer<BackupPolicy.Builder> backupPolicy) {
            return backupPolicy(BackupPolicy.builder().applyMutation(backupPolicy).build());
        }
    }

    static final class BuilderImpl extends EfsResponse.BuilderImpl implements Builder {
        private BackupPolicy backupPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBackupPolicyResponse model) {
            super(model);
            backupPolicy(model.backupPolicy);
        }

        public final BackupPolicy.Builder getBackupPolicy() {
            return backupPolicy != null ? backupPolicy.toBuilder() : null;
        }

        public final void setBackupPolicy(BackupPolicy.BuilderImpl backupPolicy) {
            this.backupPolicy = backupPolicy != null ? backupPolicy.build() : null;
        }

        @Override
        public final Builder backupPolicy(BackupPolicy backupPolicy) {
            this.backupPolicy = backupPolicy;
            return this;
        }

        @Override
        public PutBackupPolicyResponse build() {
            return new PutBackupPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
