/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a stale rule in a security group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StaleIpPermission implements SdkPojo, Serializable,
        ToCopyableBuilder<StaleIpPermission.Builder, StaleIpPermission> {
    private static final SdkField<Integer> FROM_PORT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("FromPort")
            .getter(getter(StaleIpPermission::fromPort))
            .setter(setter(Builder::fromPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromPort")
                    .unmarshallLocationName("fromPort").build()).build();

    private static final SdkField<String> IP_PROTOCOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpProtocol")
            .getter(getter(StaleIpPermission::ipProtocol))
            .setter(setter(Builder::ipProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpProtocol")
                    .unmarshallLocationName("ipProtocol").build()).build();

    private static final SdkField<List<String>> IP_RANGES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("IpRanges")
            .getter(getter(StaleIpPermission::ipRanges))
            .setter(setter(Builder::ipRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpRanges")
                    .unmarshallLocationName("ipRanges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<String>> PREFIX_LIST_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PrefixListIds")
            .getter(getter(StaleIpPermission::prefixListIds))
            .setter(setter(Builder::prefixListIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListIds")
                    .unmarshallLocationName("prefixListIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Integer> TO_PORT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("ToPort")
            .getter(getter(StaleIpPermission::toPort))
            .setter(setter(Builder::toPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToPort")
                    .unmarshallLocationName("toPort").build()).build();

    private static final SdkField<List<UserIdGroupPair>> USER_ID_GROUP_PAIRS_FIELD = SdkField
            .<List<UserIdGroupPair>> builder(MarshallingType.LIST)
            .memberName("UserIdGroupPairs")
            .getter(getter(StaleIpPermission::userIdGroupPairs))
            .setter(setter(Builder::userIdGroupPairs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groups")
                    .unmarshallLocationName("groups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<UserIdGroupPair> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserIdGroupPair::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_PORT_FIELD,
            IP_PROTOCOL_FIELD, IP_RANGES_FIELD, PREFIX_LIST_IDS_FIELD, TO_PORT_FIELD, USER_ID_GROUP_PAIRS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer fromPort;

    private final String ipProtocol;

    private final List<String> ipRanges;

    private final List<String> prefixListIds;

    private final Integer toPort;

    private final List<UserIdGroupPair> userIdGroupPairs;

    private StaleIpPermission(BuilderImpl builder) {
        this.fromPort = builder.fromPort;
        this.ipProtocol = builder.ipProtocol;
        this.ipRanges = builder.ipRanges;
        this.prefixListIds = builder.prefixListIds;
        this.toPort = builder.toPort;
        this.userIdGroupPairs = builder.userIdGroupPairs;
    }

    /**
     * <p>
     * The start of the port range for the TCP and UDP protocols, or an ICMP type number. A value of -1 indicates all
     * ICMP types.
     * </p>
     * 
     * @return The start of the port range for the TCP and UDP protocols, or an ICMP type number. A value of -1
     *         indicates all ICMP types.
     */
    public final Integer fromPort() {
        return fromPort;
    }

    /**
     * <p>
     * The IP protocol name (for <code>tcp</code>, <code>udp</code>, and <code>icmp</code>) or number (see <a
     * href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers)</a>.
     * </p>
     * 
     * @return The IP protocol name (for <code>tcp</code>, <code>udp</code>, and <code>icmp</code>) or number (see <a
     *         href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers)</a>.
     */
    public final String ipProtocol() {
        return ipProtocol;
    }

    /**
     * For responses, this returns true if the service returned a value for the IpRanges property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIpRanges() {
        return ipRanges != null && !(ipRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IP ranges. Not applicable for stale security group rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpRanges} method.
     * </p>
     * 
     * @return The IP ranges. Not applicable for stale security group rules.
     */
    public final List<String> ipRanges() {
        return ipRanges;
    }

    /**
     * For responses, this returns true if the service returned a value for the PrefixListIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPrefixListIds() {
        return prefixListIds != null && !(prefixListIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The prefix list IDs. Not applicable for stale security group rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrefixListIds} method.
     * </p>
     * 
     * @return The prefix list IDs. Not applicable for stale security group rules.
     */
    public final List<String> prefixListIds() {
        return prefixListIds;
    }

    /**
     * <p>
     * The end of the port range for the TCP and UDP protocols, or an ICMP type number. A value of <code>-1</code>
     * indicates all ICMP types.
     * </p>
     * 
     * @return The end of the port range for the TCP and UDP protocols, or an ICMP type number. A value of
     *         <code>-1</code> indicates all ICMP types.
     */
    public final Integer toPort() {
        return toPort;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserIdGroupPairs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserIdGroupPairs() {
        return userIdGroupPairs != null && !(userIdGroupPairs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The security group pairs. Returns the ID of the referenced security group and VPC, and the ID and status of the
     * VPC peering connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserIdGroupPairs} method.
     * </p>
     * 
     * @return The security group pairs. Returns the ID of the referenced security group and VPC, and the ID and status
     *         of the VPC peering connection.
     */
    public final List<UserIdGroupPair> userIdGroupPairs() {
        return userIdGroupPairs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fromPort());
        hashCode = 31 * hashCode + Objects.hashCode(ipProtocol());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpRanges() ? ipRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPrefixListIds() ? prefixListIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(toPort());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserIdGroupPairs() ? userIdGroupPairs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StaleIpPermission)) {
            return false;
        }
        StaleIpPermission other = (StaleIpPermission) obj;
        return Objects.equals(fromPort(), other.fromPort()) && Objects.equals(ipProtocol(), other.ipProtocol())
                && hasIpRanges() == other.hasIpRanges() && Objects.equals(ipRanges(), other.ipRanges())
                && hasPrefixListIds() == other.hasPrefixListIds() && Objects.equals(prefixListIds(), other.prefixListIds())
                && Objects.equals(toPort(), other.toPort()) && hasUserIdGroupPairs() == other.hasUserIdGroupPairs()
                && Objects.equals(userIdGroupPairs(), other.userIdGroupPairs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StaleIpPermission").add("FromPort", fromPort()).add("IpProtocol", ipProtocol())
                .add("IpRanges", hasIpRanges() ? ipRanges() : null)
                .add("PrefixListIds", hasPrefixListIds() ? prefixListIds() : null).add("ToPort", toPort())
                .add("UserIdGroupPairs", hasUserIdGroupPairs() ? userIdGroupPairs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FromPort":
            return Optional.ofNullable(clazz.cast(fromPort()));
        case "IpProtocol":
            return Optional.ofNullable(clazz.cast(ipProtocol()));
        case "IpRanges":
            return Optional.ofNullable(clazz.cast(ipRanges()));
        case "PrefixListIds":
            return Optional.ofNullable(clazz.cast(prefixListIds()));
        case "ToPort":
            return Optional.ofNullable(clazz.cast(toPort()));
        case "UserIdGroupPairs":
            return Optional.ofNullable(clazz.cast(userIdGroupPairs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StaleIpPermission, T> g) {
        return obj -> g.apply((StaleIpPermission) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StaleIpPermission> {
        /**
         * <p>
         * The start of the port range for the TCP and UDP protocols, or an ICMP type number. A value of -1 indicates
         * all ICMP types.
         * </p>
         * 
         * @param fromPort
         *        The start of the port range for the TCP and UDP protocols, or an ICMP type number. A value of -1
         *        indicates all ICMP types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromPort(Integer fromPort);

        /**
         * <p>
         * The IP protocol name (for <code>tcp</code>, <code>udp</code>, and <code>icmp</code>) or number (see <a
         * href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers)</a>.
         * </p>
         * 
         * @param ipProtocol
         *        The IP protocol name (for <code>tcp</code>, <code>udp</code>, and <code>icmp</code>) or number (see <a
         *        href="http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml">Protocol Numbers)</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipProtocol(String ipProtocol);

        /**
         * <p>
         * The IP ranges. Not applicable for stale security group rules.
         * </p>
         * 
         * @param ipRanges
         *        The IP ranges. Not applicable for stale security group rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipRanges(Collection<String> ipRanges);

        /**
         * <p>
         * The IP ranges. Not applicable for stale security group rules.
         * </p>
         * 
         * @param ipRanges
         *        The IP ranges. Not applicable for stale security group rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipRanges(String... ipRanges);

        /**
         * <p>
         * The prefix list IDs. Not applicable for stale security group rules.
         * </p>
         * 
         * @param prefixListIds
         *        The prefix list IDs. Not applicable for stale security group rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListIds(Collection<String> prefixListIds);

        /**
         * <p>
         * The prefix list IDs. Not applicable for stale security group rules.
         * </p>
         * 
         * @param prefixListIds
         *        The prefix list IDs. Not applicable for stale security group rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListIds(String... prefixListIds);

        /**
         * <p>
         * The end of the port range for the TCP and UDP protocols, or an ICMP type number. A value of <code>-1</code>
         * indicates all ICMP types.
         * </p>
         * 
         * @param toPort
         *        The end of the port range for the TCP and UDP protocols, or an ICMP type number. A value of
         *        <code>-1</code> indicates all ICMP types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toPort(Integer toPort);

        /**
         * <p>
         * The security group pairs. Returns the ID of the referenced security group and VPC, and the ID and status of
         * the VPC peering connection.
         * </p>
         * 
         * @param userIdGroupPairs
         *        The security group pairs. Returns the ID of the referenced security group and VPC, and the ID and
         *        status of the VPC peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIdGroupPairs(Collection<UserIdGroupPair> userIdGroupPairs);

        /**
         * <p>
         * The security group pairs. Returns the ID of the referenced security group and VPC, and the ID and status of
         * the VPC peering connection.
         * </p>
         * 
         * @param userIdGroupPairs
         *        The security group pairs. Returns the ID of the referenced security group and VPC, and the ID and
         *        status of the VPC peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIdGroupPairs(UserIdGroupPair... userIdGroupPairs);

        /**
         * <p>
         * The security group pairs. Returns the ID of the referenced security group and VPC, and the ID and status of
         * the VPC peering connection.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.UserIdGroupPair.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.UserIdGroupPair#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.UserIdGroupPair.Builder#build()} is called immediately and
         * its result is passed to {@link #userIdGroupPairs(List<UserIdGroupPair>)}.
         * 
         * @param userIdGroupPairs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.UserIdGroupPair.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userIdGroupPairs(java.util.Collection<UserIdGroupPair>)
         */
        Builder userIdGroupPairs(Consumer<UserIdGroupPair.Builder>... userIdGroupPairs);
    }

    static final class BuilderImpl implements Builder {
        private Integer fromPort;

        private String ipProtocol;

        private List<String> ipRanges = DefaultSdkAutoConstructList.getInstance();

        private List<String> prefixListIds = DefaultSdkAutoConstructList.getInstance();

        private Integer toPort;

        private List<UserIdGroupPair> userIdGroupPairs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StaleIpPermission model) {
            fromPort(model.fromPort);
            ipProtocol(model.ipProtocol);
            ipRanges(model.ipRanges);
            prefixListIds(model.prefixListIds);
            toPort(model.toPort);
            userIdGroupPairs(model.userIdGroupPairs);
        }

        public final Integer getFromPort() {
            return fromPort;
        }

        public final void setFromPort(Integer fromPort) {
            this.fromPort = fromPort;
        }

        @Override
        public final Builder fromPort(Integer fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public final String getIpProtocol() {
            return ipProtocol;
        }

        public final void setIpProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
        }

        @Override
        public final Builder ipProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
            return this;
        }

        public final Collection<String> getIpRanges() {
            if (ipRanges instanceof SdkAutoConstructList) {
                return null;
            }
            return ipRanges;
        }

        public final void setIpRanges(Collection<String> ipRanges) {
            this.ipRanges = IpRangesCopier.copy(ipRanges);
        }

        @Override
        public final Builder ipRanges(Collection<String> ipRanges) {
            this.ipRanges = IpRangesCopier.copy(ipRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipRanges(String... ipRanges) {
            ipRanges(Arrays.asList(ipRanges));
            return this;
        }

        public final Collection<String> getPrefixListIds() {
            if (prefixListIds instanceof SdkAutoConstructList) {
                return null;
            }
            return prefixListIds;
        }

        public final void setPrefixListIds(Collection<String> prefixListIds) {
            this.prefixListIds = PrefixListIdSetCopier.copy(prefixListIds);
        }

        @Override
        public final Builder prefixListIds(Collection<String> prefixListIds) {
            this.prefixListIds = PrefixListIdSetCopier.copy(prefixListIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder prefixListIds(String... prefixListIds) {
            prefixListIds(Arrays.asList(prefixListIds));
            return this;
        }

        public final Integer getToPort() {
            return toPort;
        }

        public final void setToPort(Integer toPort) {
            this.toPort = toPort;
        }

        @Override
        public final Builder toPort(Integer toPort) {
            this.toPort = toPort;
            return this;
        }

        public final List<UserIdGroupPair.Builder> getUserIdGroupPairs() {
            List<UserIdGroupPair.Builder> result = UserIdGroupPairSetCopier.copyToBuilder(this.userIdGroupPairs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserIdGroupPairs(Collection<UserIdGroupPair.BuilderImpl> userIdGroupPairs) {
            this.userIdGroupPairs = UserIdGroupPairSetCopier.copyFromBuilder(userIdGroupPairs);
        }

        @Override
        public final Builder userIdGroupPairs(Collection<UserIdGroupPair> userIdGroupPairs) {
            this.userIdGroupPairs = UserIdGroupPairSetCopier.copy(userIdGroupPairs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIdGroupPairs(UserIdGroupPair... userIdGroupPairs) {
            userIdGroupPairs(Arrays.asList(userIdGroupPairs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIdGroupPairs(Consumer<UserIdGroupPair.Builder>... userIdGroupPairs) {
            userIdGroupPairs(Stream.of(userIdGroupPairs).map(c -> UserIdGroupPair.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public StaleIpPermission build() {
            return new StaleIpPermission(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
