/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyVerifiedAccessTrustProviderRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyVerifiedAccessTrustProviderRequest.Builder, ModifyVerifiedAccessTrustProviderRequest> {
    private static final SdkField<String> VERIFIED_ACCESS_TRUST_PROVIDER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VerifiedAccessTrustProviderId")
            .getter(getter(ModifyVerifiedAccessTrustProviderRequest::verifiedAccessTrustProviderId))
            .setter(setter(Builder::verifiedAccessTrustProviderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessTrustProviderId")
                    .unmarshallLocationName("VerifiedAccessTrustProviderId").build()).build();

    private static final SdkField<ModifyVerifiedAccessTrustProviderOidcOptions> OIDC_OPTIONS_FIELD = SdkField
            .<ModifyVerifiedAccessTrustProviderOidcOptions> builder(MarshallingType.SDK_POJO)
            .memberName("OidcOptions")
            .getter(getter(ModifyVerifiedAccessTrustProviderRequest::oidcOptions))
            .setter(setter(Builder::oidcOptions))
            .constructor(ModifyVerifiedAccessTrustProviderOidcOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OidcOptions")
                    .unmarshallLocationName("OidcOptions").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(ModifyVerifiedAccessTrustProviderRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(ModifyVerifiedAccessTrustProviderRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(ModifyVerifiedAccessTrustProviderRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<VerifiedAccessSseSpecificationRequest> SSE_SPECIFICATION_FIELD = SdkField
            .<VerifiedAccessSseSpecificationRequest> builder(MarshallingType.SDK_POJO)
            .memberName("SseSpecification")
            .getter(getter(ModifyVerifiedAccessTrustProviderRequest::sseSpecification))
            .setter(setter(Builder::sseSpecification))
            .constructor(VerifiedAccessSseSpecificationRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SseSpecification")
                    .unmarshallLocationName("SseSpecification").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VERIFIED_ACCESS_TRUST_PROVIDER_ID_FIELD, OIDC_OPTIONS_FIELD, DESCRIPTION_FIELD, DRY_RUN_FIELD, CLIENT_TOKEN_FIELD,
            SSE_SPECIFICATION_FIELD));

    private final String verifiedAccessTrustProviderId;

    private final ModifyVerifiedAccessTrustProviderOidcOptions oidcOptions;

    private final String description;

    private final Boolean dryRun;

    private final String clientToken;

    private final VerifiedAccessSseSpecificationRequest sseSpecification;

    private ModifyVerifiedAccessTrustProviderRequest(BuilderImpl builder) {
        super(builder);
        this.verifiedAccessTrustProviderId = builder.verifiedAccessTrustProviderId;
        this.oidcOptions = builder.oidcOptions;
        this.description = builder.description;
        this.dryRun = builder.dryRun;
        this.clientToken = builder.clientToken;
        this.sseSpecification = builder.sseSpecification;
    }

    /**
     * <p>
     * The ID of the Verified Access trust provider.
     * </p>
     * 
     * @return The ID of the Verified Access trust provider.
     */
    public final String verifiedAccessTrustProviderId() {
        return verifiedAccessTrustProviderId;
    }

    /**
     * <p>
     * The options for an OpenID Connect-compatible user-identity trust provider.
     * </p>
     * 
     * @return The options for an OpenID Connect-compatible user-identity trust provider.
     */
    public final ModifyVerifiedAccessTrustProviderOidcOptions oidcOptions() {
        return oidcOptions;
    }

    /**
     * <p>
     * A description for the Verified Access trust provider.
     * </p>
     * 
     * @return A description for the Verified Access trust provider.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * A unique, case-sensitive token that you provide to ensure idempotency of your modification request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency</a>.
     * </p>
     * 
     * @return A unique, case-sensitive token that you provide to ensure idempotency of your modification request. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         Idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Options for server side encryption.
     * </p>
     * 
     * @return Options for server side encryption.
     */
    public final VerifiedAccessSseSpecificationRequest sseSpecification() {
        return sseSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(verifiedAccessTrustProviderId());
        hashCode = 31 * hashCode + Objects.hashCode(oidcOptions());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(sseSpecification());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVerifiedAccessTrustProviderRequest)) {
            return false;
        }
        ModifyVerifiedAccessTrustProviderRequest other = (ModifyVerifiedAccessTrustProviderRequest) obj;
        return Objects.equals(verifiedAccessTrustProviderId(), other.verifiedAccessTrustProviderId())
                && Objects.equals(oidcOptions(), other.oidcOptions()) && Objects.equals(description(), other.description())
                && Objects.equals(dryRun(), other.dryRun()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(sseSpecification(), other.sseSpecification());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyVerifiedAccessTrustProviderRequest")
                .add("VerifiedAccessTrustProviderId", verifiedAccessTrustProviderId()).add("OidcOptions", oidcOptions())
                .add("Description", description()).add("DryRun", dryRun()).add("ClientToken", clientToken())
                .add("SseSpecification", sseSpecification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VerifiedAccessTrustProviderId":
            return Optional.ofNullable(clazz.cast(verifiedAccessTrustProviderId()));
        case "OidcOptions":
            return Optional.ofNullable(clazz.cast(oidcOptions()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "SseSpecification":
            return Optional.ofNullable(clazz.cast(sseSpecification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyVerifiedAccessTrustProviderRequest, T> g) {
        return obj -> g.apply((ModifyVerifiedAccessTrustProviderRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyVerifiedAccessTrustProviderRequest> {
        /**
         * <p>
         * The ID of the Verified Access trust provider.
         * </p>
         * 
         * @param verifiedAccessTrustProviderId
         *        The ID of the Verified Access trust provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedAccessTrustProviderId(String verifiedAccessTrustProviderId);

        /**
         * <p>
         * The options for an OpenID Connect-compatible user-identity trust provider.
         * </p>
         * 
         * @param oidcOptions
         *        The options for an OpenID Connect-compatible user-identity trust provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oidcOptions(ModifyVerifiedAccessTrustProviderOidcOptions oidcOptions);

        /**
         * <p>
         * The options for an OpenID Connect-compatible user-identity trust provider.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ModifyVerifiedAccessTrustProviderOidcOptions.Builder} avoiding the need to create one manually via
         * {@link ModifyVerifiedAccessTrustProviderOidcOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModifyVerifiedAccessTrustProviderOidcOptions.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #oidcOptions(ModifyVerifiedAccessTrustProviderOidcOptions)}.
         * 
         * @param oidcOptions
         *        a consumer that will call methods on {@link ModifyVerifiedAccessTrustProviderOidcOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oidcOptions(ModifyVerifiedAccessTrustProviderOidcOptions)
         */
        default Builder oidcOptions(Consumer<ModifyVerifiedAccessTrustProviderOidcOptions.Builder> oidcOptions) {
            return oidcOptions(ModifyVerifiedAccessTrustProviderOidcOptions.builder().applyMutation(oidcOptions).build());
        }

        /**
         * <p>
         * A description for the Verified Access trust provider.
         * </p>
         * 
         * @param description
         *        A description for the Verified Access trust provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * A unique, case-sensitive token that you provide to ensure idempotency of your modification request. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive token that you provide to ensure idempotency of your modification request.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Options for server side encryption.
         * </p>
         * 
         * @param sseSpecification
         *        Options for server side encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseSpecification(VerifiedAccessSseSpecificationRequest sseSpecification);

        /**
         * <p>
         * Options for server side encryption.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link VerifiedAccessSseSpecificationRequest.Builder} avoiding the need to create one manually via
         * {@link VerifiedAccessSseSpecificationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VerifiedAccessSseSpecificationRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #sseSpecification(VerifiedAccessSseSpecificationRequest)}.
         * 
         * @param sseSpecification
         *        a consumer that will call methods on {@link VerifiedAccessSseSpecificationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sseSpecification(VerifiedAccessSseSpecificationRequest)
         */
        default Builder sseSpecification(Consumer<VerifiedAccessSseSpecificationRequest.Builder> sseSpecification) {
            return sseSpecification(VerifiedAccessSseSpecificationRequest.builder().applyMutation(sseSpecification).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String verifiedAccessTrustProviderId;

        private ModifyVerifiedAccessTrustProviderOidcOptions oidcOptions;

        private String description;

        private Boolean dryRun;

        private String clientToken;

        private VerifiedAccessSseSpecificationRequest sseSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVerifiedAccessTrustProviderRequest model) {
            super(model);
            verifiedAccessTrustProviderId(model.verifiedAccessTrustProviderId);
            oidcOptions(model.oidcOptions);
            description(model.description);
            dryRun(model.dryRun);
            clientToken(model.clientToken);
            sseSpecification(model.sseSpecification);
        }

        public final String getVerifiedAccessTrustProviderId() {
            return verifiedAccessTrustProviderId;
        }

        public final void setVerifiedAccessTrustProviderId(String verifiedAccessTrustProviderId) {
            this.verifiedAccessTrustProviderId = verifiedAccessTrustProviderId;
        }

        @Override
        public final Builder verifiedAccessTrustProviderId(String verifiedAccessTrustProviderId) {
            this.verifiedAccessTrustProviderId = verifiedAccessTrustProviderId;
            return this;
        }

        public final ModifyVerifiedAccessTrustProviderOidcOptions.Builder getOidcOptions() {
            return oidcOptions != null ? oidcOptions.toBuilder() : null;
        }

        public final void setOidcOptions(ModifyVerifiedAccessTrustProviderOidcOptions.BuilderImpl oidcOptions) {
            this.oidcOptions = oidcOptions != null ? oidcOptions.build() : null;
        }

        @Override
        public final Builder oidcOptions(ModifyVerifiedAccessTrustProviderOidcOptions oidcOptions) {
            this.oidcOptions = oidcOptions;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final VerifiedAccessSseSpecificationRequest.Builder getSseSpecification() {
            return sseSpecification != null ? sseSpecification.toBuilder() : null;
        }

        public final void setSseSpecification(VerifiedAccessSseSpecificationRequest.BuilderImpl sseSpecification) {
            this.sseSpecification = sseSpecification != null ? sseSpecification.build() : null;
        }

        @Override
        public final Builder sseSpecification(VerifiedAccessSseSpecificationRequest sseSpecification) {
            this.sseSpecification = sseSpecification;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVerifiedAccessTrustProviderRequest build() {
            return new ModifyVerifiedAccessTrustProviderRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
