/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * DescribeLocationSmbResponse
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLocationSmbResponse extends DataSyncResponse implements
        ToCopyableBuilder<DescribeLocationSmbResponse.Builder, DescribeLocationSmbResponse> {
    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocationArn").getter(getter(DescribeLocationSmbResponse::locationArn))
            .setter(setter(Builder::locationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationArn").build()).build();

    private static final SdkField<String> LOCATION_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocationUri").getter(getter(DescribeLocationSmbResponse::locationUri))
            .setter(setter(Builder::locationUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationUri").build()).build();

    private static final SdkField<List<String>> AGENT_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AgentArns")
            .getter(getter(DescribeLocationSmbResponse::agentArns))
            .setter(setter(Builder::agentArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> USER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("User")
            .getter(getter(DescribeLocationSmbResponse::user)).setter(setter(Builder::user))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("User").build()).build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Domain")
            .getter(getter(DescribeLocationSmbResponse::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final SdkField<SmbMountOptions> MOUNT_OPTIONS_FIELD = SdkField
            .<SmbMountOptions> builder(MarshallingType.SDK_POJO).memberName("MountOptions")
            .getter(getter(DescribeLocationSmbResponse::mountOptions)).setter(setter(Builder::mountOptions))
            .constructor(SmbMountOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MountOptions").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeLocationSmbResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_ARN_FIELD,
            LOCATION_URI_FIELD, AGENT_ARNS_FIELD, USER_FIELD, DOMAIN_FIELD, MOUNT_OPTIONS_FIELD, CREATION_TIME_FIELD));

    private final String locationArn;

    private final String locationUri;

    private final List<String> agentArns;

    private final String user;

    private final String domain;

    private final SmbMountOptions mountOptions;

    private final Instant creationTime;

    private DescribeLocationSmbResponse(BuilderImpl builder) {
        super(builder);
        this.locationArn = builder.locationArn;
        this.locationUri = builder.locationUri;
        this.agentArns = builder.agentArns;
        this.user = builder.user;
        this.domain = builder.domain;
        this.mountOptions = builder.mountOptions;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the SMB location that was described.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the SMB location that was described.
     */
    public final String locationArn() {
        return locationArn;
    }

    /**
     * <p>
     * The URL of the source SMB location that was described.
     * </p>
     * 
     * @return The URL of the source SMB location that was described.
     */
    public final String locationUri() {
        return locationUri;
    }

    /**
     * For responses, this returns true if the service returned a value for the AgentArns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAgentArns() {
        return agentArns != null && !(agentArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the source SMB file system location that is created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAgentArns} method.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the source SMB file system location that is created.
     */
    public final List<String> agentArns() {
        return agentArns;
    }

    /**
     * <p>
     * The user who can mount the share, has the permissions to access files and folders in the SMB share.
     * </p>
     * 
     * @return The user who can mount the share, has the permissions to access files and folders in the SMB share.
     */
    public final String user() {
        return user;
    }

    /**
     * <p>
     * The name of the Windows domain that the SMB server belongs to.
     * </p>
     * 
     * @return The name of the Windows domain that the SMB server belongs to.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The mount options that are available for DataSync to use to access an SMB location.
     * </p>
     * 
     * @return The mount options that are available for DataSync to use to access an SMB location.
     */
    public final SmbMountOptions mountOptions() {
        return mountOptions;
    }

    /**
     * <p>
     * The time that the SMB location was created.
     * </p>
     * 
     * @return The time that the SMB location was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(locationArn());
        hashCode = 31 * hashCode + Objects.hashCode(locationUri());
        hashCode = 31 * hashCode + Objects.hashCode(hasAgentArns() ? agentArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(user());
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(mountOptions());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLocationSmbResponse)) {
            return false;
        }
        DescribeLocationSmbResponse other = (DescribeLocationSmbResponse) obj;
        return Objects.equals(locationArn(), other.locationArn()) && Objects.equals(locationUri(), other.locationUri())
                && hasAgentArns() == other.hasAgentArns() && Objects.equals(agentArns(), other.agentArns())
                && Objects.equals(user(), other.user()) && Objects.equals(domain(), other.domain())
                && Objects.equals(mountOptions(), other.mountOptions()) && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeLocationSmbResponse").add("LocationArn", locationArn())
                .add("LocationUri", locationUri()).add("AgentArns", hasAgentArns() ? agentArns() : null).add("User", user())
                .add("Domain", domain()).add("MountOptions", mountOptions()).add("CreationTime", creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocationArn":
            return Optional.ofNullable(clazz.cast(locationArn()));
        case "LocationUri":
            return Optional.ofNullable(clazz.cast(locationUri()));
        case "AgentArns":
            return Optional.ofNullable(clazz.cast(agentArns()));
        case "User":
            return Optional.ofNullable(clazz.cast(user()));
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "MountOptions":
            return Optional.ofNullable(clazz.cast(mountOptions()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLocationSmbResponse, T> g) {
        return obj -> g.apply((DescribeLocationSmbResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeLocationSmbResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the SMB location that was described.
         * </p>
         * 
         * @param locationArn
         *        The Amazon Resource Name (ARN) of the SMB location that was described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationArn(String locationArn);

        /**
         * <p>
         * The URL of the source SMB location that was described.
         * </p>
         * 
         * @param locationUri
         *        The URL of the source SMB location that was described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationUri(String locationUri);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the source SMB file system location that is created.
         * </p>
         * 
         * @param agentArns
         *        The Amazon Resource Name (ARN) of the source SMB file system location that is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentArns(Collection<String> agentArns);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the source SMB file system location that is created.
         * </p>
         * 
         * @param agentArns
         *        The Amazon Resource Name (ARN) of the source SMB file system location that is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentArns(String... agentArns);

        /**
         * <p>
         * The user who can mount the share, has the permissions to access files and folders in the SMB share.
         * </p>
         * 
         * @param user
         *        The user who can mount the share, has the permissions to access files and folders in the SMB share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder user(String user);

        /**
         * <p>
         * The name of the Windows domain that the SMB server belongs to.
         * </p>
         * 
         * @param domain
         *        The name of the Windows domain that the SMB server belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The mount options that are available for DataSync to use to access an SMB location.
         * </p>
         * 
         * @param mountOptions
         *        The mount options that are available for DataSync to use to access an SMB location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountOptions(SmbMountOptions mountOptions);

        /**
         * <p>
         * The mount options that are available for DataSync to use to access an SMB location.
         * </p>
         * This is a convenience method that creates an instance of the {@link SmbMountOptions.Builder} avoiding the
         * need to create one manually via {@link SmbMountOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SmbMountOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #mountOptions(SmbMountOptions)}.
         * 
         * @param mountOptions
         *        a consumer that will call methods on {@link SmbMountOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mountOptions(SmbMountOptions)
         */
        default Builder mountOptions(Consumer<SmbMountOptions.Builder> mountOptions) {
            return mountOptions(SmbMountOptions.builder().applyMutation(mountOptions).build());
        }

        /**
         * <p>
         * The time that the SMB location was created.
         * </p>
         * 
         * @param creationTime
         *        The time that the SMB location was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl extends DataSyncResponse.BuilderImpl implements Builder {
        private String locationArn;

        private String locationUri;

        private List<String> agentArns = DefaultSdkAutoConstructList.getInstance();

        private String user;

        private String domain;

        private SmbMountOptions mountOptions;

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLocationSmbResponse model) {
            super(model);
            locationArn(model.locationArn);
            locationUri(model.locationUri);
            agentArns(model.agentArns);
            user(model.user);
            domain(model.domain);
            mountOptions(model.mountOptions);
            creationTime(model.creationTime);
        }

        public final String getLocationArn() {
            return locationArn;
        }

        public final void setLocationArn(String locationArn) {
            this.locationArn = locationArn;
        }

        @Override
        public final Builder locationArn(String locationArn) {
            this.locationArn = locationArn;
            return this;
        }

        public final String getLocationUri() {
            return locationUri;
        }

        public final void setLocationUri(String locationUri) {
            this.locationUri = locationUri;
        }

        @Override
        public final Builder locationUri(String locationUri) {
            this.locationUri = locationUri;
            return this;
        }

        public final Collection<String> getAgentArns() {
            if (agentArns instanceof SdkAutoConstructList) {
                return null;
            }
            return agentArns;
        }

        public final void setAgentArns(Collection<String> agentArns) {
            this.agentArns = AgentArnListCopier.copy(agentArns);
        }

        @Override
        public final Builder agentArns(Collection<String> agentArns) {
            this.agentArns = AgentArnListCopier.copy(agentArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentArns(String... agentArns) {
            agentArns(Arrays.asList(agentArns));
            return this;
        }

        public final String getUser() {
            return user;
        }

        public final void setUser(String user) {
            this.user = user;
        }

        @Override
        public final Builder user(String user) {
            this.user = user;
            return this;
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final SmbMountOptions.Builder getMountOptions() {
            return mountOptions != null ? mountOptions.toBuilder() : null;
        }

        public final void setMountOptions(SmbMountOptions.BuilderImpl mountOptions) {
            this.mountOptions = mountOptions != null ? mountOptions.build() : null;
        }

        @Override
        public final Builder mountOptions(SmbMountOptions mountOptions) {
            this.mountOptions = mountOptions;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public DescribeLocationSmbResponse build() {
            return new DescribeLocationSmbResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
