/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a server in a Fleet Advisor collector inventory.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServerShortInfoResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<ServerShortInfoResponse.Builder, ServerShortInfoResponse> {
    private static final SdkField<String> SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerId").getter(getter(ServerShortInfoResponse::serverId)).setter(setter(Builder::serverId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerId").build()).build();

    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpAddress").getter(getter(ServerShortInfoResponse::ipAddress)).setter(setter(Builder::ipAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()).build();

    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerName").getter(getter(ServerShortInfoResponse::serverName)).setter(setter(Builder::serverName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_ID_FIELD,
            IP_ADDRESS_FIELD, SERVER_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String serverId;

    private final String ipAddress;

    private final String serverName;

    private ServerShortInfoResponse(BuilderImpl builder) {
        this.serverId = builder.serverId;
        this.ipAddress = builder.ipAddress;
        this.serverName = builder.serverName;
    }

    /**
     * <p>
     * The ID of a server in a Fleet Advisor collector inventory.
     * </p>
     * 
     * @return The ID of a server in a Fleet Advisor collector inventory.
     */
    public final String serverId() {
        return serverId;
    }

    /**
     * <p>
     * The IP address of a server in a Fleet Advisor collector inventory.
     * </p>
     * 
     * @return The IP address of a server in a Fleet Advisor collector inventory.
     */
    public final String ipAddress() {
        return ipAddress;
    }

    /**
     * <p>
     * The name address of a server in a Fleet Advisor collector inventory.
     * </p>
     * 
     * @return The name address of a server in a Fleet Advisor collector inventory.
     */
    public final String serverName() {
        return serverName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serverId());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(serverName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerShortInfoResponse)) {
            return false;
        }
        ServerShortInfoResponse other = (ServerShortInfoResponse) obj;
        return Objects.equals(serverId(), other.serverId()) && Objects.equals(ipAddress(), other.ipAddress())
                && Objects.equals(serverName(), other.serverName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServerShortInfoResponse").add("ServerId", serverId()).add("IpAddress", ipAddress())
                .add("ServerName", serverName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerId":
            return Optional.ofNullable(clazz.cast(serverId()));
        case "IpAddress":
            return Optional.ofNullable(clazz.cast(ipAddress()));
        case "ServerName":
            return Optional.ofNullable(clazz.cast(serverName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServerShortInfoResponse, T> g) {
        return obj -> g.apply((ServerShortInfoResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServerShortInfoResponse> {
        /**
         * <p>
         * The ID of a server in a Fleet Advisor collector inventory.
         * </p>
         * 
         * @param serverId
         *        The ID of a server in a Fleet Advisor collector inventory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverId(String serverId);

        /**
         * <p>
         * The IP address of a server in a Fleet Advisor collector inventory.
         * </p>
         * 
         * @param ipAddress
         *        The IP address of a server in a Fleet Advisor collector inventory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);

        /**
         * <p>
         * The name address of a server in a Fleet Advisor collector inventory.
         * </p>
         * 
         * @param serverName
         *        The name address of a server in a Fleet Advisor collector inventory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverName(String serverName);
    }

    static final class BuilderImpl implements Builder {
        private String serverId;

        private String ipAddress;

        private String serverName;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerShortInfoResponse model) {
            serverId(model.serverId);
            ipAddress(model.ipAddress);
            serverName(model.serverName);
        }

        public final String getServerId() {
            return serverId;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getServerName() {
            return serverName;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        @Override
        public ServerShortInfoResponse build() {
            return new ServerShortInfoResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
