/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReloadReplicationTablesResponse extends DatabaseMigrationResponse implements
        ToCopyableBuilder<ReloadReplicationTablesResponse.Builder, ReloadReplicationTablesResponse> {
    private static final SdkField<String> REPLICATION_CONFIG_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationConfigArn").getter(getter(ReloadReplicationTablesResponse::replicationConfigArn))
            .setter(setter(Builder::replicationConfigArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationConfigArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_CONFIG_ARN_FIELD));

    private final String replicationConfigArn;

    private ReloadReplicationTablesResponse(BuilderImpl builder) {
        super(builder);
        this.replicationConfigArn = builder.replicationConfigArn;
    }

    /**
     * <p>
     * The Amazon Resource Name of the replication config for which to reload tables.
     * </p>
     * 
     * @return The Amazon Resource Name of the replication config for which to reload tables.
     */
    public final String replicationConfigArn() {
        return replicationConfigArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicationConfigArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReloadReplicationTablesResponse)) {
            return false;
        }
        ReloadReplicationTablesResponse other = (ReloadReplicationTablesResponse) obj;
        return Objects.equals(replicationConfigArn(), other.replicationConfigArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReloadReplicationTablesResponse").add("ReplicationConfigArn", replicationConfigArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationConfigArn":
            return Optional.ofNullable(clazz.cast(replicationConfigArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReloadReplicationTablesResponse, T> g) {
        return obj -> g.apply((ReloadReplicationTablesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ReloadReplicationTablesResponse> {
        /**
         * <p>
         * The Amazon Resource Name of the replication config for which to reload tables.
         * </p>
         * 
         * @param replicationConfigArn
         *        The Amazon Resource Name of the replication config for which to reload tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationConfigArn(String replicationConfigArn);
    }

    static final class BuilderImpl extends DatabaseMigrationResponse.BuilderImpl implements Builder {
        private String replicationConfigArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ReloadReplicationTablesResponse model) {
            super(model);
            replicationConfigArn(model.replicationConfigArn);
        }

        public final String getReplicationConfigArn() {
            return replicationConfigArn;
        }

        public final void setReplicationConfigArn(String replicationConfigArn) {
            this.replicationConfigArn = replicationConfigArn;
        }

        @Override
        public final Builder replicationConfigArn(String replicationConfigArn) {
            this.replicationConfigArn = replicationConfigArn;
            return this;
        }

        @Override
        public ReloadReplicationTablesResponse build() {
            return new ReloadReplicationTablesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
