/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportMetadataModelAssessmentRequest extends DatabaseMigrationRequest implements
        ToCopyableBuilder<ExportMetadataModelAssessmentRequest.Builder, ExportMetadataModelAssessmentRequest> {
    private static final SdkField<String> MIGRATION_PROJECT_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MigrationProjectIdentifier")
            .getter(getter(ExportMetadataModelAssessmentRequest::migrationProjectIdentifier))
            .setter(setter(Builder::migrationProjectIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationProjectIdentifier").build())
            .build();

    private static final SdkField<String> SELECTION_RULES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SelectionRules").getter(getter(ExportMetadataModelAssessmentRequest::selectionRules))
            .setter(setter(Builder::selectionRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectionRules").build()).build();

    private static final SdkField<String> FILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileName").getter(getter(ExportMetadataModelAssessmentRequest::fileName))
            .setter(setter(Builder::fileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileName").build()).build();

    private static final SdkField<List<String>> ASSESSMENT_REPORT_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AssessmentReportTypes")
            .getter(getter(ExportMetadataModelAssessmentRequest::assessmentReportTypesAsStrings))
            .setter(setter(Builder::assessmentReportTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssessmentReportTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MIGRATION_PROJECT_IDENTIFIER_FIELD, SELECTION_RULES_FIELD, FILE_NAME_FIELD, ASSESSMENT_REPORT_TYPES_FIELD));

    private final String migrationProjectIdentifier;

    private final String selectionRules;

    private final String fileName;

    private final List<String> assessmentReportTypes;

    private ExportMetadataModelAssessmentRequest(BuilderImpl builder) {
        super(builder);
        this.migrationProjectIdentifier = builder.migrationProjectIdentifier;
        this.selectionRules = builder.selectionRules;
        this.fileName = builder.fileName;
        this.assessmentReportTypes = builder.assessmentReportTypes;
    }

    /**
     * <p>
     * The migration project name or Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The migration project name or Amazon Resource Name (ARN).
     */
    public final String migrationProjectIdentifier() {
        return migrationProjectIdentifier;
    }

    /**
     * <p>
     * A value that specifies the database objects to assess.
     * </p>
     * 
     * @return A value that specifies the database objects to assess.
     */
    public final String selectionRules() {
        return selectionRules;
    }

    /**
     * <p>
     * The name of the assessment file to create in your Amazon S3 bucket.
     * </p>
     * 
     * @return The name of the assessment file to create in your Amazon S3 bucket.
     */
    public final String fileName() {
        return fileName;
    }

    /**
     * <p>
     * The file format of the assessment file.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssessmentReportTypes} method.
     * </p>
     * 
     * @return The file format of the assessment file.
     */
    public final List<AssessmentReportType> assessmentReportTypes() {
        return AssessmentReportTypesListCopier.copyStringToEnum(assessmentReportTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the AssessmentReportTypes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAssessmentReportTypes() {
        return assessmentReportTypes != null && !(assessmentReportTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The file format of the assessment file.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssessmentReportTypes} method.
     * </p>
     * 
     * @return The file format of the assessment file.
     */
    public final List<String> assessmentReportTypesAsStrings() {
        return assessmentReportTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(migrationProjectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(selectionRules());
        hashCode = 31 * hashCode + Objects.hashCode(fileName());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssessmentReportTypes() ? assessmentReportTypesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportMetadataModelAssessmentRequest)) {
            return false;
        }
        ExportMetadataModelAssessmentRequest other = (ExportMetadataModelAssessmentRequest) obj;
        return Objects.equals(migrationProjectIdentifier(), other.migrationProjectIdentifier())
                && Objects.equals(selectionRules(), other.selectionRules()) && Objects.equals(fileName(), other.fileName())
                && hasAssessmentReportTypes() == other.hasAssessmentReportTypes()
                && Objects.equals(assessmentReportTypesAsStrings(), other.assessmentReportTypesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportMetadataModelAssessmentRequest")
                .add("MigrationProjectIdentifier", migrationProjectIdentifier()).add("SelectionRules", selectionRules())
                .add("FileName", fileName())
                .add("AssessmentReportTypes", hasAssessmentReportTypes() ? assessmentReportTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MigrationProjectIdentifier":
            return Optional.ofNullable(clazz.cast(migrationProjectIdentifier()));
        case "SelectionRules":
            return Optional.ofNullable(clazz.cast(selectionRules()));
        case "FileName":
            return Optional.ofNullable(clazz.cast(fileName()));
        case "AssessmentReportTypes":
            return Optional.ofNullable(clazz.cast(assessmentReportTypesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportMetadataModelAssessmentRequest, T> g) {
        return obj -> g.apply((ExportMetadataModelAssessmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ExportMetadataModelAssessmentRequest> {
        /**
         * <p>
         * The migration project name or Amazon Resource Name (ARN).
         * </p>
         * 
         * @param migrationProjectIdentifier
         *        The migration project name or Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder migrationProjectIdentifier(String migrationProjectIdentifier);

        /**
         * <p>
         * A value that specifies the database objects to assess.
         * </p>
         * 
         * @param selectionRules
         *        A value that specifies the database objects to assess.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectionRules(String selectionRules);

        /**
         * <p>
         * The name of the assessment file to create in your Amazon S3 bucket.
         * </p>
         * 
         * @param fileName
         *        The name of the assessment file to create in your Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileName(String fileName);

        /**
         * <p>
         * The file format of the assessment file.
         * </p>
         * 
         * @param assessmentReportTypes
         *        The file format of the assessment file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentReportTypesWithStrings(Collection<String> assessmentReportTypes);

        /**
         * <p>
         * The file format of the assessment file.
         * </p>
         * 
         * @param assessmentReportTypes
         *        The file format of the assessment file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentReportTypesWithStrings(String... assessmentReportTypes);

        /**
         * <p>
         * The file format of the assessment file.
         * </p>
         * 
         * @param assessmentReportTypes
         *        The file format of the assessment file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentReportTypes(Collection<AssessmentReportType> assessmentReportTypes);

        /**
         * <p>
         * The file format of the assessment file.
         * </p>
         * 
         * @param assessmentReportTypes
         *        The file format of the assessment file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentReportTypes(AssessmentReportType... assessmentReportTypes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DatabaseMigrationRequest.BuilderImpl implements Builder {
        private String migrationProjectIdentifier;

        private String selectionRules;

        private String fileName;

        private List<String> assessmentReportTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExportMetadataModelAssessmentRequest model) {
            super(model);
            migrationProjectIdentifier(model.migrationProjectIdentifier);
            selectionRules(model.selectionRules);
            fileName(model.fileName);
            assessmentReportTypesWithStrings(model.assessmentReportTypes);
        }

        public final String getMigrationProjectIdentifier() {
            return migrationProjectIdentifier;
        }

        public final void setMigrationProjectIdentifier(String migrationProjectIdentifier) {
            this.migrationProjectIdentifier = migrationProjectIdentifier;
        }

        @Override
        public final Builder migrationProjectIdentifier(String migrationProjectIdentifier) {
            this.migrationProjectIdentifier = migrationProjectIdentifier;
            return this;
        }

        public final String getSelectionRules() {
            return selectionRules;
        }

        public final void setSelectionRules(String selectionRules) {
            this.selectionRules = selectionRules;
        }

        @Override
        public final Builder selectionRules(String selectionRules) {
            this.selectionRules = selectionRules;
            return this;
        }

        public final String getFileName() {
            return fileName;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public final Collection<String> getAssessmentReportTypes() {
            if (assessmentReportTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return assessmentReportTypes;
        }

        public final void setAssessmentReportTypes(Collection<String> assessmentReportTypes) {
            this.assessmentReportTypes = AssessmentReportTypesListCopier.copy(assessmentReportTypes);
        }

        @Override
        public final Builder assessmentReportTypesWithStrings(Collection<String> assessmentReportTypes) {
            this.assessmentReportTypes = AssessmentReportTypesListCopier.copy(assessmentReportTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentReportTypesWithStrings(String... assessmentReportTypes) {
            assessmentReportTypesWithStrings(Arrays.asList(assessmentReportTypes));
            return this;
        }

        @Override
        public final Builder assessmentReportTypes(Collection<AssessmentReportType> assessmentReportTypes) {
            this.assessmentReportTypes = AssessmentReportTypesListCopier.copyEnumToString(assessmentReportTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentReportTypes(AssessmentReportType... assessmentReportTypes) {
            assessmentReportTypes(Arrays.asList(assessmentReportTypes));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExportMetadataModelAssessmentRequest build() {
            return new ExportMetadataModelAssessmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
