/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteReplicationTaskResponse extends DatabaseMigrationResponse implements
        ToCopyableBuilder<DeleteReplicationTaskResponse.Builder, DeleteReplicationTaskResponse> {
    private static final SdkField<ReplicationTask> REPLICATION_TASK_FIELD = SdkField
            .<ReplicationTask> builder(MarshallingType.SDK_POJO).memberName("ReplicationTask")
            .getter(getter(DeleteReplicationTaskResponse::replicationTask)).setter(setter(Builder::replicationTask))
            .constructor(ReplicationTask::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTask").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_TASK_FIELD));

    private final ReplicationTask replicationTask;

    private DeleteReplicationTaskResponse(BuilderImpl builder) {
        super(builder);
        this.replicationTask = builder.replicationTask;
    }

    /**
     * <p>
     * The deleted replication task.
     * </p>
     * 
     * @return The deleted replication task.
     */
    public final ReplicationTask replicationTask() {
        return replicationTask;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicationTask());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteReplicationTaskResponse)) {
            return false;
        }
        DeleteReplicationTaskResponse other = (DeleteReplicationTaskResponse) obj;
        return Objects.equals(replicationTask(), other.replicationTask());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteReplicationTaskResponse").add("ReplicationTask", replicationTask()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationTask":
            return Optional.ofNullable(clazz.cast(replicationTask()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteReplicationTaskResponse, T> g) {
        return obj -> g.apply((DeleteReplicationTaskResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteReplicationTaskResponse> {
        /**
         * <p>
         * The deleted replication task.
         * </p>
         * 
         * @param replicationTask
         *        The deleted replication task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTask(ReplicationTask replicationTask);

        /**
         * <p>
         * The deleted replication task.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReplicationTask.Builder} avoiding the
         * need to create one manually via {@link ReplicationTask#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReplicationTask.Builder#build()} is called immediately and its
         * result is passed to {@link #replicationTask(ReplicationTask)}.
         * 
         * @param replicationTask
         *        a consumer that will call methods on {@link ReplicationTask.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicationTask(ReplicationTask)
         */
        default Builder replicationTask(Consumer<ReplicationTask.Builder> replicationTask) {
            return replicationTask(ReplicationTask.builder().applyMutation(replicationTask).build());
        }
    }

    static final class BuilderImpl extends DatabaseMigrationResponse.BuilderImpl implements Builder {
        private ReplicationTask replicationTask;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteReplicationTaskResponse model) {
            super(model);
            replicationTask(model.replicationTask);
        }

        public final ReplicationTask.Builder getReplicationTask() {
            return replicationTask != null ? replicationTask.toBuilder() : null;
        }

        public final void setReplicationTask(ReplicationTask.BuilderImpl replicationTask) {
            this.replicationTask = replicationTask != null ? replicationTask.build() : null;
        }

        @Override
        public final Builder replicationTask(ReplicationTask replicationTask) {
            this.replicationTask = replicationTask;
            return this;
        }

        @Override
        public DeleteReplicationTaskResponse build() {
            return new DeleteReplicationTaskResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
