/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteDataProviderRequest extends DatabaseMigrationRequest implements
        ToCopyableBuilder<DeleteDataProviderRequest.Builder, DeleteDataProviderRequest> {
    private static final SdkField<String> DATA_PROVIDER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataProviderIdentifier").getter(getter(DeleteDataProviderRequest::dataProviderIdentifier))
            .setter(setter(Builder::dataProviderIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataProviderIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DATA_PROVIDER_IDENTIFIER_FIELD));

    private final String dataProviderIdentifier;

    private DeleteDataProviderRequest(BuilderImpl builder) {
        super(builder);
        this.dataProviderIdentifier = builder.dataProviderIdentifier;
    }

    /**
     * <p>
     * The identifier of the data provider to delete.
     * </p>
     * 
     * @return The identifier of the data provider to delete.
     */
    public final String dataProviderIdentifier() {
        return dataProviderIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataProviderIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDataProviderRequest)) {
            return false;
        }
        DeleteDataProviderRequest other = (DeleteDataProviderRequest) obj;
        return Objects.equals(dataProviderIdentifier(), other.dataProviderIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteDataProviderRequest").add("DataProviderIdentifier", dataProviderIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataProviderIdentifier":
            return Optional.ofNullable(clazz.cast(dataProviderIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteDataProviderRequest, T> g) {
        return obj -> g.apply((DeleteDataProviderRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteDataProviderRequest> {
        /**
         * <p>
         * The identifier of the data provider to delete.
         * </p>
         * 
         * @param dataProviderIdentifier
         *        The identifier of the data provider to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataProviderIdentifier(String dataProviderIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DatabaseMigrationRequest.BuilderImpl implements Builder {
        private String dataProviderIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDataProviderRequest model) {
            super(model);
            dataProviderIdentifier(model.dataProviderIdentifier);
        }

        public final String getDataProviderIdentifier() {
            return dataProviderIdentifier;
        }

        public final void setDataProviderIdentifier(String dataProviderIdentifier) {
            this.dataProviderIdentifier = dataProviderIdentifier;
        }

        @Override
        public final Builder dataProviderIdentifier(String dataProviderIdentifier) {
            this.dataProviderIdentifier = dataProviderIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteDataProviderRequest build() {
            return new DeleteDataProviderRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
