/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCostCategoryDefinitionRequest extends CostExplorerRequest implements
        ToCopyableBuilder<DescribeCostCategoryDefinitionRequest.Builder, DescribeCostCategoryDefinitionRequest> {
    private static final SdkField<String> COST_CATEGORY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CostCategoryArn").getter(getter(DescribeCostCategoryDefinitionRequest::costCategoryArn))
            .setter(setter(Builder::costCategoryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostCategoryArn").build()).build();

    private static final SdkField<String> EFFECTIVE_ON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EffectiveOn").getter(getter(DescribeCostCategoryDefinitionRequest::effectiveOn))
            .setter(setter(Builder::effectiveOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EffectiveOn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COST_CATEGORY_ARN_FIELD,
            EFFECTIVE_ON_FIELD));

    private final String costCategoryArn;

    private final String effectiveOn;

    private DescribeCostCategoryDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.costCategoryArn = builder.costCategoryArn;
        this.effectiveOn = builder.effectiveOn;
    }

    /**
     * <p>
     * The unique identifier for your Cost Category.
     * </p>
     * 
     * @return The unique identifier for your Cost Category.
     */
    public final String costCategoryArn() {
        return costCategoryArn;
    }

    /**
     * <p>
     * The date when the Cost Category was effective.
     * </p>
     * 
     * @return The date when the Cost Category was effective.
     */
    public final String effectiveOn() {
        return effectiveOn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(costCategoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(effectiveOn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCostCategoryDefinitionRequest)) {
            return false;
        }
        DescribeCostCategoryDefinitionRequest other = (DescribeCostCategoryDefinitionRequest) obj;
        return Objects.equals(costCategoryArn(), other.costCategoryArn()) && Objects.equals(effectiveOn(), other.effectiveOn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCostCategoryDefinitionRequest").add("CostCategoryArn", costCategoryArn())
                .add("EffectiveOn", effectiveOn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CostCategoryArn":
            return Optional.ofNullable(clazz.cast(costCategoryArn()));
        case "EffectiveOn":
            return Optional.ofNullable(clazz.cast(effectiveOn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCostCategoryDefinitionRequest, T> g) {
        return obj -> g.apply((DescribeCostCategoryDefinitionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeCostCategoryDefinitionRequest> {
        /**
         * <p>
         * The unique identifier for your Cost Category.
         * </p>
         * 
         * @param costCategoryArn
         *        The unique identifier for your Cost Category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costCategoryArn(String costCategoryArn);

        /**
         * <p>
         * The date when the Cost Category was effective.
         * </p>
         * 
         * @param effectiveOn
         *        The date when the Cost Category was effective.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveOn(String effectiveOn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostExplorerRequest.BuilderImpl implements Builder {
        private String costCategoryArn;

        private String effectiveOn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCostCategoryDefinitionRequest model) {
            super(model);
            costCategoryArn(model.costCategoryArn);
            effectiveOn(model.effectiveOn);
        }

        public final String getCostCategoryArn() {
            return costCategoryArn;
        }

        public final void setCostCategoryArn(String costCategoryArn) {
            this.costCategoryArn = costCategoryArn;
        }

        @Override
        public final Builder costCategoryArn(String costCategoryArn) {
            this.costCategoryArn = costCategoryArn;
            return this;
        }

        public final String getEffectiveOn() {
            return effectiveOn;
        }

        public final void setEffectiveOn(String effectiveOn) {
            this.effectiveOn = effectiveOn;
        }

        @Override
        public final Builder effectiveOn(String effectiveOn) {
            this.effectiveOn = effectiveOn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeCostCategoryDefinitionRequest build() {
            return new DescribeCostCategoryDefinitionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
