/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTrafficDistributionResponse extends ConnectResponse implements
        ToCopyableBuilder<GetTrafficDistributionResponse.Builder, GetTrafficDistributionResponse> {
    private static final SdkField<TelephonyConfig> TELEPHONY_CONFIG_FIELD = SdkField
            .<TelephonyConfig> builder(MarshallingType.SDK_POJO).memberName("TelephonyConfig")
            .getter(getter(GetTrafficDistributionResponse::telephonyConfig)).setter(setter(Builder::telephonyConfig))
            .constructor(TelephonyConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TelephonyConfig").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(GetTrafficDistributionResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(GetTrafficDistributionResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<SignInConfig> SIGN_IN_CONFIG_FIELD = SdkField.<SignInConfig> builder(MarshallingType.SDK_POJO)
            .memberName("SignInConfig").getter(getter(GetTrafficDistributionResponse::signInConfig))
            .setter(setter(Builder::signInConfig)).constructor(SignInConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignInConfig").build()).build();

    private static final SdkField<AgentConfig> AGENT_CONFIG_FIELD = SdkField.<AgentConfig> builder(MarshallingType.SDK_POJO)
            .memberName("AgentConfig").getter(getter(GetTrafficDistributionResponse::agentConfig))
            .setter(setter(Builder::agentConfig)).constructor(AgentConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TELEPHONY_CONFIG_FIELD,
            ID_FIELD, ARN_FIELD, SIGN_IN_CONFIG_FIELD, AGENT_CONFIG_FIELD));

    private final TelephonyConfig telephonyConfig;

    private final String id;

    private final String arn;

    private final SignInConfig signInConfig;

    private final AgentConfig agentConfig;

    private GetTrafficDistributionResponse(BuilderImpl builder) {
        super(builder);
        this.telephonyConfig = builder.telephonyConfig;
        this.id = builder.id;
        this.arn = builder.arn;
        this.signInConfig = builder.signInConfig;
        this.agentConfig = builder.agentConfig;
    }

    /**
     * <p>
     * The distribution of traffic between the instance and its replicas.
     * </p>
     * 
     * @return The distribution of traffic between the instance and its replicas.
     */
    public final TelephonyConfig telephonyConfig() {
        return telephonyConfig;
    }

    /**
     * <p>
     * The identifier of the traffic distribution group. This can be the ID or the ARN if the API is being called in the
     * Region where the traffic distribution group was created. The ARN must be provided if the call is from the
     * replicated Region.
     * </p>
     * 
     * @return The identifier of the traffic distribution group. This can be the ID or the ARN if the API is being
     *         called in the Region where the traffic distribution group was created. The ARN must be provided if the
     *         call is from the replicated Region.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the traffic distribution group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the traffic distribution group.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The distribution of allowing signing in to the instance and its replica(s).
     * </p>
     * 
     * @return The distribution of allowing signing in to the instance and its replica(s).
     */
    public final SignInConfig signInConfig() {
        return signInConfig;
    }

    /**
     * <p>
     * The distribution of agents between the instance and its replica(s).
     * </p>
     * 
     * @return The distribution of agents between the instance and its replica(s).
     */
    public final AgentConfig agentConfig() {
        return agentConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(telephonyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(signInConfig());
        hashCode = 31 * hashCode + Objects.hashCode(agentConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTrafficDistributionResponse)) {
            return false;
        }
        GetTrafficDistributionResponse other = (GetTrafficDistributionResponse) obj;
        return Objects.equals(telephonyConfig(), other.telephonyConfig()) && Objects.equals(id(), other.id())
                && Objects.equals(arn(), other.arn()) && Objects.equals(signInConfig(), other.signInConfig())
                && Objects.equals(agentConfig(), other.agentConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTrafficDistributionResponse").add("TelephonyConfig", telephonyConfig()).add("Id", id())
                .add("Arn", arn()).add("SignInConfig", signInConfig()).add("AgentConfig", agentConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TelephonyConfig":
            return Optional.ofNullable(clazz.cast(telephonyConfig()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "SignInConfig":
            return Optional.ofNullable(clazz.cast(signInConfig()));
        case "AgentConfig":
            return Optional.ofNullable(clazz.cast(agentConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTrafficDistributionResponse, T> g) {
        return obj -> g.apply((GetTrafficDistributionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTrafficDistributionResponse> {
        /**
         * <p>
         * The distribution of traffic between the instance and its replicas.
         * </p>
         * 
         * @param telephonyConfig
         *        The distribution of traffic between the instance and its replicas.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder telephonyConfig(TelephonyConfig telephonyConfig);

        /**
         * <p>
         * The distribution of traffic between the instance and its replicas.
         * </p>
         * This is a convenience method that creates an instance of the {@link TelephonyConfig.Builder} avoiding the
         * need to create one manually via {@link TelephonyConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TelephonyConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #telephonyConfig(TelephonyConfig)}.
         * 
         * @param telephonyConfig
         *        a consumer that will call methods on {@link TelephonyConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #telephonyConfig(TelephonyConfig)
         */
        default Builder telephonyConfig(Consumer<TelephonyConfig.Builder> telephonyConfig) {
            return telephonyConfig(TelephonyConfig.builder().applyMutation(telephonyConfig).build());
        }

        /**
         * <p>
         * The identifier of the traffic distribution group. This can be the ID or the ARN if the API is being called in
         * the Region where the traffic distribution group was created. The ARN must be provided if the call is from the
         * replicated Region.
         * </p>
         * 
         * @param id
         *        The identifier of the traffic distribution group. This can be the ID or the ARN if the API is being
         *        called in the Region where the traffic distribution group was created. The ARN must be provided if the
         *        call is from the replicated Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the traffic distribution group.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the traffic distribution group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The distribution of allowing signing in to the instance and its replica(s).
         * </p>
         * 
         * @param signInConfig
         *        The distribution of allowing signing in to the instance and its replica(s).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signInConfig(SignInConfig signInConfig);

        /**
         * <p>
         * The distribution of allowing signing in to the instance and its replica(s).
         * </p>
         * This is a convenience method that creates an instance of the {@link SignInConfig.Builder} avoiding the need
         * to create one manually via {@link SignInConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SignInConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #signInConfig(SignInConfig)}.
         * 
         * @param signInConfig
         *        a consumer that will call methods on {@link SignInConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #signInConfig(SignInConfig)
         */
        default Builder signInConfig(Consumer<SignInConfig.Builder> signInConfig) {
            return signInConfig(SignInConfig.builder().applyMutation(signInConfig).build());
        }

        /**
         * <p>
         * The distribution of agents between the instance and its replica(s).
         * </p>
         * 
         * @param agentConfig
         *        The distribution of agents between the instance and its replica(s).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentConfig(AgentConfig agentConfig);

        /**
         * <p>
         * The distribution of agents between the instance and its replica(s).
         * </p>
         * This is a convenience method that creates an instance of the {@link AgentConfig.Builder} avoiding the need to
         * create one manually via {@link AgentConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AgentConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #agentConfig(AgentConfig)}.
         * 
         * @param agentConfig
         *        a consumer that will call methods on {@link AgentConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentConfig(AgentConfig)
         */
        default Builder agentConfig(Consumer<AgentConfig.Builder> agentConfig) {
            return agentConfig(AgentConfig.builder().applyMutation(agentConfig).build());
        }
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private TelephonyConfig telephonyConfig;

        private String id;

        private String arn;

        private SignInConfig signInConfig;

        private AgentConfig agentConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTrafficDistributionResponse model) {
            super(model);
            telephonyConfig(model.telephonyConfig);
            id(model.id);
            arn(model.arn);
            signInConfig(model.signInConfig);
            agentConfig(model.agentConfig);
        }

        public final TelephonyConfig.Builder getTelephonyConfig() {
            return telephonyConfig != null ? telephonyConfig.toBuilder() : null;
        }

        public final void setTelephonyConfig(TelephonyConfig.BuilderImpl telephonyConfig) {
            this.telephonyConfig = telephonyConfig != null ? telephonyConfig.build() : null;
        }

        @Override
        public final Builder telephonyConfig(TelephonyConfig telephonyConfig) {
            this.telephonyConfig = telephonyConfig;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final SignInConfig.Builder getSignInConfig() {
            return signInConfig != null ? signInConfig.toBuilder() : null;
        }

        public final void setSignInConfig(SignInConfig.BuilderImpl signInConfig) {
            this.signInConfig = signInConfig != null ? signInConfig.build() : null;
        }

        @Override
        public final Builder signInConfig(SignInConfig signInConfig) {
            this.signInConfig = signInConfig;
            return this;
        }

        public final AgentConfig.Builder getAgentConfig() {
            return agentConfig != null ? agentConfig.toBuilder() : null;
        }

        public final void setAgentConfig(AgentConfig.BuilderImpl agentConfig) {
            this.agentConfig = agentConfig != null ? agentConfig.build() : null;
        }

        @Override
        public final Builder agentConfig(AgentConfig agentConfig) {
            this.agentConfig = agentConfig;
            return this;
        }

        @Override
        public GetTrafficDistributionResponse build() {
            return new GetTrafficDistributionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
