/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the dimensions for a set of metrics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Dimensions implements SdkPojo, Serializable, ToCopyableBuilder<Dimensions.Builder, Dimensions> {
    private static final SdkField<QueueReference> QUEUE_FIELD = SdkField.<QueueReference> builder(MarshallingType.SDK_POJO)
            .memberName("Queue").getter(getter(Dimensions::queue)).setter(setter(Builder::queue))
            .constructor(QueueReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Queue").build()).build();

    private static final SdkField<String> CHANNEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Channel")
            .getter(getter(Dimensions::channelAsString)).setter(setter(Builder::channel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channel").build()).build();

    private static final SdkField<RoutingProfileReference> ROUTING_PROFILE_FIELD = SdkField
            .<RoutingProfileReference> builder(MarshallingType.SDK_POJO).memberName("RoutingProfile")
            .getter(getter(Dimensions::routingProfile)).setter(setter(Builder::routingProfile))
            .constructor(RoutingProfileReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingProfile").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_FIELD, CHANNEL_FIELD,
            ROUTING_PROFILE_FIELD));

    private static final long serialVersionUID = 1L;

    private final QueueReference queue;

    private final String channel;

    private final RoutingProfileReference routingProfile;

    private Dimensions(BuilderImpl builder) {
        this.queue = builder.queue;
        this.channel = builder.channel;
        this.routingProfile = builder.routingProfile;
    }

    /**
     * <p>
     * Information about the queue for which metrics are returned.
     * </p>
     * 
     * @return Information about the queue for which metrics are returned.
     */
    public final QueueReference queue() {
        return queue;
    }

    /**
     * <p>
     * The channel used for grouping and filters.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channel} will
     * return {@link Channel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelAsString}.
     * </p>
     * 
     * @return The channel used for grouping and filters.
     * @see Channel
     */
    public final Channel channel() {
        return Channel.fromValue(channel);
    }

    /**
     * <p>
     * The channel used for grouping and filters.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channel} will
     * return {@link Channel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelAsString}.
     * </p>
     * 
     * @return The channel used for grouping and filters.
     * @see Channel
     */
    public final String channelAsString() {
        return channel;
    }

    /**
     * Returns the value of the RoutingProfile property for this object.
     * 
     * @return The value of the RoutingProfile property for this object.
     */
    public final RoutingProfileReference routingProfile() {
        return routingProfile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queue());
        hashCode = 31 * hashCode + Objects.hashCode(channelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(routingProfile());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Dimensions)) {
            return false;
        }
        Dimensions other = (Dimensions) obj;
        return Objects.equals(queue(), other.queue()) && Objects.equals(channelAsString(), other.channelAsString())
                && Objects.equals(routingProfile(), other.routingProfile());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Dimensions").add("Queue", queue()).add("Channel", channelAsString())
                .add("RoutingProfile", routingProfile()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Queue":
            return Optional.ofNullable(clazz.cast(queue()));
        case "Channel":
            return Optional.ofNullable(clazz.cast(channelAsString()));
        case "RoutingProfile":
            return Optional.ofNullable(clazz.cast(routingProfile()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Dimensions, T> g) {
        return obj -> g.apply((Dimensions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Dimensions> {
        /**
         * <p>
         * Information about the queue for which metrics are returned.
         * </p>
         * 
         * @param queue
         *        Information about the queue for which metrics are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queue(QueueReference queue);

        /**
         * <p>
         * Information about the queue for which metrics are returned.
         * </p>
         * This is a convenience method that creates an instance of the {@link QueueReference.Builder} avoiding the need
         * to create one manually via {@link QueueReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QueueReference.Builder#build()} is called immediately and its
         * result is passed to {@link #queue(QueueReference)}.
         * 
         * @param queue
         *        a consumer that will call methods on {@link QueueReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queue(QueueReference)
         */
        default Builder queue(Consumer<QueueReference.Builder> queue) {
            return queue(QueueReference.builder().applyMutation(queue).build());
        }

        /**
         * <p>
         * The channel used for grouping and filters.
         * </p>
         * 
         * @param channel
         *        The channel used for grouping and filters.
         * @see Channel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Channel
         */
        Builder channel(String channel);

        /**
         * <p>
         * The channel used for grouping and filters.
         * </p>
         * 
         * @param channel
         *        The channel used for grouping and filters.
         * @see Channel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Channel
         */
        Builder channel(Channel channel);

        /**
         * Sets the value of the RoutingProfile property for this object.
         *
         * @param routingProfile
         *        The new value for the RoutingProfile property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingProfile(RoutingProfileReference routingProfile);

        /**
         * Sets the value of the RoutingProfile property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RoutingProfileReference.Builder} avoiding
         * the need to create one manually via {@link RoutingProfileReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RoutingProfileReference.Builder#build()} is called immediately
         * and its result is passed to {@link #routingProfile(RoutingProfileReference)}.
         * 
         * @param routingProfile
         *        a consumer that will call methods on {@link RoutingProfileReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routingProfile(RoutingProfileReference)
         */
        default Builder routingProfile(Consumer<RoutingProfileReference.Builder> routingProfile) {
            return routingProfile(RoutingProfileReference.builder().applyMutation(routingProfile).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private QueueReference queue;

        private String channel;

        private RoutingProfileReference routingProfile;

        private BuilderImpl() {
        }

        private BuilderImpl(Dimensions model) {
            queue(model.queue);
            channel(model.channel);
            routingProfile(model.routingProfile);
        }

        public final QueueReference.Builder getQueue() {
            return queue != null ? queue.toBuilder() : null;
        }

        public final void setQueue(QueueReference.BuilderImpl queue) {
            this.queue = queue != null ? queue.build() : null;
        }

        @Override
        public final Builder queue(QueueReference queue) {
            this.queue = queue;
            return this;
        }

        public final String getChannel() {
            return channel;
        }

        public final void setChannel(String channel) {
            this.channel = channel;
        }

        @Override
        public final Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        @Override
        public final Builder channel(Channel channel) {
            this.channel(channel == null ? null : channel.toString());
            return this;
        }

        public final RoutingProfileReference.Builder getRoutingProfile() {
            return routingProfile != null ? routingProfile.toBuilder() : null;
        }

        public final void setRoutingProfile(RoutingProfileReference.BuilderImpl routingProfile) {
            this.routingProfile = routingProfile != null ? routingProfile.build() : null;
        }

        @Override
        public final Builder routingProfile(RoutingProfileReference routingProfile) {
            this.routingProfile = routingProfile;
            return this;
        }

        @Override
        public Dimensions build() {
            return new Dimensions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
