/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActivateEvaluationFormRequest extends ConnectRequest implements
        ToCopyableBuilder<ActivateEvaluationFormRequest.Builder, ActivateEvaluationFormRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(ActivateEvaluationFormRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> EVALUATION_FORM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluationFormId").getter(getter(ActivateEvaluationFormRequest::evaluationFormId))
            .setter(setter(Builder::evaluationFormId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("EvaluationFormId").build()).build();

    private static final SdkField<Integer> EVALUATION_FORM_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EvaluationFormVersion").getter(getter(ActivateEvaluationFormRequest::evaluationFormVersion))
            .setter(setter(Builder::evaluationFormVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationFormVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            EVALUATION_FORM_ID_FIELD, EVALUATION_FORM_VERSION_FIELD));

    private final String instanceId;

    private final String evaluationFormId;

    private final Integer evaluationFormVersion;

    private ActivateEvaluationFormRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.evaluationFormId = builder.evaluationFormId;
        this.evaluationFormVersion = builder.evaluationFormVersion;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The unique identifier for the evaluation form.
     * </p>
     * 
     * @return The unique identifier for the evaluation form.
     */
    public final String evaluationFormId() {
        return evaluationFormId;
    }

    /**
     * <p>
     * The version of the evaluation form to activate. If the version property is not provided, the latest version of
     * the evaluation form is activated.
     * </p>
     * 
     * @return The version of the evaluation form to activate. If the version property is not provided, the latest
     *         version of the evaluation form is activated.
     */
    public final Integer evaluationFormVersion() {
        return evaluationFormVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationFormId());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationFormVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivateEvaluationFormRequest)) {
            return false;
        }
        ActivateEvaluationFormRequest other = (ActivateEvaluationFormRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(evaluationFormId(), other.evaluationFormId())
                && Objects.equals(evaluationFormVersion(), other.evaluationFormVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActivateEvaluationFormRequest").add("InstanceId", instanceId())
                .add("EvaluationFormId", evaluationFormId()).add("EvaluationFormVersion", evaluationFormVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "EvaluationFormId":
            return Optional.ofNullable(clazz.cast(evaluationFormId()));
        case "EvaluationFormVersion":
            return Optional.ofNullable(clazz.cast(evaluationFormVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActivateEvaluationFormRequest, T> g) {
        return obj -> g.apply((ActivateEvaluationFormRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, ActivateEvaluationFormRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The unique identifier for the evaluation form.
         * </p>
         * 
         * @param evaluationFormId
         *        The unique identifier for the evaluation form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationFormId(String evaluationFormId);

        /**
         * <p>
         * The version of the evaluation form to activate. If the version property is not provided, the latest version
         * of the evaluation form is activated.
         * </p>
         * 
         * @param evaluationFormVersion
         *        The version of the evaluation form to activate. If the version property is not provided, the latest
         *        version of the evaluation form is activated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationFormVersion(Integer evaluationFormVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String evaluationFormId;

        private Integer evaluationFormVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ActivateEvaluationFormRequest model) {
            super(model);
            instanceId(model.instanceId);
            evaluationFormId(model.evaluationFormId);
            evaluationFormVersion(model.evaluationFormVersion);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getEvaluationFormId() {
            return evaluationFormId;
        }

        public final void setEvaluationFormId(String evaluationFormId) {
            this.evaluationFormId = evaluationFormId;
        }

        @Override
        public final Builder evaluationFormId(String evaluationFormId) {
            this.evaluationFormId = evaluationFormId;
            return this;
        }

        public final Integer getEvaluationFormVersion() {
            return evaluationFormVersion;
        }

        public final void setEvaluationFormVersion(Integer evaluationFormVersion) {
            this.evaluationFormVersion = evaluationFormVersion;
        }

        @Override
        public final Builder evaluationFormVersion(Integer evaluationFormVersion) {
            this.evaluationFormVersion = evaluationFormVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ActivateEvaluationFormRequest build() {
            return new ActivateEvaluationFormRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
