/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * List of each of the failed remediations with specific reasons.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FailedRemediationBatch implements SdkPojo, Serializable,
        ToCopyableBuilder<FailedRemediationBatch.Builder, FailedRemediationBatch> {
    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureMessage").getter(getter(FailedRemediationBatch::failureMessage))
            .setter(setter(Builder::failureMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMessage").build()).build();

    private static final SdkField<List<RemediationConfiguration>> FAILED_ITEMS_FIELD = SdkField
            .<List<RemediationConfiguration>> builder(MarshallingType.LIST)
            .memberName("FailedItems")
            .getter(getter(FailedRemediationBatch::failedItems))
            .setter(setter(Builder::failedItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RemediationConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(RemediationConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILURE_MESSAGE_FIELD,
            FAILED_ITEMS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String failureMessage;

    private final List<RemediationConfiguration> failedItems;

    private FailedRemediationBatch(BuilderImpl builder) {
        this.failureMessage = builder.failureMessage;
        this.failedItems = builder.failedItems;
    }

    /**
     * <p>
     * Returns a failure message. For example, the resource is already compliant.
     * </p>
     * 
     * @return Returns a failure message. For example, the resource is already compliant.
     */
    public final String failureMessage() {
        return failureMessage;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailedItems property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFailedItems() {
        return failedItems != null && !(failedItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns remediation configurations of the failed items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailedItems} method.
     * </p>
     * 
     * @return Returns remediation configurations of the failed items.
     */
    public final List<RemediationConfiguration> failedItems() {
        return failedItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(hasFailedItems() ? failedItems() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailedRemediationBatch)) {
            return false;
        }
        FailedRemediationBatch other = (FailedRemediationBatch) obj;
        return Objects.equals(failureMessage(), other.failureMessage()) && hasFailedItems() == other.hasFailedItems()
                && Objects.equals(failedItems(), other.failedItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FailedRemediationBatch").add("FailureMessage", failureMessage())
                .add("FailedItems", hasFailedItems() ? failedItems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailureMessage":
            return Optional.ofNullable(clazz.cast(failureMessage()));
        case "FailedItems":
            return Optional.ofNullable(clazz.cast(failedItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FailedRemediationBatch, T> g) {
        return obj -> g.apply((FailedRemediationBatch) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FailedRemediationBatch> {
        /**
         * <p>
         * Returns a failure message. For example, the resource is already compliant.
         * </p>
         * 
         * @param failureMessage
         *        Returns a failure message. For example, the resource is already compliant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureMessage(String failureMessage);

        /**
         * <p>
         * Returns remediation configurations of the failed items.
         * </p>
         * 
         * @param failedItems
         *        Returns remediation configurations of the failed items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedItems(Collection<RemediationConfiguration> failedItems);

        /**
         * <p>
         * Returns remediation configurations of the failed items.
         * </p>
         * 
         * @param failedItems
         *        Returns remediation configurations of the failed items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedItems(RemediationConfiguration... failedItems);

        /**
         * <p>
         * Returns remediation configurations of the failed items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.config.model.RemediationConfiguration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.config.model.RemediationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.config.model.RemediationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #failedItems(List<RemediationConfiguration>)}.
         * 
         * @param failedItems
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.config.model.RemediationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedItems(java.util.Collection<RemediationConfiguration>)
         */
        Builder failedItems(Consumer<RemediationConfiguration.Builder>... failedItems);
    }

    static final class BuilderImpl implements Builder {
        private String failureMessage;

        private List<RemediationConfiguration> failedItems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FailedRemediationBatch model) {
            failureMessage(model.failureMessage);
            failedItems(model.failedItems);
        }

        public final String getFailureMessage() {
            return failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final List<RemediationConfiguration.Builder> getFailedItems() {
            List<RemediationConfiguration.Builder> result = RemediationConfigurationsCopier.copyToBuilder(this.failedItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedItems(Collection<RemediationConfiguration.BuilderImpl> failedItems) {
            this.failedItems = RemediationConfigurationsCopier.copyFromBuilder(failedItems);
        }

        @Override
        public final Builder failedItems(Collection<RemediationConfiguration> failedItems) {
            this.failedItems = RemediationConfigurationsCopier.copy(failedItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedItems(RemediationConfiguration... failedItems) {
            failedItems(Arrays.asList(failedItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedItems(Consumer<RemediationConfiguration.Builder>... failedItems) {
            failedItems(Stream.of(failedItems).map(c -> RemediationConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public FailedRemediationBatch build() {
            return new FailedRemediationBatch(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
