/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the structure of actions and stages to be performed in the pipeline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipelineDeclaration implements SdkPojo, Serializable,
        ToCopyableBuilder<PipelineDeclaration.Builder, PipelineDeclaration> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(PipelineDeclaration::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(PipelineDeclaration::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<ArtifactStore> ARTIFACT_STORE_FIELD = SdkField
            .<ArtifactStore> builder(MarshallingType.SDK_POJO).memberName("artifactStore")
            .getter(getter(PipelineDeclaration::artifactStore)).setter(setter(Builder::artifactStore))
            .constructor(ArtifactStore::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifactStore").build()).build();

    private static final SdkField<Map<String, ArtifactStore>> ARTIFACT_STORES_FIELD = SdkField
            .<Map<String, ArtifactStore>> builder(MarshallingType.MAP)
            .memberName("artifactStores")
            .getter(getter(PipelineDeclaration::artifactStores))
            .setter(setter(Builder::artifactStores))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifactStores").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ArtifactStore> builder(MarshallingType.SDK_POJO)
                                            .constructor(ArtifactStore::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<StageDeclaration>> STAGES_FIELD = SdkField
            .<List<StageDeclaration>> builder(MarshallingType.LIST)
            .memberName("stages")
            .getter(getter(PipelineDeclaration::stages))
            .setter(setter(Builder::stages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StageDeclaration> builder(MarshallingType.SDK_POJO)
                                            .constructor(StageDeclaration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("version").getter(getter(PipelineDeclaration::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ROLE_ARN_FIELD,
            ARTIFACT_STORE_FIELD, ARTIFACT_STORES_FIELD, STAGES_FIELD, VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String roleArn;

    private final ArtifactStore artifactStore;

    private final Map<String, ArtifactStore> artifactStores;

    private final List<StageDeclaration> stages;

    private final Integer version;

    private PipelineDeclaration(BuilderImpl builder) {
        this.name = builder.name;
        this.roleArn = builder.roleArn;
        this.artifactStore = builder.artifactStore;
        this.artifactStores = builder.artifactStores;
        this.stages = builder.stages;
        this.version = builder.version;
    }

    /**
     * <p>
     * The name of the pipeline.
     * </p>
     * 
     * @return The name of the pipeline.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for CodePipeline to use to either perform actions with no
     * <code>actionRoleArn</code>, or to use to assume roles for actions with an <code>actionRoleArn</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for CodePipeline to use to either perform actions with no
     *         <code>actionRoleArn</code>, or to use to assume roles for actions with an <code>actionRoleArn</code>.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Represents information about the S3 bucket where artifacts are stored for the pipeline.
     * </p>
     * <note>
     * <p>
     * You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you
     * cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code>.
     * </p>
     * </note>
     * 
     * @return Represents information about the S3 bucket where artifacts are stored for the pipeline.</p> <note>
     *         <p>
     *         You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but
     *         you cannot use both. If you create a cross-region action in your pipeline, you must use
     *         <code>artifactStores</code>.
     *         </p>
     */
    public final ArtifactStore artifactStore() {
        return artifactStore;
    }

    /**
     * For responses, this returns true if the service returned a value for the ArtifactStores property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasArtifactStores() {
        return artifactStores != null && !(artifactStores instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A mapping of <code>artifactStore</code> objects and their corresponding Amazon Web Services Regions. There must
     * be an artifact store for the pipeline Region and for each cross-region action in the pipeline.
     * </p>
     * <note>
     * <p>
     * You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you
     * cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code>.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasArtifactStores} method.
     * </p>
     * 
     * @return A mapping of <code>artifactStore</code> objects and their corresponding Amazon Web Services Regions.
     *         There must be an artifact store for the pipeline Region and for each cross-region action in the
     *         pipeline.</p> <note>
     *         <p>
     *         You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but
     *         you cannot use both. If you create a cross-region action in your pipeline, you must use
     *         <code>artifactStores</code>.
     *         </p>
     */
    public final Map<String, ArtifactStore> artifactStores() {
        return artifactStores;
    }

    /**
     * For responses, this returns true if the service returned a value for the Stages property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStages() {
        return stages != null && !(stages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The stage in which to perform the action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStages} method.
     * </p>
     * 
     * @return The stage in which to perform the action.
     */
    public final List<StageDeclaration> stages() {
        return stages;
    }

    /**
     * <p>
     * The version number of the pipeline. A new pipeline always has a version number of 1. This number is incremented
     * when a pipeline is updated.
     * </p>
     * 
     * @return The version number of the pipeline. A new pipeline always has a version number of 1. This number is
     *         incremented when a pipeline is updated.
     */
    public final Integer version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(artifactStore());
        hashCode = 31 * hashCode + Objects.hashCode(hasArtifactStores() ? artifactStores() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStages() ? stages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineDeclaration)) {
            return false;
        }
        PipelineDeclaration other = (PipelineDeclaration) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(artifactStore(), other.artifactStore()) && hasArtifactStores() == other.hasArtifactStores()
                && Objects.equals(artifactStores(), other.artifactStores()) && hasStages() == other.hasStages()
                && Objects.equals(stages(), other.stages()) && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PipelineDeclaration").add("Name", name()).add("RoleArn", roleArn())
                .add("ArtifactStore", artifactStore()).add("ArtifactStores", hasArtifactStores() ? artifactStores() : null)
                .add("Stages", hasStages() ? stages() : null).add("Version", version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "artifactStore":
            return Optional.ofNullable(clazz.cast(artifactStore()));
        case "artifactStores":
            return Optional.ofNullable(clazz.cast(artifactStores()));
        case "stages":
            return Optional.ofNullable(clazz.cast(stages()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipelineDeclaration, T> g) {
        return obj -> g.apply((PipelineDeclaration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipelineDeclaration> {
        /**
         * <p>
         * The name of the pipeline.
         * </p>
         * 
         * @param name
         *        The name of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for CodePipeline to use to either perform actions with no
         * <code>actionRoleArn</code>, or to use to assume roles for actions with an <code>actionRoleArn</code>.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) for CodePipeline to use to either perform actions with no
         *        <code>actionRoleArn</code>, or to use to assume roles for actions with an <code>actionRoleArn</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Represents information about the S3 bucket where artifacts are stored for the pipeline.
         * </p>
         * <note>
         * <p>
         * You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you
         * cannot use both. If you create a cross-region action in your pipeline, you must use
         * <code>artifactStores</code>.
         * </p>
         * </note>
         * 
         * @param artifactStore
         *        Represents information about the S3 bucket where artifacts are stored for the pipeline.</p> <note>
         *        <p>
         *        You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline,
         *        but you cannot use both. If you create a cross-region action in your pipeline, you must use
         *        <code>artifactStores</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactStore(ArtifactStore artifactStore);

        /**
         * <p>
         * Represents information about the S3 bucket where artifacts are stored for the pipeline.
         * </p>
         * <note>
         * <p>
         * You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you
         * cannot use both. If you create a cross-region action in your pipeline, you must use
         * <code>artifactStores</code>.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link ArtifactStore.Builder} avoiding
         * the need to create one manually via {@link ArtifactStore#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ArtifactStore.Builder#build()} is called immediately and its
         * result is passed to {@link #artifactStore(ArtifactStore)}.
         * 
         * @param artifactStore
         *        a consumer that will call methods on {@link ArtifactStore.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #artifactStore(ArtifactStore)
         */
        default Builder artifactStore(Consumer<ArtifactStore.Builder> artifactStore) {
            return artifactStore(ArtifactStore.builder().applyMutation(artifactStore).build());
        }

        /**
         * <p>
         * A mapping of <code>artifactStore</code> objects and their corresponding Amazon Web Services Regions. There
         * must be an artifact store for the pipeline Region and for each cross-region action in the pipeline.
         * </p>
         * <note>
         * <p>
         * You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you
         * cannot use both. If you create a cross-region action in your pipeline, you must use
         * <code>artifactStores</code>.
         * </p>
         * </note>
         * 
         * @param artifactStores
         *        A mapping of <code>artifactStore</code> objects and their corresponding Amazon Web Services Regions.
         *        There must be an artifact store for the pipeline Region and for each cross-region action in the
         *        pipeline.</p> <note>
         *        <p>
         *        You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline,
         *        but you cannot use both. If you create a cross-region action in your pipeline, you must use
         *        <code>artifactStores</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactStores(Map<String, ArtifactStore> artifactStores);

        /**
         * <p>
         * The stage in which to perform the action.
         * </p>
         * 
         * @param stages
         *        The stage in which to perform the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stages(Collection<StageDeclaration> stages);

        /**
         * <p>
         * The stage in which to perform the action.
         * </p>
         * 
         * @param stages
         *        The stage in which to perform the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stages(StageDeclaration... stages);

        /**
         * <p>
         * The stage in which to perform the action.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codepipeline.model.StageDeclaration.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.codepipeline.model.StageDeclaration#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codepipeline.model.StageDeclaration.Builder#build()} is called
         * immediately and its result is passed to {@link #stages(List<StageDeclaration>)}.
         * 
         * @param stages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codepipeline.model.StageDeclaration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stages(java.util.Collection<StageDeclaration>)
         */
        Builder stages(Consumer<StageDeclaration.Builder>... stages);

        /**
         * <p>
         * The version number of the pipeline. A new pipeline always has a version number of 1. This number is
         * incremented when a pipeline is updated.
         * </p>
         * 
         * @param version
         *        The version number of the pipeline. A new pipeline always has a version number of 1. This number is
         *        incremented when a pipeline is updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Integer version);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String roleArn;

        private ArtifactStore artifactStore;

        private Map<String, ArtifactStore> artifactStores = DefaultSdkAutoConstructMap.getInstance();

        private List<StageDeclaration> stages = DefaultSdkAutoConstructList.getInstance();

        private Integer version;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineDeclaration model) {
            name(model.name);
            roleArn(model.roleArn);
            artifactStore(model.artifactStore);
            artifactStores(model.artifactStores);
            stages(model.stages);
            version(model.version);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final ArtifactStore.Builder getArtifactStore() {
            return artifactStore != null ? artifactStore.toBuilder() : null;
        }

        public final void setArtifactStore(ArtifactStore.BuilderImpl artifactStore) {
            this.artifactStore = artifactStore != null ? artifactStore.build() : null;
        }

        @Override
        public final Builder artifactStore(ArtifactStore artifactStore) {
            this.artifactStore = artifactStore;
            return this;
        }

        public final Map<String, ArtifactStore.Builder> getArtifactStores() {
            Map<String, ArtifactStore.Builder> result = ArtifactStoreMapCopier.copyToBuilder(this.artifactStores);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setArtifactStores(Map<String, ArtifactStore.BuilderImpl> artifactStores) {
            this.artifactStores = ArtifactStoreMapCopier.copyFromBuilder(artifactStores);
        }

        @Override
        public final Builder artifactStores(Map<String, ArtifactStore> artifactStores) {
            this.artifactStores = ArtifactStoreMapCopier.copy(artifactStores);
            return this;
        }

        public final List<StageDeclaration.Builder> getStages() {
            List<StageDeclaration.Builder> result = PipelineStageDeclarationListCopier.copyToBuilder(this.stages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStages(Collection<StageDeclaration.BuilderImpl> stages) {
            this.stages = PipelineStageDeclarationListCopier.copyFromBuilder(stages);
        }

        @Override
        public final Builder stages(Collection<StageDeclaration> stages) {
            this.stages = PipelineStageDeclarationListCopier.copy(stages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stages(StageDeclaration... stages) {
            stages(Arrays.asList(stages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stages(Consumer<StageDeclaration.Builder>... stages) {
            stages(Stream.of(stages).map(c -> StageDeclaration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getVersion() {
            return version;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        @Override
        public PipelineDeclaration build() {
            return new PipelineDeclaration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
