/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents information about the version (or revision) of an action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionRevision implements SdkPojo, Serializable, ToCopyableBuilder<ActionRevision.Builder, ActionRevision> {
    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("revisionId").getter(getter(ActionRevision::revisionId)).setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionId").build()).build();

    private static final SdkField<String> REVISION_CHANGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("revisionChangeId").getter(getter(ActionRevision::revisionChangeId))
            .setter(setter(Builder::revisionChangeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionChangeId").build()).build();

    private static final SdkField<Instant> CREATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("created").getter(getter(ActionRevision::created)).setter(setter(Builder::created))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REVISION_ID_FIELD,
            REVISION_CHANGE_ID_FIELD, CREATED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String revisionId;

    private final String revisionChangeId;

    private final Instant created;

    private ActionRevision(BuilderImpl builder) {
        this.revisionId = builder.revisionId;
        this.revisionChangeId = builder.revisionChangeId;
        this.created = builder.created;
    }

    /**
     * <p>
     * The system-generated unique ID that identifies the revision number of the action.
     * </p>
     * 
     * @return The system-generated unique ID that identifies the revision number of the action.
     */
    public final String revisionId() {
        return revisionId;
    }

    /**
     * <p>
     * The unique identifier of the change that set the state to this revision (for example, a deployment ID or
     * timestamp).
     * </p>
     * 
     * @return The unique identifier of the change that set the state to this revision (for example, a deployment ID or
     *         timestamp).
     */
    public final String revisionChangeId() {
        return revisionChangeId;
    }

    /**
     * <p>
     * The date and time when the most recent version of the action was created, in timestamp format.
     * </p>
     * 
     * @return The date and time when the most recent version of the action was created, in timestamp format.
     */
    public final Instant created() {
        return created;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(revisionChangeId());
        hashCode = 31 * hashCode + Objects.hashCode(created());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionRevision)) {
            return false;
        }
        ActionRevision other = (ActionRevision) obj;
        return Objects.equals(revisionId(), other.revisionId()) && Objects.equals(revisionChangeId(), other.revisionChangeId())
                && Objects.equals(created(), other.created());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActionRevision").add("RevisionId", revisionId()).add("RevisionChangeId", revisionChangeId())
                .add("Created", created()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "revisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        case "revisionChangeId":
            return Optional.ofNullable(clazz.cast(revisionChangeId()));
        case "created":
            return Optional.ofNullable(clazz.cast(created()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActionRevision, T> g) {
        return obj -> g.apply((ActionRevision) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionRevision> {
        /**
         * <p>
         * The system-generated unique ID that identifies the revision number of the action.
         * </p>
         * 
         * @param revisionId
         *        The system-generated unique ID that identifies the revision number of the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);

        /**
         * <p>
         * The unique identifier of the change that set the state to this revision (for example, a deployment ID or
         * timestamp).
         * </p>
         * 
         * @param revisionChangeId
         *        The unique identifier of the change that set the state to this revision (for example, a deployment ID
         *        or timestamp).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionChangeId(String revisionChangeId);

        /**
         * <p>
         * The date and time when the most recent version of the action was created, in timestamp format.
         * </p>
         * 
         * @param created
         *        The date and time when the most recent version of the action was created, in timestamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Instant created);
    }

    static final class BuilderImpl implements Builder {
        private String revisionId;

        private String revisionChangeId;

        private Instant created;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionRevision model) {
            revisionId(model.revisionId);
            revisionChangeId(model.revisionChangeId);
            created(model.created);
        }

        public final String getRevisionId() {
            return revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final String getRevisionChangeId() {
            return revisionChangeId;
        }

        public final void setRevisionChangeId(String revisionChangeId) {
            this.revisionChangeId = revisionChangeId;
        }

        @Override
        public final Builder revisionChangeId(String revisionChangeId) {
            this.revisionChangeId = revisionChangeId;
            return this;
        }

        public final Instant getCreated() {
            return created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        @Override
        public ActionRevision build() {
            return new ActionRevision(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
