/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Metadata about the pull request that is used when comparing the pull request source with its destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PullRequestCreatedEventMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<PullRequestCreatedEventMetadata.Builder, PullRequestCreatedEventMetadata> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(PullRequestCreatedEventMetadata::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<String> SOURCE_COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceCommitId").getter(getter(PullRequestCreatedEventMetadata::sourceCommitId))
            .setter(setter(Builder::sourceCommitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCommitId").build()).build();

    private static final SdkField<String> DESTINATION_COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationCommitId").getter(getter(PullRequestCreatedEventMetadata::destinationCommitId))
            .setter(setter(Builder::destinationCommitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationCommitId").build())
            .build();

    private static final SdkField<String> MERGE_BASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mergeBase").getter(getter(PullRequestCreatedEventMetadata::mergeBase))
            .setter(setter(Builder::mergeBase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeBase").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD,
            SOURCE_COMMIT_ID_FIELD, DESTINATION_COMMIT_ID_FIELD, MERGE_BASE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String repositoryName;

    private final String sourceCommitId;

    private final String destinationCommitId;

    private final String mergeBase;

    private PullRequestCreatedEventMetadata(BuilderImpl builder) {
        this.repositoryName = builder.repositoryName;
        this.sourceCommitId = builder.sourceCommitId;
        this.destinationCommitId = builder.destinationCommitId;
        this.mergeBase = builder.mergeBase;
    }

    /**
     * <p>
     * The name of the repository where the pull request was created.
     * </p>
     * 
     * @return The name of the repository where the pull request was created.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * The commit ID on the source branch used when the pull request was created.
     * </p>
     * 
     * @return The commit ID on the source branch used when the pull request was created.
     */
    public final String sourceCommitId() {
        return sourceCommitId;
    }

    /**
     * <p>
     * The commit ID of the tip of the branch specified as the destination branch when the pull request was created.
     * </p>
     * 
     * @return The commit ID of the tip of the branch specified as the destination branch when the pull request was
     *         created.
     */
    public final String destinationCommitId() {
        return destinationCommitId;
    }

    /**
     * <p>
     * The commit ID of the most recent commit that the source branch and the destination branch have in common.
     * </p>
     * 
     * @return The commit ID of the most recent commit that the source branch and the destination branch have in common.
     */
    public final String mergeBase() {
        return mergeBase;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(destinationCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(mergeBase());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PullRequestCreatedEventMetadata)) {
            return false;
        }
        PullRequestCreatedEventMetadata other = (PullRequestCreatedEventMetadata) obj;
        return Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(sourceCommitId(), other.sourceCommitId())
                && Objects.equals(destinationCommitId(), other.destinationCommitId())
                && Objects.equals(mergeBase(), other.mergeBase());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PullRequestCreatedEventMetadata").add("RepositoryName", repositoryName())
                .add("SourceCommitId", sourceCommitId()).add("DestinationCommitId", destinationCommitId())
                .add("MergeBase", mergeBase()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "sourceCommitId":
            return Optional.ofNullable(clazz.cast(sourceCommitId()));
        case "destinationCommitId":
            return Optional.ofNullable(clazz.cast(destinationCommitId()));
        case "mergeBase":
            return Optional.ofNullable(clazz.cast(mergeBase()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PullRequestCreatedEventMetadata, T> g) {
        return obj -> g.apply((PullRequestCreatedEventMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PullRequestCreatedEventMetadata> {
        /**
         * <p>
         * The name of the repository where the pull request was created.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository where the pull request was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The commit ID on the source branch used when the pull request was created.
         * </p>
         * 
         * @param sourceCommitId
         *        The commit ID on the source branch used when the pull request was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCommitId(String sourceCommitId);

        /**
         * <p>
         * The commit ID of the tip of the branch specified as the destination branch when the pull request was created.
         * </p>
         * 
         * @param destinationCommitId
         *        The commit ID of the tip of the branch specified as the destination branch when the pull request was
         *        created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCommitId(String destinationCommitId);

        /**
         * <p>
         * The commit ID of the most recent commit that the source branch and the destination branch have in common.
         * </p>
         * 
         * @param mergeBase
         *        The commit ID of the most recent commit that the source branch and the destination branch have in
         *        common.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mergeBase(String mergeBase);
    }

    static final class BuilderImpl implements Builder {
        private String repositoryName;

        private String sourceCommitId;

        private String destinationCommitId;

        private String mergeBase;

        private BuilderImpl() {
        }

        private BuilderImpl(PullRequestCreatedEventMetadata model) {
            repositoryName(model.repositoryName);
            sourceCommitId(model.sourceCommitId);
            destinationCommitId(model.destinationCommitId);
            mergeBase(model.mergeBase);
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getSourceCommitId() {
            return sourceCommitId;
        }

        public final void setSourceCommitId(String sourceCommitId) {
            this.sourceCommitId = sourceCommitId;
        }

        @Override
        public final Builder sourceCommitId(String sourceCommitId) {
            this.sourceCommitId = sourceCommitId;
            return this;
        }

        public final String getDestinationCommitId() {
            return destinationCommitId;
        }

        public final void setDestinationCommitId(String destinationCommitId) {
            this.destinationCommitId = destinationCommitId;
        }

        @Override
        public final Builder destinationCommitId(String destinationCommitId) {
            this.destinationCommitId = destinationCommitId;
            return this;
        }

        public final String getMergeBase() {
            return mergeBase;
        }

        public final void setMergeBase(String mergeBase) {
            this.mergeBase = mergeBase;
        }

        @Override
        public final Builder mergeBase(String mergeBase) {
            this.mergeBase = mergeBase;
            return this;
        }

        @Override
        public PullRequestCreatedEventMetadata build() {
            return new PullRequestCreatedEventMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
