/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <fullname>CodeBuild</fullname>
 * <p>
 * CodeBuild is a fully managed build service in the cloud. CodeBuild compiles your source code, runs unit tests, and
 * produces artifacts that are ready to deploy. CodeBuild eliminates the need to provision, manage, and scale your own
 * build servers. It provides prepackaged build environments for the most popular programming languages and build tools,
 * such as Apache Maven, Gradle, and more. You can also fully customize build environments in CodeBuild to use your own
 * build tools. CodeBuild scales automatically to meet peak build requests. You pay only for the build time you consume.
 * For more information about CodeBuild, see the <i> <a
 * href="https://docs.aws.amazon.com/codebuild/latest/userguide/welcome.html">CodeBuild User Guide</a>.</i>
 * </p>
 */
package software.amazon.awssdk.services.codebuild;