/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutAccountPolicyResponse extends CloudWatchLogsResponse implements
        ToCopyableBuilder<PutAccountPolicyResponse.Builder, PutAccountPolicyResponse> {
    private static final SdkField<AccountPolicy> ACCOUNT_POLICY_FIELD = SdkField
            .<AccountPolicy> builder(MarshallingType.SDK_POJO).memberName("accountPolicy")
            .getter(getter(PutAccountPolicyResponse::accountPolicy)).setter(setter(Builder::accountPolicy))
            .constructor(AccountPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_POLICY_FIELD));

    private final AccountPolicy accountPolicy;

    private PutAccountPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.accountPolicy = builder.accountPolicy;
    }

    /**
     * <p>
     * The account policy that you created.
     * </p>
     * 
     * @return The account policy that you created.
     */
    public final AccountPolicy accountPolicy() {
        return accountPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAccountPolicyResponse)) {
            return false;
        }
        PutAccountPolicyResponse other = (PutAccountPolicyResponse) obj;
        return Objects.equals(accountPolicy(), other.accountPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutAccountPolicyResponse").add("AccountPolicy", accountPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountPolicy":
            return Optional.ofNullable(clazz.cast(accountPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutAccountPolicyResponse, T> g) {
        return obj -> g.apply((PutAccountPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutAccountPolicyResponse> {
        /**
         * <p>
         * The account policy that you created.
         * </p>
         * 
         * @param accountPolicy
         *        The account policy that you created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountPolicy(AccountPolicy accountPolicy);

        /**
         * <p>
         * The account policy that you created.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccountPolicy.Builder} avoiding the need
         * to create one manually via {@link AccountPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccountPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #accountPolicy(AccountPolicy)}.
         * 
         * @param accountPolicy
         *        a consumer that will call methods on {@link AccountPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountPolicy(AccountPolicy)
         */
        default Builder accountPolicy(Consumer<AccountPolicy.Builder> accountPolicy) {
            return accountPolicy(AccountPolicy.builder().applyMutation(accountPolicy).build());
        }
    }

    static final class BuilderImpl extends CloudWatchLogsResponse.BuilderImpl implements Builder {
        private AccountPolicy accountPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAccountPolicyResponse model) {
            super(model);
            accountPolicy(model.accountPolicy);
        }

        public final AccountPolicy.Builder getAccountPolicy() {
            return accountPolicy != null ? accountPolicy.toBuilder() : null;
        }

        public final void setAccountPolicy(AccountPolicy.BuilderImpl accountPolicy) {
            this.accountPolicy = accountPolicy != null ? accountPolicy.build() : null;
        }

        @Override
        public final Builder accountPolicy(AccountPolicy accountPolicy) {
            this.accountPolicy = accountPolicy;
            return this;
        }

        @Override
        public PutAccountPolicyResponse build() {
            return new PutAccountPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
