/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAccountPoliciesRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<DescribeAccountPoliciesRequest.Builder, DescribeAccountPoliciesRequest> {
    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyType").getter(getter(DescribeAccountPoliciesRequest::policyTypeAsString))
            .setter(setter(Builder::policyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyType").build()).build();

    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyName").getter(getter(DescribeAccountPoliciesRequest::policyName))
            .setter(setter(Builder::policyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyName").build()).build();

    private static final SdkField<List<String>> ACCOUNT_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("accountIdentifiers")
            .getter(getter(DescribeAccountPoliciesRequest::accountIdentifiers))
            .setter(setter(Builder::accountIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_TYPE_FIELD,
            POLICY_NAME_FIELD, ACCOUNT_IDENTIFIERS_FIELD));

    private final String policyType;

    private final String policyName;

    private final List<String> accountIdentifiers;

    private DescribeAccountPoliciesRequest(BuilderImpl builder) {
        super(builder);
        this.policyType = builder.policyType;
        this.policyName = builder.policyName;
        this.accountIdentifiers = builder.accountIdentifiers;
    }

    /**
     * <p>
     * Use this parameter to limit the returned policies to only the policies that match the policy type that you
     * specify. Currently, the only valid value is <code>DATA_PROTECTION_POLICY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link PolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #policyTypeAsString}.
     * </p>
     * 
     * @return Use this parameter to limit the returned policies to only the policies that match the policy type that
     *         you specify. Currently, the only valid value is <code>DATA_PROTECTION_POLICY</code>.
     * @see PolicyType
     */
    public final PolicyType policyType() {
        return PolicyType.fromValue(policyType);
    }

    /**
     * <p>
     * Use this parameter to limit the returned policies to only the policies that match the policy type that you
     * specify. Currently, the only valid value is <code>DATA_PROTECTION_POLICY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link PolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #policyTypeAsString}.
     * </p>
     * 
     * @return Use this parameter to limit the returned policies to only the policies that match the policy type that
     *         you specify. Currently, the only valid value is <code>DATA_PROTECTION_POLICY</code>.
     * @see PolicyType
     */
    public final String policyTypeAsString() {
        return policyType;
    }

    /**
     * <p>
     * Use this parameter to limit the returned policies to only the policy with the name that you specify.
     * </p>
     * 
     * @return Use this parameter to limit the returned policies to only the policy with the name that you specify.
     */
    public final String policyName() {
        return policyName;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountIdentifiers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAccountIdentifiers() {
        return accountIdentifiers != null && !(accountIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If you are using an account that is set up as a monitoring account for CloudWatch unified cross-account
     * observability, you can use this to specify the account ID of a source account. If you do, the operation returns
     * the account policy for the specified account. Currently, you can specify only one account ID in this parameter.
     * </p>
     * <p>
     * If you omit this parameter, only the policy in the current account is returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountIdentifiers} method.
     * </p>
     * 
     * @return If you are using an account that is set up as a monitoring account for CloudWatch unified cross-account
     *         observability, you can use this to specify the account ID of a source account. If you do, the operation
     *         returns the account policy for the specified account. Currently, you can specify only one account ID in
     *         this parameter.</p>
     *         <p>
     *         If you omit this parameter, only the policy in the current account is returned.
     */
    public final List<String> accountIdentifiers() {
        return accountIdentifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountIdentifiers() ? accountIdentifiers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountPoliciesRequest)) {
            return false;
        }
        DescribeAccountPoliciesRequest other = (DescribeAccountPoliciesRequest) obj;
        return Objects.equals(policyTypeAsString(), other.policyTypeAsString())
                && Objects.equals(policyName(), other.policyName()) && hasAccountIdentifiers() == other.hasAccountIdentifiers()
                && Objects.equals(accountIdentifiers(), other.accountIdentifiers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAccountPoliciesRequest").add("PolicyType", policyTypeAsString())
                .add("PolicyName", policyName()).add("AccountIdentifiers", hasAccountIdentifiers() ? accountIdentifiers() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyType":
            return Optional.ofNullable(clazz.cast(policyTypeAsString()));
        case "policyName":
            return Optional.ofNullable(clazz.cast(policyName()));
        case "accountIdentifiers":
            return Optional.ofNullable(clazz.cast(accountIdentifiers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccountPoliciesRequest, T> g) {
        return obj -> g.apply((DescribeAccountPoliciesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAccountPoliciesRequest> {
        /**
         * <p>
         * Use this parameter to limit the returned policies to only the policies that match the policy type that you
         * specify. Currently, the only valid value is <code>DATA_PROTECTION_POLICY</code>.
         * </p>
         * 
         * @param policyType
         *        Use this parameter to limit the returned policies to only the policies that match the policy type that
         *        you specify. Currently, the only valid value is <code>DATA_PROTECTION_POLICY</code>.
         * @see PolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyType
         */
        Builder policyType(String policyType);

        /**
         * <p>
         * Use this parameter to limit the returned policies to only the policies that match the policy type that you
         * specify. Currently, the only valid value is <code>DATA_PROTECTION_POLICY</code>.
         * </p>
         * 
         * @param policyType
         *        Use this parameter to limit the returned policies to only the policies that match the policy type that
         *        you specify. Currently, the only valid value is <code>DATA_PROTECTION_POLICY</code>.
         * @see PolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyType
         */
        Builder policyType(PolicyType policyType);

        /**
         * <p>
         * Use this parameter to limit the returned policies to only the policy with the name that you specify.
         * </p>
         * 
         * @param policyName
         *        Use this parameter to limit the returned policies to only the policy with the name that you specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * If you are using an account that is set up as a monitoring account for CloudWatch unified cross-account
         * observability, you can use this to specify the account ID of a source account. If you do, the operation
         * returns the account policy for the specified account. Currently, you can specify only one account ID in this
         * parameter.
         * </p>
         * <p>
         * If you omit this parameter, only the policy in the current account is returned.
         * </p>
         * 
         * @param accountIdentifiers
         *        If you are using an account that is set up as a monitoring account for CloudWatch unified
         *        cross-account observability, you can use this to specify the account ID of a source account. If you
         *        do, the operation returns the account policy for the specified account. Currently, you can specify
         *        only one account ID in this parameter.</p>
         *        <p>
         *        If you omit this parameter, only the policy in the current account is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIdentifiers(Collection<String> accountIdentifiers);

        /**
         * <p>
         * If you are using an account that is set up as a monitoring account for CloudWatch unified cross-account
         * observability, you can use this to specify the account ID of a source account. If you do, the operation
         * returns the account policy for the specified account. Currently, you can specify only one account ID in this
         * parameter.
         * </p>
         * <p>
         * If you omit this parameter, only the policy in the current account is returned.
         * </p>
         * 
         * @param accountIdentifiers
         *        If you are using an account that is set up as a monitoring account for CloudWatch unified
         *        cross-account observability, you can use this to specify the account ID of a source account. If you
         *        do, the operation returns the account policy for the specified account. Currently, you can specify
         *        only one account ID in this parameter.</p>
         *        <p>
         *        If you omit this parameter, only the policy in the current account is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIdentifiers(String... accountIdentifiers);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private String policyType;

        private String policyName;

        private List<String> accountIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountPoliciesRequest model) {
            super(model);
            policyType(model.policyType);
            policyName(model.policyName);
            accountIdentifiers(model.accountIdentifiers);
        }

        public final String getPolicyType() {
            return policyType;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(PolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        public final String getPolicyName() {
            return policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final Collection<String> getAccountIdentifiers() {
            if (accountIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return accountIdentifiers;
        }

        public final void setAccountIdentifiers(Collection<String> accountIdentifiers) {
            this.accountIdentifiers = AccountIdsCopier.copy(accountIdentifiers);
        }

        @Override
        public final Builder accountIdentifiers(Collection<String> accountIdentifiers) {
            this.accountIdentifiers = AccountIdsCopier.copy(accountIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIdentifiers(String... accountIdentifiers) {
            accountIdentifiers(Arrays.asList(accountIdentifiers));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAccountPoliciesRequest build() {
            return new DescribeAccountPoliciesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
