/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudhsmv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyClusterRequest extends CloudHsmV2Request implements
        ToCopyableBuilder<ModifyClusterRequest.Builder, ModifyClusterRequest> {
    private static final SdkField<BackupRetentionPolicy> BACKUP_RETENTION_POLICY_FIELD = SdkField
            .<BackupRetentionPolicy> builder(MarshallingType.SDK_POJO).memberName("BackupRetentionPolicy")
            .getter(getter(ModifyClusterRequest::backupRetentionPolicy)).setter(setter(Builder::backupRetentionPolicy))
            .constructor(BackupRetentionPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRetentionPolicy").build())
            .build();

    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterId").getter(getter(ModifyClusterRequest::clusterId)).setter(setter(Builder::clusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_RETENTION_POLICY_FIELD,
            CLUSTER_ID_FIELD));

    private final BackupRetentionPolicy backupRetentionPolicy;

    private final String clusterId;

    private ModifyClusterRequest(BuilderImpl builder) {
        super(builder);
        this.backupRetentionPolicy = builder.backupRetentionPolicy;
        this.clusterId = builder.clusterId;
    }

    /**
     * <p>
     * A policy that defines how the service retains backups.
     * </p>
     * 
     * @return A policy that defines how the service retains backups.
     */
    public final BackupRetentionPolicy backupRetentionPolicy() {
        return backupRetentionPolicy;
    }

    /**
     * <p>
     * The identifier (ID) of the cluster that you want to modify. To find the cluster ID, use <a>DescribeClusters</a>.
     * </p>
     * 
     * @return The identifier (ID) of the cluster that you want to modify. To find the cluster ID, use
     *         <a>DescribeClusters</a>.
     */
    public final String clusterId() {
        return clusterId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backupRetentionPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(clusterId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyClusterRequest)) {
            return false;
        }
        ModifyClusterRequest other = (ModifyClusterRequest) obj;
        return Objects.equals(backupRetentionPolicy(), other.backupRetentionPolicy())
                && Objects.equals(clusterId(), other.clusterId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyClusterRequest").add("BackupRetentionPolicy", backupRetentionPolicy())
                .add("ClusterId", clusterId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupRetentionPolicy":
            return Optional.ofNullable(clazz.cast(backupRetentionPolicy()));
        case "ClusterId":
            return Optional.ofNullable(clazz.cast(clusterId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyClusterRequest, T> g) {
        return obj -> g.apply((ModifyClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudHsmV2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyClusterRequest> {
        /**
         * <p>
         * A policy that defines how the service retains backups.
         * </p>
         * 
         * @param backupRetentionPolicy
         *        A policy that defines how the service retains backups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupRetentionPolicy(BackupRetentionPolicy backupRetentionPolicy);

        /**
         * <p>
         * A policy that defines how the service retains backups.
         * </p>
         * This is a convenience method that creates an instance of the {@link BackupRetentionPolicy.Builder} avoiding
         * the need to create one manually via {@link BackupRetentionPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BackupRetentionPolicy.Builder#build()} is called immediately and
         * its result is passed to {@link #backupRetentionPolicy(BackupRetentionPolicy)}.
         * 
         * @param backupRetentionPolicy
         *        a consumer that will call methods on {@link BackupRetentionPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #backupRetentionPolicy(BackupRetentionPolicy)
         */
        default Builder backupRetentionPolicy(Consumer<BackupRetentionPolicy.Builder> backupRetentionPolicy) {
            return backupRetentionPolicy(BackupRetentionPolicy.builder().applyMutation(backupRetentionPolicy).build());
        }

        /**
         * <p>
         * The identifier (ID) of the cluster that you want to modify. To find the cluster ID, use
         * <a>DescribeClusters</a>.
         * </p>
         * 
         * @param clusterId
         *        The identifier (ID) of the cluster that you want to modify. To find the cluster ID, use
         *        <a>DescribeClusters</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudHsmV2Request.BuilderImpl implements Builder {
        private BackupRetentionPolicy backupRetentionPolicy;

        private String clusterId;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyClusterRequest model) {
            super(model);
            backupRetentionPolicy(model.backupRetentionPolicy);
            clusterId(model.clusterId);
        }

        public final BackupRetentionPolicy.Builder getBackupRetentionPolicy() {
            return backupRetentionPolicy != null ? backupRetentionPolicy.toBuilder() : null;
        }

        public final void setBackupRetentionPolicy(BackupRetentionPolicy.BuilderImpl backupRetentionPolicy) {
            this.backupRetentionPolicy = backupRetentionPolicy != null ? backupRetentionPolicy.build() : null;
        }

        @Override
        public final Builder backupRetentionPolicy(BackupRetentionPolicy backupRetentionPolicy) {
            this.backupRetentionPolicy = backupRetentionPolicy;
            return this;
        }

        public final String getClusterId() {
            return clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyClusterRequest build() {
            return new ModifyClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
