/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudhsmv2.internal;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.http.auth.spi.scheme.AuthScheme;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeProvider;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.identity.spi.IdentityProviders;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudhsmv2.CloudHsmV2ServiceClientConfiguration;
import software.amazon.awssdk.services.cloudhsmv2.auth.scheme.CloudHsmV2AuthSchemeProvider;
import software.amazon.awssdk.utils.Validate;

@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class CloudHsmV2ServiceClientConfigurationBuilder {
    public static CloudHsmV2ServiceClientConfiguration.Builder builder() {
        return new BuilderImpl();
    }

    public static BuilderInternal builder(SdkClientConfiguration.Builder builder) {
        return new BuilderImpl(builder);
    }

    public interface BuilderInternal extends CloudHsmV2ServiceClientConfiguration.Builder {
        SdkClientConfiguration buildSdkClientConfiguration();
    }

    public static class BuilderImpl implements BuilderInternal {
        private final SdkClientConfiguration.Builder internalBuilder;

        private ClientOverrideConfiguration overrideConfiguration;

        private URI endpointOverride;

        private IdentityProvider<? extends AwsCredentialsIdentity> credentialsProvider;

        private Map<String, AuthScheme<?>> authSchemes;

        private BuilderImpl() {
            this.internalBuilder = SdkClientConfiguration.builder();
        }

        private BuilderImpl(SdkClientConfiguration.Builder internalBuilder) {
            this.internalBuilder = internalBuilder;
            if (Boolean.TRUE.equals(internalBuilder.option(SdkClientOption.ENDPOINT_OVERRIDDEN))) {
                this.endpointOverride = internalBuilder.option(SdkClientOption.ENDPOINT);
            }
            this.credentialsProvider = internalBuilder.option(AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER);
            Map<String, AuthScheme<?>> authSchemes = internalBuilder.option(SdkClientOption.AUTH_SCHEMES);
            if (authSchemes != null) {
                authSchemes = new HashMap<>(authSchemes);
            }
            this.authSchemes = authSchemes;
        }

        /**
         * Sets the value for client override configuration
         */
        @Override
        public CloudHsmV2ServiceClientConfiguration.Builder overrideConfiguration(
                ClientOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        /**
         * Gets the value for client override configuration
         */
        @Override
        public ClientOverrideConfiguration overrideConfiguration() {
            return overrideConfiguration;
        }

        /**
         * Sets the value for endpoint override
         */
        @Override
        public CloudHsmV2ServiceClientConfiguration.Builder endpointOverride(URI endpointOverride) {
            this.endpointOverride = endpointOverride;
            return this;
        }

        /**
         * Gets the value for endpoint override
         */
        @Override
        public URI endpointOverride() {
            return endpointOverride;
        }

        /**
         * Sets the value for endpoint provider
         */
        @Override
        public CloudHsmV2ServiceClientConfiguration.Builder endpointProvider(EndpointProvider endpointProvider) {
            internalBuilder.option(SdkClientOption.ENDPOINT_PROVIDER, endpointProvider);
            return this;
        }

        /**
         * Gets the value for endpoint provider
         */
        @Override
        public EndpointProvider endpointProvider() {
            return internalBuilder.option(SdkClientOption.ENDPOINT_PROVIDER);
        }

        /**
         * Sets the value for AWS region
         */
        @Override
        public CloudHsmV2ServiceClientConfiguration.Builder region(Region region) {
            internalBuilder.option(AwsClientOption.AWS_REGION, region);
            return this;
        }

        /**
         * Gets the value for AWS region
         */
        @Override
        public Region region() {
            return internalBuilder.option(AwsClientOption.AWS_REGION);
        }

        /**
         * Sets the value for credentials provider
         */
        @Override
        public CloudHsmV2ServiceClientConfiguration.Builder credentialsProvider(
                IdentityProvider<? extends AwsCredentialsIdentity> credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        /**
         * Gets the value for credentials provider
         */
        @Override
        public IdentityProvider<? extends AwsCredentialsIdentity> credentialsProvider() {
            return credentialsProvider;
        }

        @Override
        public CloudHsmV2ServiceClientConfiguration.Builder putAuthScheme(AuthScheme<?> authScheme) {
            if (authSchemes == null) {
                authSchemes = new HashMap<>();
            }
            authSchemes.put(authScheme.schemeId(), authScheme);
            return this;
        }

        @Override
        public Map<String, AuthScheme<?>> authSchemes() {
            if (authSchemes == null) {
                return Collections.emptyMap();
            }
            return Collections.unmodifiableMap(new HashMap<>(authSchemes));
        }

        /**
         * Sets the value for auth scheme provider
         */
        @Override
        public CloudHsmV2ServiceClientConfiguration.Builder authSchemeProvider(CloudHsmV2AuthSchemeProvider authSchemeProvider) {
            internalBuilder.option(SdkClientOption.AUTH_SCHEME_PROVIDER, authSchemeProvider);
            return this;
        }

        /**
         * Gets the value for auth scheme provider
         */
        @Override
        public CloudHsmV2AuthSchemeProvider authSchemeProvider() {
            AuthSchemeProvider result = internalBuilder.option(SdkClientOption.AUTH_SCHEME_PROVIDER);
            if (result == null) {
                return null;
            }
            return Validate.isInstanceOf(CloudHsmV2AuthSchemeProvider.class, result, "Expected an instance of "
                    + CloudHsmV2AuthSchemeProvider.class.getSimpleName());
        }

        @Override
        public CloudHsmV2ServiceClientConfiguration build() {
            return new CloudHsmV2ServiceClientConfiguration(this);
        }

        @Override
        public SdkClientConfiguration buildSdkClientConfiguration() {
            if (overrideConfiguration != null) {
                SdkClientConfigurationUtil.copyOverridesToConfiguration(overrideConfiguration, internalBuilder);
            }
            if (endpointOverride != null) {
                internalBuilder.option(SdkClientOption.ENDPOINT, endpointOverride);
                internalBuilder.option(SdkClientOption.ENDPOINT_OVERRIDDEN, true);
            }
            if (credentialsProvider != null
                    && !credentialsProvider.equals(internalBuilder.option(AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER))) {
                internalBuilder.option(AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER, credentialsProvider);
                IdentityProviders identityProviders = internalBuilder.option(SdkClientOption.IDENTITY_PROVIDERS);
                if (identityProviders == null) {
                    identityProviders = IdentityProviders.builder().putIdentityProvider(credentialsProvider).build();
                } else {
                    identityProviders = identityProviders.toBuilder().putIdentityProvider(credentialsProvider).build();
                }
                internalBuilder.option(SdkClientOption.IDENTITY_PROVIDERS, identityProviders);
            }
            if (authSchemes != null && !authSchemes.equals(internalBuilder.option(SdkClientOption.AUTH_SCHEMES))) {
                internalBuilder.option(SdkClientOption.AUTH_SCHEMES, authSchemes());
            }
            return internalBuilder.build();
        }
    }
}
