/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Attaches the specified object to the specified index inside a <a>BatchRead</a> operation. For more information, see
 * <a>AttachToIndex</a> and <a>BatchReadRequest$Operations</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchAttachToIndex implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchAttachToIndex.Builder, BatchAttachToIndex> {
    private static final SdkField<ObjectReference> INDEX_REFERENCE_FIELD = SdkField
            .<ObjectReference> builder(MarshallingType.SDK_POJO).memberName("IndexReference")
            .getter(getter(BatchAttachToIndex::indexReference)).setter(setter(Builder::indexReference))
            .constructor(ObjectReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexReference").build()).build();

    private static final SdkField<ObjectReference> TARGET_REFERENCE_FIELD = SdkField
            .<ObjectReference> builder(MarshallingType.SDK_POJO).memberName("TargetReference")
            .getter(getter(BatchAttachToIndex::targetReference)).setter(setter(Builder::targetReference))
            .constructor(ObjectReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetReference").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_REFERENCE_FIELD,
            TARGET_REFERENCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final ObjectReference indexReference;

    private final ObjectReference targetReference;

    private BatchAttachToIndex(BuilderImpl builder) {
        this.indexReference = builder.indexReference;
        this.targetReference = builder.targetReference;
    }

    /**
     * <p>
     * A reference to the index that you are attaching the object to.
     * </p>
     * 
     * @return A reference to the index that you are attaching the object to.
     */
    public final ObjectReference indexReference() {
        return indexReference;
    }

    /**
     * <p>
     * A reference to the object that you are attaching to the index.
     * </p>
     * 
     * @return A reference to the object that you are attaching to the index.
     */
    public final ObjectReference targetReference() {
        return targetReference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(indexReference());
        hashCode = 31 * hashCode + Objects.hashCode(targetReference());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAttachToIndex)) {
            return false;
        }
        BatchAttachToIndex other = (BatchAttachToIndex) obj;
        return Objects.equals(indexReference(), other.indexReference())
                && Objects.equals(targetReference(), other.targetReference());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchAttachToIndex").add("IndexReference", indexReference())
                .add("TargetReference", targetReference()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexReference":
            return Optional.ofNullable(clazz.cast(indexReference()));
        case "TargetReference":
            return Optional.ofNullable(clazz.cast(targetReference()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchAttachToIndex, T> g) {
        return obj -> g.apply((BatchAttachToIndex) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchAttachToIndex> {
        /**
         * <p>
         * A reference to the index that you are attaching the object to.
         * </p>
         * 
         * @param indexReference
         *        A reference to the index that you are attaching the object to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexReference(ObjectReference indexReference);

        /**
         * <p>
         * A reference to the index that you are attaching the object to.
         * </p>
         * This is a convenience method that creates an instance of the {@link ObjectReference.Builder} avoiding the
         * need to create one manually via {@link ObjectReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ObjectReference.Builder#build()} is called immediately and its
         * result is passed to {@link #indexReference(ObjectReference)}.
         * 
         * @param indexReference
         *        a consumer that will call methods on {@link ObjectReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #indexReference(ObjectReference)
         */
        default Builder indexReference(Consumer<ObjectReference.Builder> indexReference) {
            return indexReference(ObjectReference.builder().applyMutation(indexReference).build());
        }

        /**
         * <p>
         * A reference to the object that you are attaching to the index.
         * </p>
         * 
         * @param targetReference
         *        A reference to the object that you are attaching to the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetReference(ObjectReference targetReference);

        /**
         * <p>
         * A reference to the object that you are attaching to the index.
         * </p>
         * This is a convenience method that creates an instance of the {@link ObjectReference.Builder} avoiding the
         * need to create one manually via {@link ObjectReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ObjectReference.Builder#build()} is called immediately and its
         * result is passed to {@link #targetReference(ObjectReference)}.
         * 
         * @param targetReference
         *        a consumer that will call methods on {@link ObjectReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetReference(ObjectReference)
         */
        default Builder targetReference(Consumer<ObjectReference.Builder> targetReference) {
            return targetReference(ObjectReference.builder().applyMutation(targetReference).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ObjectReference indexReference;

        private ObjectReference targetReference;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAttachToIndex model) {
            indexReference(model.indexReference);
            targetReference(model.targetReference);
        }

        public final ObjectReference.Builder getIndexReference() {
            return indexReference != null ? indexReference.toBuilder() : null;
        }

        public final void setIndexReference(ObjectReference.BuilderImpl indexReference) {
            this.indexReference = indexReference != null ? indexReference.build() : null;
        }

        @Override
        public final Builder indexReference(ObjectReference indexReference) {
            this.indexReference = indexReference;
            return this;
        }

        public final ObjectReference.Builder getTargetReference() {
            return targetReference != null ? targetReference.toBuilder() : null;
        }

        public final void setTargetReference(ObjectReference.BuilderImpl targetReference) {
            this.targetReference = targetReference != null ? targetReference.build() : null;
        }

        @Override
        public final Builder targetReference(ObjectReference targetReference) {
            this.targetReference = targetReference;
            return this;
        }

        @Override
        public BatchAttachToIndex build() {
            return new BatchAttachToIndex(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
