/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnableMetricsCollectionRequest extends AutoScalingRequest implements
        ToCopyableBuilder<EnableMetricsCollectionRequest.Builder, EnableMetricsCollectionRequest> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoScalingGroupName").getter(getter(EnableMetricsCollectionRequest::autoScalingGroupName))
            .setter(setter(Builder::autoScalingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build())
            .build();

    private static final SdkField<List<String>> METRICS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Metrics")
            .getter(getter(EnableMetricsCollectionRequest::metrics))
            .setter(setter(Builder::metrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> GRANULARITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Granularity").getter(getter(EnableMetricsCollectionRequest::granularity))
            .setter(setter(Builder::granularity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Granularity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD,
            METRICS_FIELD, GRANULARITY_FIELD));

    private final String autoScalingGroupName;

    private final List<String> metrics;

    private final String granularity;

    private EnableMetricsCollectionRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.metrics = builder.metrics;
        this.granularity = builder.granularity;
    }

    /**
     * <p>
     * The name of the Auto Scaling group.
     * </p>
     * 
     * @return The name of the Auto Scaling group.
     */
    public final String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Metrics property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetrics() {
        return metrics != null && !(metrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Identifies the metrics to enable.
     * </p>
     * <p>
     * You can specify one or more of the following metrics:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>GroupMinSize</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GroupMaxSize</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GroupDesiredCapacity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GroupInServiceInstances</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GroupPendingInstances</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GroupStandbyInstances</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GroupTerminatingInstances</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GroupTotalInstances</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GroupInServiceCapacity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GroupPendingCapacity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GroupStandbyCapacity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GroupTerminatingCapacity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GroupTotalCapacity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WarmPoolDesiredCapacity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WarmPoolWarmedCapacity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WarmPoolPendingCapacity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WarmPoolTerminatingCapacity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WarmPoolTotalCapacity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GroupAndWarmPoolDesiredCapacity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GroupAndWarmPoolTotalCapacity</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you specify <code>Granularity</code> and don't specify any metrics, all metrics are enabled.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-cloudwatch-monitoring.html#as-group-metrics"
     * >Auto Scaling group metrics</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetrics} method.
     * </p>
     * 
     * @return Identifies the metrics to enable.</p>
     *         <p>
     *         You can specify one or more of the following metrics:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>GroupMinSize</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GroupMaxSize</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GroupDesiredCapacity</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GroupInServiceInstances</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GroupPendingInstances</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GroupStandbyInstances</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GroupTerminatingInstances</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GroupTotalInstances</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GroupInServiceCapacity</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GroupPendingCapacity</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GroupStandbyCapacity</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GroupTerminatingCapacity</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GroupTotalCapacity</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WarmPoolDesiredCapacity</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WarmPoolWarmedCapacity</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WarmPoolPendingCapacity</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WarmPoolTerminatingCapacity</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WarmPoolTotalCapacity</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GroupAndWarmPoolDesiredCapacity</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GroupAndWarmPoolTotalCapacity</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you specify <code>Granularity</code> and don't specify any metrics, all metrics are enabled.
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-cloudwatch-monitoring.html#as-group-metrics"
     *         >Auto Scaling group metrics</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
     */
    public final List<String> metrics() {
        return metrics;
    }

    /**
     * <p>
     * The frequency at which Amazon EC2 Auto Scaling sends aggregated data to CloudWatch. The only valid value is
     * <code>1Minute</code>.
     * </p>
     * 
     * @return The frequency at which Amazon EC2 Auto Scaling sends aggregated data to CloudWatch. The only valid value
     *         is <code>1Minute</code>.
     */
    public final String granularity() {
        return granularity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetrics() ? metrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(granularity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableMetricsCollectionRequest)) {
            return false;
        }
        EnableMetricsCollectionRequest other = (EnableMetricsCollectionRequest) obj;
        return Objects.equals(autoScalingGroupName(), other.autoScalingGroupName()) && hasMetrics() == other.hasMetrics()
                && Objects.equals(metrics(), other.metrics()) && Objects.equals(granularity(), other.granularity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnableMetricsCollectionRequest").add("AutoScalingGroupName", autoScalingGroupName())
                .add("Metrics", hasMetrics() ? metrics() : null).add("Granularity", granularity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingGroupName":
            return Optional.ofNullable(clazz.cast(autoScalingGroupName()));
        case "Metrics":
            return Optional.ofNullable(clazz.cast(metrics()));
        case "Granularity":
            return Optional.ofNullable(clazz.cast(granularity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnableMetricsCollectionRequest, T> g) {
        return obj -> g.apply((EnableMetricsCollectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, EnableMetricsCollectionRequest> {
        /**
         * <p>
         * The name of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * Identifies the metrics to enable.
         * </p>
         * <p>
         * You can specify one or more of the following metrics:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>GroupMinSize</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupMaxSize</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupDesiredCapacity</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupInServiceInstances</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupPendingInstances</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupStandbyInstances</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupTerminatingInstances</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupTotalInstances</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupInServiceCapacity</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupPendingCapacity</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupStandbyCapacity</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupTerminatingCapacity</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupTotalCapacity</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WarmPoolDesiredCapacity</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WarmPoolWarmedCapacity</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WarmPoolPendingCapacity</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WarmPoolTerminatingCapacity</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WarmPoolTotalCapacity</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupAndWarmPoolDesiredCapacity</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupAndWarmPoolTotalCapacity</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you specify <code>Granularity</code> and don't specify any metrics, all metrics are enabled.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-cloudwatch-monitoring.html#as-group-metrics"
         * >Auto Scaling group metrics</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param metrics
         *        Identifies the metrics to enable.</p>
         *        <p>
         *        You can specify one or more of the following metrics:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>GroupMinSize</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupMaxSize</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupDesiredCapacity</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupInServiceInstances</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupPendingInstances</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupStandbyInstances</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupTerminatingInstances</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupTotalInstances</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupInServiceCapacity</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupPendingCapacity</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupStandbyCapacity</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupTerminatingCapacity</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupTotalCapacity</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WarmPoolDesiredCapacity</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WarmPoolWarmedCapacity</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WarmPoolPendingCapacity</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WarmPoolTerminatingCapacity</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WarmPoolTotalCapacity</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupAndWarmPoolDesiredCapacity</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupAndWarmPoolTotalCapacity</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you specify <code>Granularity</code> and don't specify any metrics, all metrics are enabled.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-cloudwatch-monitoring.html#as-group-metrics"
         *        >Auto Scaling group metrics</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(Collection<String> metrics);

        /**
         * <p>
         * Identifies the metrics to enable.
         * </p>
         * <p>
         * You can specify one or more of the following metrics:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>GroupMinSize</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupMaxSize</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupDesiredCapacity</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupInServiceInstances</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupPendingInstances</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupStandbyInstances</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupTerminatingInstances</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupTotalInstances</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupInServiceCapacity</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupPendingCapacity</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupStandbyCapacity</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupTerminatingCapacity</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupTotalCapacity</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WarmPoolDesiredCapacity</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WarmPoolWarmedCapacity</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WarmPoolPendingCapacity</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WarmPoolTerminatingCapacity</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WarmPoolTotalCapacity</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupAndWarmPoolDesiredCapacity</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupAndWarmPoolTotalCapacity</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you specify <code>Granularity</code> and don't specify any metrics, all metrics are enabled.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-cloudwatch-monitoring.html#as-group-metrics"
         * >Auto Scaling group metrics</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param metrics
         *        Identifies the metrics to enable.</p>
         *        <p>
         *        You can specify one or more of the following metrics:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>GroupMinSize</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupMaxSize</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupDesiredCapacity</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupInServiceInstances</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupPendingInstances</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupStandbyInstances</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupTerminatingInstances</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupTotalInstances</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupInServiceCapacity</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupPendingCapacity</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupStandbyCapacity</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupTerminatingCapacity</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupTotalCapacity</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WarmPoolDesiredCapacity</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WarmPoolWarmedCapacity</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WarmPoolPendingCapacity</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WarmPoolTerminatingCapacity</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WarmPoolTotalCapacity</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupAndWarmPoolDesiredCapacity</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupAndWarmPoolTotalCapacity</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you specify <code>Granularity</code> and don't specify any metrics, all metrics are enabled.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-cloudwatch-monitoring.html#as-group-metrics"
         *        >Auto Scaling group metrics</a> in the <i>Amazon EC2 Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(String... metrics);

        /**
         * <p>
         * The frequency at which Amazon EC2 Auto Scaling sends aggregated data to CloudWatch. The only valid value is
         * <code>1Minute</code>.
         * </p>
         * 
         * @param granularity
         *        The frequency at which Amazon EC2 Auto Scaling sends aggregated data to CloudWatch. The only valid
         *        value is <code>1Minute</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder granularity(String granularity);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private List<String> metrics = DefaultSdkAutoConstructList.getInstance();

        private String granularity;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableMetricsCollectionRequest model) {
            super(model);
            autoScalingGroupName(model.autoScalingGroupName);
            metrics(model.metrics);
            granularity(model.granularity);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final Collection<String> getMetrics() {
            if (metrics instanceof SdkAutoConstructList) {
                return null;
            }
            return metrics;
        }

        public final void setMetrics(Collection<String> metrics) {
            this.metrics = MetricsCopier.copy(metrics);
        }

        @Override
        public final Builder metrics(Collection<String> metrics) {
            this.metrics = MetricsCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(String... metrics) {
            metrics(Arrays.asList(metrics));
            return this;
        }

        public final String getGranularity() {
            return granularity;
        }

        public final void setGranularity(String granularity) {
            this.granularity = granularity;
        }

        @Override
        public final Builder granularity(String granularity) {
            this.granularity = granularity;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EnableMetricsCollectionRequest build() {
            return new EnableMetricsCollectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
