/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluateCodeResponse extends AppSyncResponse implements
        ToCopyableBuilder<EvaluateCodeResponse.Builder, EvaluateCodeResponse> {
    private static final SdkField<String> EVALUATION_RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("evaluationResult").getter(getter(EvaluateCodeResponse::evaluationResult))
            .setter(setter(Builder::evaluationResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationResult").build()).build();

    private static final SdkField<EvaluateCodeErrorDetail> ERROR_FIELD = SdkField
            .<EvaluateCodeErrorDetail> builder(MarshallingType.SDK_POJO).memberName("error")
            .getter(getter(EvaluateCodeResponse::error)).setter(setter(Builder::error))
            .constructor(EvaluateCodeErrorDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final SdkField<List<String>> LOGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("logs")
            .getter(getter(EvaluateCodeResponse::logs))
            .setter(setter(Builder::logs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATION_RESULT_FIELD,
            ERROR_FIELD, LOGS_FIELD));

    private final String evaluationResult;

    private final EvaluateCodeErrorDetail error;

    private final List<String> logs;

    private EvaluateCodeResponse(BuilderImpl builder) {
        super(builder);
        this.evaluationResult = builder.evaluationResult;
        this.error = builder.error;
        this.logs = builder.logs;
    }

    /**
     * <p>
     * The result of the evaluation operation.
     * </p>
     * 
     * @return The result of the evaluation operation.
     */
    public final String evaluationResult() {
        return evaluationResult;
    }

    /**
     * <p>
     * Contains the payload of the response error.
     * </p>
     * 
     * @return Contains the payload of the response error.
     */
    public final EvaluateCodeErrorDetail error() {
        return error;
    }

    /**
     * For responses, this returns true if the service returned a value for the Logs property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasLogs() {
        return logs != null && !(logs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of logs that were generated by calls to <code>util.log.info</code> and <code>util.log.error</code> in the
     * evaluated code.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogs} method.
     * </p>
     * 
     * @return A list of logs that were generated by calls to <code>util.log.info</code> and <code>util.log.error</code>
     *         in the evaluated code.
     */
    public final List<String> logs() {
        return logs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(evaluationResult());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(hasLogs() ? logs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluateCodeResponse)) {
            return false;
        }
        EvaluateCodeResponse other = (EvaluateCodeResponse) obj;
        return Objects.equals(evaluationResult(), other.evaluationResult()) && Objects.equals(error(), other.error())
                && hasLogs() == other.hasLogs() && Objects.equals(logs(), other.logs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluateCodeResponse").add("EvaluationResult", evaluationResult()).add("Error", error())
                .add("Logs", hasLogs() ? logs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "evaluationResult":
            return Optional.ofNullable(clazz.cast(evaluationResult()));
        case "error":
            return Optional.ofNullable(clazz.cast(error()));
        case "logs":
            return Optional.ofNullable(clazz.cast(logs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EvaluateCodeResponse, T> g) {
        return obj -> g.apply((EvaluateCodeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppSyncResponse.Builder, SdkPojo, CopyableBuilder<Builder, EvaluateCodeResponse> {
        /**
         * <p>
         * The result of the evaluation operation.
         * </p>
         * 
         * @param evaluationResult
         *        The result of the evaluation operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationResult(String evaluationResult);

        /**
         * <p>
         * Contains the payload of the response error.
         * </p>
         * 
         * @param error
         *        Contains the payload of the response error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(EvaluateCodeErrorDetail error);

        /**
         * <p>
         * Contains the payload of the response error.
         * </p>
         * This is a convenience method that creates an instance of the {@link EvaluateCodeErrorDetail.Builder} avoiding
         * the need to create one manually via {@link EvaluateCodeErrorDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluateCodeErrorDetail.Builder#build()} is called immediately
         * and its result is passed to {@link #error(EvaluateCodeErrorDetail)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link EvaluateCodeErrorDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(EvaluateCodeErrorDetail)
         */
        default Builder error(Consumer<EvaluateCodeErrorDetail.Builder> error) {
            return error(EvaluateCodeErrorDetail.builder().applyMutation(error).build());
        }

        /**
         * <p>
         * A list of logs that were generated by calls to <code>util.log.info</code> and <code>util.log.error</code> in
         * the evaluated code.
         * </p>
         * 
         * @param logs
         *        A list of logs that were generated by calls to <code>util.log.info</code> and
         *        <code>util.log.error</code> in the evaluated code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logs(Collection<String> logs);

        /**
         * <p>
         * A list of logs that were generated by calls to <code>util.log.info</code> and <code>util.log.error</code> in
         * the evaluated code.
         * </p>
         * 
         * @param logs
         *        A list of logs that were generated by calls to <code>util.log.info</code> and
         *        <code>util.log.error</code> in the evaluated code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logs(String... logs);
    }

    static final class BuilderImpl extends AppSyncResponse.BuilderImpl implements Builder {
        private String evaluationResult;

        private EvaluateCodeErrorDetail error;

        private List<String> logs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluateCodeResponse model) {
            super(model);
            evaluationResult(model.evaluationResult);
            error(model.error);
            logs(model.logs);
        }

        public final String getEvaluationResult() {
            return evaluationResult;
        }

        public final void setEvaluationResult(String evaluationResult) {
            this.evaluationResult = evaluationResult;
        }

        @Override
        public final Builder evaluationResult(String evaluationResult) {
            this.evaluationResult = evaluationResult;
            return this;
        }

        public final EvaluateCodeErrorDetail.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(EvaluateCodeErrorDetail.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(EvaluateCodeErrorDetail error) {
            this.error = error;
            return this;
        }

        public final Collection<String> getLogs() {
            if (logs instanceof SdkAutoConstructList) {
                return null;
            }
            return logs;
        }

        public final void setLogs(Collection<String> logs) {
            this.logs = LogsCopier.copy(logs);
        }

        @Override
        public final Builder logs(Collection<String> logs) {
            this.logs = LogsCopier.copy(logs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logs(String... logs) {
            logs(Arrays.asList(logs));
            return this;
        }

        @Override
        public EvaluateCodeResponse build() {
            return new EvaluateCodeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
