/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateResolverRequest extends AppSyncRequest implements
        ToCopyableBuilder<CreateResolverRequest.Builder, CreateResolverRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("apiId")
            .getter(getter(CreateResolverRequest::apiId)).setter(setter(Builder::apiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()).build();

    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("typeName").getter(getter(CreateResolverRequest::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("typeName").build()).build();

    private static final SdkField<String> FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fieldName").getter(getter(CreateResolverRequest::fieldName)).setter(setter(Builder::fieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldName").build()).build();

    private static final SdkField<String> DATA_SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSourceName").getter(getter(CreateResolverRequest::dataSourceName))
            .setter(setter(Builder::dataSourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceName").build()).build();

    private static final SdkField<String> REQUEST_MAPPING_TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("requestMappingTemplate").getter(getter(CreateResolverRequest::requestMappingTemplate))
            .setter(setter(Builder::requestMappingTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestMappingTemplate").build())
            .build();

    private static final SdkField<String> RESPONSE_MAPPING_TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("responseMappingTemplate").getter(getter(CreateResolverRequest::responseMappingTemplate))
            .setter(setter(Builder::responseMappingTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseMappingTemplate").build())
            .build();

    private static final SdkField<String> KIND_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("kind")
            .getter(getter(CreateResolverRequest::kindAsString)).setter(setter(Builder::kind))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kind").build()).build();

    private static final SdkField<PipelineConfig> PIPELINE_CONFIG_FIELD = SdkField
            .<PipelineConfig> builder(MarshallingType.SDK_POJO).memberName("pipelineConfig")
            .getter(getter(CreateResolverRequest::pipelineConfig)).setter(setter(Builder::pipelineConfig))
            .constructor(PipelineConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineConfig").build()).build();

    private static final SdkField<SyncConfig> SYNC_CONFIG_FIELD = SdkField.<SyncConfig> builder(MarshallingType.SDK_POJO)
            .memberName("syncConfig").getter(getter(CreateResolverRequest::syncConfig)).setter(setter(Builder::syncConfig))
            .constructor(SyncConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syncConfig").build()).build();

    private static final SdkField<CachingConfig> CACHING_CONFIG_FIELD = SdkField
            .<CachingConfig> builder(MarshallingType.SDK_POJO).memberName("cachingConfig")
            .getter(getter(CreateResolverRequest::cachingConfig)).setter(setter(Builder::cachingConfig))
            .constructor(CachingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cachingConfig").build()).build();

    private static final SdkField<Integer> MAX_BATCH_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxBatchSize").getter(getter(CreateResolverRequest::maxBatchSize)).setter(setter(Builder::maxBatchSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBatchSize").build()).build();

    private static final SdkField<AppSyncRuntime> RUNTIME_FIELD = SdkField.<AppSyncRuntime> builder(MarshallingType.SDK_POJO)
            .memberName("runtime").getter(getter(CreateResolverRequest::runtime)).setter(setter(Builder::runtime))
            .constructor(AppSyncRuntime::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtime").build()).build();

    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("code")
            .getter(getter(CreateResolverRequest::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, TYPE_NAME_FIELD,
            FIELD_NAME_FIELD, DATA_SOURCE_NAME_FIELD, REQUEST_MAPPING_TEMPLATE_FIELD, RESPONSE_MAPPING_TEMPLATE_FIELD,
            KIND_FIELD, PIPELINE_CONFIG_FIELD, SYNC_CONFIG_FIELD, CACHING_CONFIG_FIELD, MAX_BATCH_SIZE_FIELD, RUNTIME_FIELD,
            CODE_FIELD));

    private final String apiId;

    private final String typeName;

    private final String fieldName;

    private final String dataSourceName;

    private final String requestMappingTemplate;

    private final String responseMappingTemplate;

    private final String kind;

    private final PipelineConfig pipelineConfig;

    private final SyncConfig syncConfig;

    private final CachingConfig cachingConfig;

    private final Integer maxBatchSize;

    private final AppSyncRuntime runtime;

    private final String code;

    private CreateResolverRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.typeName = builder.typeName;
        this.fieldName = builder.fieldName;
        this.dataSourceName = builder.dataSourceName;
        this.requestMappingTemplate = builder.requestMappingTemplate;
        this.responseMappingTemplate = builder.responseMappingTemplate;
        this.kind = builder.kind;
        this.pipelineConfig = builder.pipelineConfig;
        this.syncConfig = builder.syncConfig;
        this.cachingConfig = builder.cachingConfig;
        this.maxBatchSize = builder.maxBatchSize;
        this.runtime = builder.runtime;
        this.code = builder.code;
    }

    /**
     * <p>
     * The ID for the GraphQL API for which the resolver is being created.
     * </p>
     * 
     * @return The ID for the GraphQL API for which the resolver is being created.
     */
    public final String apiId() {
        return apiId;
    }

    /**
     * <p>
     * The name of the <code>Type</code>.
     * </p>
     * 
     * @return The name of the <code>Type</code>.
     */
    public final String typeName() {
        return typeName;
    }

    /**
     * <p>
     * The name of the field to attach the resolver to.
     * </p>
     * 
     * @return The name of the field to attach the resolver to.
     */
    public final String fieldName() {
        return fieldName;
    }

    /**
     * <p>
     * The name of the data source for which the resolver is being created.
     * </p>
     * 
     * @return The name of the data source for which the resolver is being created.
     */
    public final String dataSourceName() {
        return dataSourceName;
    }

    /**
     * <p>
     * The mapping template to use for requests.
     * </p>
     * <p>
     * A resolver uses a request mapping template to convert a GraphQL expression into a format that a data source can
     * understand. Mapping templates are written in Apache Velocity Template Language (VTL).
     * </p>
     * <p>
     * VTL request mapping templates are optional when using an Lambda data source. For all other data sources, VTL
     * request and response mapping templates are required.
     * </p>
     * 
     * @return The mapping template to use for requests.</p>
     *         <p>
     *         A resolver uses a request mapping template to convert a GraphQL expression into a format that a data
     *         source can understand. Mapping templates are written in Apache Velocity Template Language (VTL).
     *         </p>
     *         <p>
     *         VTL request mapping templates are optional when using an Lambda data source. For all other data sources,
     *         VTL request and response mapping templates are required.
     */
    public final String requestMappingTemplate() {
        return requestMappingTemplate;
    }

    /**
     * <p>
     * The mapping template to use for responses from the data source.
     * </p>
     * 
     * @return The mapping template to use for responses from the data source.
     */
    public final String responseMappingTemplate() {
        return responseMappingTemplate;
    }

    /**
     * <p>
     * The resolver type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is the default resolver type. You can use a UNIT resolver to
     * run a GraphQL query against a single data source.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>PIPELINE</b>: A PIPELINE resolver type. You can use a PIPELINE resolver to invoke a series of
     * <code>Function</code> objects in a serial manner. You can use a pipeline resolver to run a GraphQL query against
     * multiple data sources.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #kind} will return
     * {@link ResolverKind#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #kindAsString}.
     * </p>
     * 
     * @return The resolver type.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is the default resolver type. You can use a UNIT
     *         resolver to run a GraphQL query against a single data source.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>PIPELINE</b>: A PIPELINE resolver type. You can use a PIPELINE resolver to invoke a series of
     *         <code>Function</code> objects in a serial manner. You can use a pipeline resolver to run a GraphQL query
     *         against multiple data sources.
     *         </p>
     *         </li>
     * @see ResolverKind
     */
    public final ResolverKind kind() {
        return ResolverKind.fromValue(kind);
    }

    /**
     * <p>
     * The resolver type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is the default resolver type. You can use a UNIT resolver to
     * run a GraphQL query against a single data source.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>PIPELINE</b>: A PIPELINE resolver type. You can use a PIPELINE resolver to invoke a series of
     * <code>Function</code> objects in a serial manner. You can use a pipeline resolver to run a GraphQL query against
     * multiple data sources.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #kind} will return
     * {@link ResolverKind#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #kindAsString}.
     * </p>
     * 
     * @return The resolver type.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is the default resolver type. You can use a UNIT
     *         resolver to run a GraphQL query against a single data source.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>PIPELINE</b>: A PIPELINE resolver type. You can use a PIPELINE resolver to invoke a series of
     *         <code>Function</code> objects in a serial manner. You can use a pipeline resolver to run a GraphQL query
     *         against multiple data sources.
     *         </p>
     *         </li>
     * @see ResolverKind
     */
    public final String kindAsString() {
        return kind;
    }

    /**
     * <p>
     * The <code>PipelineConfig</code>.
     * </p>
     * 
     * @return The <code>PipelineConfig</code>.
     */
    public final PipelineConfig pipelineConfig() {
        return pipelineConfig;
    }

    /**
     * <p>
     * The <code>SyncConfig</code> for a resolver attached to a versioned data source.
     * </p>
     * 
     * @return The <code>SyncConfig</code> for a resolver attached to a versioned data source.
     */
    public final SyncConfig syncConfig() {
        return syncConfig;
    }

    /**
     * <p>
     * The caching configuration for the resolver.
     * </p>
     * 
     * @return The caching configuration for the resolver.
     */
    public final CachingConfig cachingConfig() {
        return cachingConfig;
    }

    /**
     * <p>
     * The maximum batching size for a resolver.
     * </p>
     * 
     * @return The maximum batching size for a resolver.
     */
    public final Integer maxBatchSize() {
        return maxBatchSize;
    }

    /**
     * Returns the value of the Runtime property for this object.
     * 
     * @return The value of the Runtime property for this object.
     */
    public final AppSyncRuntime runtime() {
        return runtime;
    }

    /**
     * <p>
     * The <code>resolver</code> code that contains the request and response functions. When code is used, the
     * <code>runtime</code> is required. The <code>runtime</code> value must be <code>APPSYNC_JS</code>.
     * </p>
     * 
     * @return The <code>resolver</code> code that contains the request and response functions. When code is used, the
     *         <code>runtime</code> is required. The <code>runtime</code> value must be <code>APPSYNC_JS</code>.
     */
    public final String code() {
        return code;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(apiId());
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(fieldName());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(requestMappingTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(responseMappingTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(kindAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineConfig());
        hashCode = 31 * hashCode + Objects.hashCode(syncConfig());
        hashCode = 31 * hashCode + Objects.hashCode(cachingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(maxBatchSize());
        hashCode = 31 * hashCode + Objects.hashCode(runtime());
        hashCode = 31 * hashCode + Objects.hashCode(code());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResolverRequest)) {
            return false;
        }
        CreateResolverRequest other = (CreateResolverRequest) obj;
        return Objects.equals(apiId(), other.apiId()) && Objects.equals(typeName(), other.typeName())
                && Objects.equals(fieldName(), other.fieldName()) && Objects.equals(dataSourceName(), other.dataSourceName())
                && Objects.equals(requestMappingTemplate(), other.requestMappingTemplate())
                && Objects.equals(responseMappingTemplate(), other.responseMappingTemplate())
                && Objects.equals(kindAsString(), other.kindAsString())
                && Objects.equals(pipelineConfig(), other.pipelineConfig()) && Objects.equals(syncConfig(), other.syncConfig())
                && Objects.equals(cachingConfig(), other.cachingConfig()) && Objects.equals(maxBatchSize(), other.maxBatchSize())
                && Objects.equals(runtime(), other.runtime()) && Objects.equals(code(), other.code());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateResolverRequest").add("ApiId", apiId()).add("TypeName", typeName())
                .add("FieldName", fieldName()).add("DataSourceName", dataSourceName())
                .add("RequestMappingTemplate", requestMappingTemplate())
                .add("ResponseMappingTemplate", responseMappingTemplate()).add("Kind", kindAsString())
                .add("PipelineConfig", pipelineConfig()).add("SyncConfig", syncConfig()).add("CachingConfig", cachingConfig())
                .add("MaxBatchSize", maxBatchSize()).add("Runtime", runtime()).add("Code", code()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "apiId":
            return Optional.ofNullable(clazz.cast(apiId()));
        case "typeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "fieldName":
            return Optional.ofNullable(clazz.cast(fieldName()));
        case "dataSourceName":
            return Optional.ofNullable(clazz.cast(dataSourceName()));
        case "requestMappingTemplate":
            return Optional.ofNullable(clazz.cast(requestMappingTemplate()));
        case "responseMappingTemplate":
            return Optional.ofNullable(clazz.cast(responseMappingTemplate()));
        case "kind":
            return Optional.ofNullable(clazz.cast(kindAsString()));
        case "pipelineConfig":
            return Optional.ofNullable(clazz.cast(pipelineConfig()));
        case "syncConfig":
            return Optional.ofNullable(clazz.cast(syncConfig()));
        case "cachingConfig":
            return Optional.ofNullable(clazz.cast(cachingConfig()));
        case "maxBatchSize":
            return Optional.ofNullable(clazz.cast(maxBatchSize()));
        case "runtime":
            return Optional.ofNullable(clazz.cast(runtime()));
        case "code":
            return Optional.ofNullable(clazz.cast(code()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateResolverRequest, T> g) {
        return obj -> g.apply((CreateResolverRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateResolverRequest> {
        /**
         * <p>
         * The ID for the GraphQL API for which the resolver is being created.
         * </p>
         * 
         * @param apiId
         *        The ID for the GraphQL API for which the resolver is being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiId(String apiId);

        /**
         * <p>
         * The name of the <code>Type</code>.
         * </p>
         * 
         * @param typeName
         *        The name of the <code>Type</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * The name of the field to attach the resolver to.
         * </p>
         * 
         * @param fieldName
         *        The name of the field to attach the resolver to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldName(String fieldName);

        /**
         * <p>
         * The name of the data source for which the resolver is being created.
         * </p>
         * 
         * @param dataSourceName
         *        The name of the data source for which the resolver is being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceName(String dataSourceName);

        /**
         * <p>
         * The mapping template to use for requests.
         * </p>
         * <p>
         * A resolver uses a request mapping template to convert a GraphQL expression into a format that a data source
         * can understand. Mapping templates are written in Apache Velocity Template Language (VTL).
         * </p>
         * <p>
         * VTL request mapping templates are optional when using an Lambda data source. For all other data sources, VTL
         * request and response mapping templates are required.
         * </p>
         * 
         * @param requestMappingTemplate
         *        The mapping template to use for requests.</p>
         *        <p>
         *        A resolver uses a request mapping template to convert a GraphQL expression into a format that a data
         *        source can understand. Mapping templates are written in Apache Velocity Template Language (VTL).
         *        </p>
         *        <p>
         *        VTL request mapping templates are optional when using an Lambda data source. For all other data
         *        sources, VTL request and response mapping templates are required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestMappingTemplate(String requestMappingTemplate);

        /**
         * <p>
         * The mapping template to use for responses from the data source.
         * </p>
         * 
         * @param responseMappingTemplate
         *        The mapping template to use for responses from the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseMappingTemplate(String responseMappingTemplate);

        /**
         * <p>
         * The resolver type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is the default resolver type. You can use a UNIT resolver
         * to run a GraphQL query against a single data source.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>PIPELINE</b>: A PIPELINE resolver type. You can use a PIPELINE resolver to invoke a series of
         * <code>Function</code> objects in a serial manner. You can use a pipeline resolver to run a GraphQL query
         * against multiple data sources.
         * </p>
         * </li>
         * </ul>
         * 
         * @param kind
         *        The resolver type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is the default resolver type. You can use a UNIT
         *        resolver to run a GraphQL query against a single data source.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>PIPELINE</b>: A PIPELINE resolver type. You can use a PIPELINE resolver to invoke a series of
         *        <code>Function</code> objects in a serial manner. You can use a pipeline resolver to run a GraphQL
         *        query against multiple data sources.
         *        </p>
         *        </li>
         * @see ResolverKind
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolverKind
         */
        Builder kind(String kind);

        /**
         * <p>
         * The resolver type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is the default resolver type. You can use a UNIT resolver
         * to run a GraphQL query against a single data source.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>PIPELINE</b>: A PIPELINE resolver type. You can use a PIPELINE resolver to invoke a series of
         * <code>Function</code> objects in a serial manner. You can use a pipeline resolver to run a GraphQL query
         * against multiple data sources.
         * </p>
         * </li>
         * </ul>
         * 
         * @param kind
         *        The resolver type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is the default resolver type. You can use a UNIT
         *        resolver to run a GraphQL query against a single data source.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>PIPELINE</b>: A PIPELINE resolver type. You can use a PIPELINE resolver to invoke a series of
         *        <code>Function</code> objects in a serial manner. You can use a pipeline resolver to run a GraphQL
         *        query against multiple data sources.
         *        </p>
         *        </li>
         * @see ResolverKind
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolverKind
         */
        Builder kind(ResolverKind kind);

        /**
         * <p>
         * The <code>PipelineConfig</code>.
         * </p>
         * 
         * @param pipelineConfig
         *        The <code>PipelineConfig</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineConfig(PipelineConfig pipelineConfig);

        /**
         * <p>
         * The <code>PipelineConfig</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link PipelineConfig.Builder} avoiding the need
         * to create one manually via {@link PipelineConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PipelineConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #pipelineConfig(PipelineConfig)}.
         * 
         * @param pipelineConfig
         *        a consumer that will call methods on {@link PipelineConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipelineConfig(PipelineConfig)
         */
        default Builder pipelineConfig(Consumer<PipelineConfig.Builder> pipelineConfig) {
            return pipelineConfig(PipelineConfig.builder().applyMutation(pipelineConfig).build());
        }

        /**
         * <p>
         * The <code>SyncConfig</code> for a resolver attached to a versioned data source.
         * </p>
         * 
         * @param syncConfig
         *        The <code>SyncConfig</code> for a resolver attached to a versioned data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncConfig(SyncConfig syncConfig);

        /**
         * <p>
         * The <code>SyncConfig</code> for a resolver attached to a versioned data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link SyncConfig.Builder} avoiding the need to
         * create one manually via {@link SyncConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SyncConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #syncConfig(SyncConfig)}.
         * 
         * @param syncConfig
         *        a consumer that will call methods on {@link SyncConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #syncConfig(SyncConfig)
         */
        default Builder syncConfig(Consumer<SyncConfig.Builder> syncConfig) {
            return syncConfig(SyncConfig.builder().applyMutation(syncConfig).build());
        }

        /**
         * <p>
         * The caching configuration for the resolver.
         * </p>
         * 
         * @param cachingConfig
         *        The caching configuration for the resolver.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cachingConfig(CachingConfig cachingConfig);

        /**
         * <p>
         * The caching configuration for the resolver.
         * </p>
         * This is a convenience method that creates an instance of the {@link CachingConfig.Builder} avoiding the need
         * to create one manually via {@link CachingConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CachingConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #cachingConfig(CachingConfig)}.
         * 
         * @param cachingConfig
         *        a consumer that will call methods on {@link CachingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cachingConfig(CachingConfig)
         */
        default Builder cachingConfig(Consumer<CachingConfig.Builder> cachingConfig) {
            return cachingConfig(CachingConfig.builder().applyMutation(cachingConfig).build());
        }

        /**
         * <p>
         * The maximum batching size for a resolver.
         * </p>
         * 
         * @param maxBatchSize
         *        The maximum batching size for a resolver.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxBatchSize(Integer maxBatchSize);

        /**
         * Sets the value of the Runtime property for this object.
         *
         * @param runtime
         *        The new value for the Runtime property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtime(AppSyncRuntime runtime);

        /**
         * Sets the value of the Runtime property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AppSyncRuntime.Builder} avoiding the need
         * to create one manually via {@link AppSyncRuntime#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AppSyncRuntime.Builder#build()} is called immediately and its
         * result is passed to {@link #runtime(AppSyncRuntime)}.
         * 
         * @param runtime
         *        a consumer that will call methods on {@link AppSyncRuntime.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runtime(AppSyncRuntime)
         */
        default Builder runtime(Consumer<AppSyncRuntime.Builder> runtime) {
            return runtime(AppSyncRuntime.builder().applyMutation(runtime).build());
        }

        /**
         * <p>
         * The <code>resolver</code> code that contains the request and response functions. When code is used, the
         * <code>runtime</code> is required. The <code>runtime</code> value must be <code>APPSYNC_JS</code>.
         * </p>
         * 
         * @param code
         *        The <code>resolver</code> code that contains the request and response functions. When code is used,
         *        the <code>runtime</code> is required. The <code>runtime</code> value must be <code>APPSYNC_JS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppSyncRequest.BuilderImpl implements Builder {
        private String apiId;

        private String typeName;

        private String fieldName;

        private String dataSourceName;

        private String requestMappingTemplate;

        private String responseMappingTemplate;

        private String kind;

        private PipelineConfig pipelineConfig;

        private SyncConfig syncConfig;

        private CachingConfig cachingConfig;

        private Integer maxBatchSize;

        private AppSyncRuntime runtime;

        private String code;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResolverRequest model) {
            super(model);
            apiId(model.apiId);
            typeName(model.typeName);
            fieldName(model.fieldName);
            dataSourceName(model.dataSourceName);
            requestMappingTemplate(model.requestMappingTemplate);
            responseMappingTemplate(model.responseMappingTemplate);
            kind(model.kind);
            pipelineConfig(model.pipelineConfig);
            syncConfig(model.syncConfig);
            cachingConfig(model.cachingConfig);
            maxBatchSize(model.maxBatchSize);
            runtime(model.runtime);
            code(model.code);
        }

        public final String getApiId() {
            return apiId;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final String getTypeName() {
            return typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getFieldName() {
            return fieldName;
        }

        public final void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public final Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public final String getDataSourceName() {
            return dataSourceName;
        }

        public final void setDataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
        }

        @Override
        public final Builder dataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
            return this;
        }

        public final String getRequestMappingTemplate() {
            return requestMappingTemplate;
        }

        public final void setRequestMappingTemplate(String requestMappingTemplate) {
            this.requestMappingTemplate = requestMappingTemplate;
        }

        @Override
        public final Builder requestMappingTemplate(String requestMappingTemplate) {
            this.requestMappingTemplate = requestMappingTemplate;
            return this;
        }

        public final String getResponseMappingTemplate() {
            return responseMappingTemplate;
        }

        public final void setResponseMappingTemplate(String responseMappingTemplate) {
            this.responseMappingTemplate = responseMappingTemplate;
        }

        @Override
        public final Builder responseMappingTemplate(String responseMappingTemplate) {
            this.responseMappingTemplate = responseMappingTemplate;
            return this;
        }

        public final String getKind() {
            return kind;
        }

        public final void setKind(String kind) {
            this.kind = kind;
        }

        @Override
        public final Builder kind(String kind) {
            this.kind = kind;
            return this;
        }

        @Override
        public final Builder kind(ResolverKind kind) {
            this.kind(kind == null ? null : kind.toString());
            return this;
        }

        public final PipelineConfig.Builder getPipelineConfig() {
            return pipelineConfig != null ? pipelineConfig.toBuilder() : null;
        }

        public final void setPipelineConfig(PipelineConfig.BuilderImpl pipelineConfig) {
            this.pipelineConfig = pipelineConfig != null ? pipelineConfig.build() : null;
        }

        @Override
        public final Builder pipelineConfig(PipelineConfig pipelineConfig) {
            this.pipelineConfig = pipelineConfig;
            return this;
        }

        public final SyncConfig.Builder getSyncConfig() {
            return syncConfig != null ? syncConfig.toBuilder() : null;
        }

        public final void setSyncConfig(SyncConfig.BuilderImpl syncConfig) {
            this.syncConfig = syncConfig != null ? syncConfig.build() : null;
        }

        @Override
        public final Builder syncConfig(SyncConfig syncConfig) {
            this.syncConfig = syncConfig;
            return this;
        }

        public final CachingConfig.Builder getCachingConfig() {
            return cachingConfig != null ? cachingConfig.toBuilder() : null;
        }

        public final void setCachingConfig(CachingConfig.BuilderImpl cachingConfig) {
            this.cachingConfig = cachingConfig != null ? cachingConfig.build() : null;
        }

        @Override
        public final Builder cachingConfig(CachingConfig cachingConfig) {
            this.cachingConfig = cachingConfig;
            return this;
        }

        public final Integer getMaxBatchSize() {
            return maxBatchSize;
        }

        public final void setMaxBatchSize(Integer maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
        }

        @Override
        public final Builder maxBatchSize(Integer maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
            return this;
        }

        public final AppSyncRuntime.Builder getRuntime() {
            return runtime != null ? runtime.toBuilder() : null;
        }

        public final void setRuntime(AppSyncRuntime.BuilderImpl runtime) {
            this.runtime = runtime != null ? runtime.build() : null;
        }

        @Override
        public final Builder runtime(AppSyncRuntime runtime) {
            this.runtime = runtime;
            return this;
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateResolverRequest build() {
            return new CreateResolverRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
