/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an additional authentication provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdditionalAuthenticationProvider implements SdkPojo, Serializable,
        ToCopyableBuilder<AdditionalAuthenticationProvider.Builder, AdditionalAuthenticationProvider> {
    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authenticationType").getter(getter(AdditionalAuthenticationProvider::authenticationTypeAsString))
            .setter(setter(Builder::authenticationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationType").build())
            .build();

    private static final SdkField<OpenIDConnectConfig> OPEN_ID_CONNECT_CONFIG_FIELD = SdkField
            .<OpenIDConnectConfig> builder(MarshallingType.SDK_POJO).memberName("openIDConnectConfig")
            .getter(getter(AdditionalAuthenticationProvider::openIDConnectConfig)).setter(setter(Builder::openIDConnectConfig))
            .constructor(OpenIDConnectConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openIDConnectConfig").build())
            .build();

    private static final SdkField<CognitoUserPoolConfig> USER_POOL_CONFIG_FIELD = SdkField
            .<CognitoUserPoolConfig> builder(MarshallingType.SDK_POJO).memberName("userPoolConfig")
            .getter(getter(AdditionalAuthenticationProvider::userPoolConfig)).setter(setter(Builder::userPoolConfig))
            .constructor(CognitoUserPoolConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userPoolConfig").build()).build();

    private static final SdkField<LambdaAuthorizerConfig> LAMBDA_AUTHORIZER_CONFIG_FIELD = SdkField
            .<LambdaAuthorizerConfig> builder(MarshallingType.SDK_POJO).memberName("lambdaAuthorizerConfig")
            .getter(getter(AdditionalAuthenticationProvider::lambdaAuthorizerConfig))
            .setter(setter(Builder::lambdaAuthorizerConfig)).constructor(LambdaAuthorizerConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaAuthorizerConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TYPE_FIELD,
            OPEN_ID_CONNECT_CONFIG_FIELD, USER_POOL_CONFIG_FIELD, LAMBDA_AUTHORIZER_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String authenticationType;

    private final OpenIDConnectConfig openIDConnectConfig;

    private final CognitoUserPoolConfig userPoolConfig;

    private final LambdaAuthorizerConfig lambdaAuthorizerConfig;

    private AdditionalAuthenticationProvider(BuilderImpl builder) {
        this.authenticationType = builder.authenticationType;
        this.openIDConnectConfig = builder.openIDConnectConfig;
        this.userPoolConfig = builder.userPoolConfig;
        this.lambdaAuthorizerConfig = builder.lambdaAuthorizerConfig;
    }

    /**
     * <p>
     * The authentication type: API key, Identity and Access Management (IAM), OpenID Connect (OIDC), Amazon Cognito
     * user pools, or Lambda.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The authentication type: API key, Identity and Access Management (IAM), OpenID Connect (OIDC), Amazon
     *         Cognito user pools, or Lambda.
     * @see AuthenticationType
     */
    public final AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(authenticationType);
    }

    /**
     * <p>
     * The authentication type: API key, Identity and Access Management (IAM), OpenID Connect (OIDC), Amazon Cognito
     * user pools, or Lambda.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The authentication type: API key, Identity and Access Management (IAM), OpenID Connect (OIDC), Amazon
     *         Cognito user pools, or Lambda.
     * @see AuthenticationType
     */
    public final String authenticationTypeAsString() {
        return authenticationType;
    }

    /**
     * <p>
     * The OIDC configuration.
     * </p>
     * 
     * @return The OIDC configuration.
     */
    public final OpenIDConnectConfig openIDConnectConfig() {
        return openIDConnectConfig;
    }

    /**
     * <p>
     * The Amazon Cognito user pool configuration.
     * </p>
     * 
     * @return The Amazon Cognito user pool configuration.
     */
    public final CognitoUserPoolConfig userPoolConfig() {
        return userPoolConfig;
    }

    /**
     * <p>
     * Configuration for Lambda function authorization.
     * </p>
     * 
     * @return Configuration for Lambda function authorization.
     */
    public final LambdaAuthorizerConfig lambdaAuthorizerConfig() {
        return lambdaAuthorizerConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(openIDConnectConfig());
        hashCode = 31 * hashCode + Objects.hashCode(userPoolConfig());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaAuthorizerConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdditionalAuthenticationProvider)) {
            return false;
        }
        AdditionalAuthenticationProvider other = (AdditionalAuthenticationProvider) obj;
        return Objects.equals(authenticationTypeAsString(), other.authenticationTypeAsString())
                && Objects.equals(openIDConnectConfig(), other.openIDConnectConfig())
                && Objects.equals(userPoolConfig(), other.userPoolConfig())
                && Objects.equals(lambdaAuthorizerConfig(), other.lambdaAuthorizerConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AdditionalAuthenticationProvider").add("AuthenticationType", authenticationTypeAsString())
                .add("OpenIDConnectConfig", openIDConnectConfig()).add("UserPoolConfig", userPoolConfig())
                .add("LambdaAuthorizerConfig", lambdaAuthorizerConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authenticationType":
            return Optional.ofNullable(clazz.cast(authenticationTypeAsString()));
        case "openIDConnectConfig":
            return Optional.ofNullable(clazz.cast(openIDConnectConfig()));
        case "userPoolConfig":
            return Optional.ofNullable(clazz.cast(userPoolConfig()));
        case "lambdaAuthorizerConfig":
            return Optional.ofNullable(clazz.cast(lambdaAuthorizerConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdditionalAuthenticationProvider, T> g) {
        return obj -> g.apply((AdditionalAuthenticationProvider) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AdditionalAuthenticationProvider> {
        /**
         * <p>
         * The authentication type: API key, Identity and Access Management (IAM), OpenID Connect (OIDC), Amazon Cognito
         * user pools, or Lambda.
         * </p>
         * 
         * @param authenticationType
         *        The authentication type: API key, Identity and Access Management (IAM), OpenID Connect (OIDC), Amazon
         *        Cognito user pools, or Lambda.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(String authenticationType);

        /**
         * <p>
         * The authentication type: API key, Identity and Access Management (IAM), OpenID Connect (OIDC), Amazon Cognito
         * user pools, or Lambda.
         * </p>
         * 
         * @param authenticationType
         *        The authentication type: API key, Identity and Access Management (IAM), OpenID Connect (OIDC), Amazon
         *        Cognito user pools, or Lambda.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(AuthenticationType authenticationType);

        /**
         * <p>
         * The OIDC configuration.
         * </p>
         * 
         * @param openIDConnectConfig
         *        The OIDC configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openIDConnectConfig(OpenIDConnectConfig openIDConnectConfig);

        /**
         * <p>
         * The OIDC configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link OpenIDConnectConfig.Builder} avoiding the
         * need to create one manually via {@link OpenIDConnectConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpenIDConnectConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #openIDConnectConfig(OpenIDConnectConfig)}.
         * 
         * @param openIDConnectConfig
         *        a consumer that will call methods on {@link OpenIDConnectConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openIDConnectConfig(OpenIDConnectConfig)
         */
        default Builder openIDConnectConfig(Consumer<OpenIDConnectConfig.Builder> openIDConnectConfig) {
            return openIDConnectConfig(OpenIDConnectConfig.builder().applyMutation(openIDConnectConfig).build());
        }

        /**
         * <p>
         * The Amazon Cognito user pool configuration.
         * </p>
         * 
         * @param userPoolConfig
         *        The Amazon Cognito user pool configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolConfig(CognitoUserPoolConfig userPoolConfig);

        /**
         * <p>
         * The Amazon Cognito user pool configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link CognitoUserPoolConfig.Builder} avoiding
         * the need to create one manually via {@link CognitoUserPoolConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CognitoUserPoolConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #userPoolConfig(CognitoUserPoolConfig)}.
         * 
         * @param userPoolConfig
         *        a consumer that will call methods on {@link CognitoUserPoolConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userPoolConfig(CognitoUserPoolConfig)
         */
        default Builder userPoolConfig(Consumer<CognitoUserPoolConfig.Builder> userPoolConfig) {
            return userPoolConfig(CognitoUserPoolConfig.builder().applyMutation(userPoolConfig).build());
        }

        /**
         * <p>
         * Configuration for Lambda function authorization.
         * </p>
         * 
         * @param lambdaAuthorizerConfig
         *        Configuration for Lambda function authorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaAuthorizerConfig(LambdaAuthorizerConfig lambdaAuthorizerConfig);

        /**
         * <p>
         * Configuration for Lambda function authorization.
         * </p>
         * This is a convenience method that creates an instance of the {@link LambdaAuthorizerConfig.Builder} avoiding
         * the need to create one manually via {@link LambdaAuthorizerConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LambdaAuthorizerConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #lambdaAuthorizerConfig(LambdaAuthorizerConfig)}.
         * 
         * @param lambdaAuthorizerConfig
         *        a consumer that will call methods on {@link LambdaAuthorizerConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaAuthorizerConfig(LambdaAuthorizerConfig)
         */
        default Builder lambdaAuthorizerConfig(Consumer<LambdaAuthorizerConfig.Builder> lambdaAuthorizerConfig) {
            return lambdaAuthorizerConfig(LambdaAuthorizerConfig.builder().applyMutation(lambdaAuthorizerConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String authenticationType;

        private OpenIDConnectConfig openIDConnectConfig;

        private CognitoUserPoolConfig userPoolConfig;

        private LambdaAuthorizerConfig lambdaAuthorizerConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AdditionalAuthenticationProvider model) {
            authenticationType(model.authenticationType);
            openIDConnectConfig(model.openIDConnectConfig);
            userPoolConfig(model.userPoolConfig);
            lambdaAuthorizerConfig(model.lambdaAuthorizerConfig);
        }

        public final String getAuthenticationType() {
            return authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final OpenIDConnectConfig.Builder getOpenIDConnectConfig() {
            return openIDConnectConfig != null ? openIDConnectConfig.toBuilder() : null;
        }

        public final void setOpenIDConnectConfig(OpenIDConnectConfig.BuilderImpl openIDConnectConfig) {
            this.openIDConnectConfig = openIDConnectConfig != null ? openIDConnectConfig.build() : null;
        }

        @Override
        public final Builder openIDConnectConfig(OpenIDConnectConfig openIDConnectConfig) {
            this.openIDConnectConfig = openIDConnectConfig;
            return this;
        }

        public final CognitoUserPoolConfig.Builder getUserPoolConfig() {
            return userPoolConfig != null ? userPoolConfig.toBuilder() : null;
        }

        public final void setUserPoolConfig(CognitoUserPoolConfig.BuilderImpl userPoolConfig) {
            this.userPoolConfig = userPoolConfig != null ? userPoolConfig.build() : null;
        }

        @Override
        public final Builder userPoolConfig(CognitoUserPoolConfig userPoolConfig) {
            this.userPoolConfig = userPoolConfig;
            return this;
        }

        public final LambdaAuthorizerConfig.Builder getLambdaAuthorizerConfig() {
            return lambdaAuthorizerConfig != null ? lambdaAuthorizerConfig.toBuilder() : null;
        }

        public final void setLambdaAuthorizerConfig(LambdaAuthorizerConfig.BuilderImpl lambdaAuthorizerConfig) {
            this.lambdaAuthorizerConfig = lambdaAuthorizerConfig != null ? lambdaAuthorizerConfig.build() : null;
        }

        @Override
        public final Builder lambdaAuthorizerConfig(LambdaAuthorizerConfig lambdaAuthorizerConfig) {
            this.lambdaAuthorizerConfig = lambdaAuthorizerConfig;
            return this;
        }

        @Override
        public AdditionalAuthenticationProvider build() {
            return new AdditionalAuthenticationProvider(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
